/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client;

import com.tqk114514.craftmusic.CraftMusic;
import com.tqk114514.craftmusic.audio.MiniaudioPlayer;
import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.MusicLibrary;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;

public final class PlaybackController {
    private static volatile PlaybackMode mode = PlaybackController.fromString(ClientConfig.getMode());
    private static final Random RNG = new Random();
    private static volatile boolean endHandled = false;

    private PlaybackController() {
    }

    public static void update(MiniaudioPlayer player) {
        if (player == null || !player.isOutputReady() || !player.isPlaying()) {
            return;
        }
        int len = player.getLengthMs();
        int pos = player.getPositionMs();
        if (len <= 0) {
            return;
        }
        if (pos >= len - 200) {
            if (!endHandled) {
                endHandled = true;
                PlaybackController.onTrackFinished(player);
            }
        } else {
            endHandled = false;
        }
    }

    private static void onTrackFinished(MiniaudioPlayer player) {
        switch (mode.ordinal()) {
            case 3: {
                PlaybackController.replayCurrent(player);
                break;
            }
            case 2: {
                PlaybackController.playRandomNext(player);
                break;
            }
            case 1: {
                PlaybackController.playNextInList(player, true);
                break;
            }
            case 0: {
                PlaybackController.playNextInList(player, false);
            }
        }
    }

    public static void cycleMode() {
        switch (mode.ordinal()) {
            case 0: {
                mode = PlaybackMode.REPEAT_ALL;
                break;
            }
            case 1: {
                mode = PlaybackMode.SHUFFLE;
                break;
            }
            case 2: {
                mode = PlaybackMode.REPEAT_ONE;
                break;
            }
            case 3: {
                mode = PlaybackMode.SEQUENTIAL;
            }
        }
        ClientConfig.setMode(mode.name());
    }

    public static PlaybackMode getMode() {
        return mode;
    }

    public static String modeTranslationKey() {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "craftmusic.mode.sequential";
            case 1 -> "craftmusic.mode.repeat_all";
            case 2 -> "craftmusic.mode.shuffle";
            case 3 -> "craftmusic.mode.repeat_one";
        };
    }

    private static PlaybackMode fromString(String m) {
        if (m == null) {
            return PlaybackMode.REPEAT_ALL;
        }
        try {
            return PlaybackMode.valueOf(m.trim());
        }
        catch (Exception ignored) {
            return PlaybackMode.REPEAT_ALL;
        }
    }

    public static void playNext(MiniaudioPlayer player) {
        switch (mode.ordinal()) {
            case 3: {
                PlaybackController.replayCurrent(player);
                break;
            }
            case 2: {
                PlaybackController.playRandomNext(player);
                break;
            }
            case 1: {
                PlaybackController.playNextInList(player, true);
                break;
            }
            case 0: {
                PlaybackController.playNextInList(player, false);
            }
        }
    }

    public static void playPrev(MiniaudioPlayer player) {
        int idx;
        List<Path> ts = MusicLibrary.getTracks();
        if (ts == null || ts.isEmpty()) {
            return;
        }
        int current = PlaybackController.resolveCurrentIndex(player, ts);
        if (current < 0) {
            current = 0;
        }
        switch (mode.ordinal()) {
            case 2: {
                if (ts.size() == 1) {
                    idx = 0;
                    break;
                }
                while ((idx = RNG.nextInt(ts.size())) == current) {
                }
                break;
            }
            case 3: {
                idx = current;
                break;
            }
            case 0: 
            case 1: {
                idx = (current - 1 + ts.size()) % ts.size();
                break;
            }
            default: {
                idx = current;
            }
        }
        Path p = ts.get(idx);
        CraftMusic.LOGGER.info("Auto prev: {}", (Object)p);
        player.play(p.toAbsolutePath().toString());
    }

    private static void replayCurrent(MiniaudioPlayer player) {
        String last = player.getLastPlayedAbsolutePath();
        if (last != null) {
            player.play(last);
        }
    }

    private static void playRandomNext(MiniaudioPlayer player) {
        int idx;
        List<Path> ts = MusicLibrary.getTracks();
        if (ts == null || ts.isEmpty()) {
            return;
        }
        int current = PlaybackController.resolveCurrentIndex(player, ts);
        if (ts.size() == 1) {
            idx = 0;
        } else {
            while ((idx = RNG.nextInt(ts.size())) == current) {
            }
        }
        Path p = ts.get(idx);
        CraftMusic.LOGGER.info("Auto shuffle next: {}", (Object)p);
        player.play(p.toAbsolutePath().toString());
    }

    private static void playNextInList(MiniaudioPlayer player, boolean wrap) {
        List<Path> ts = MusicLibrary.getTracks();
        if (ts == null || ts.isEmpty()) {
            return;
        }
        int current = PlaybackController.resolveCurrentIndex(player, ts);
        int next = current + 1;
        if (next >= ts.size()) {
            if (!wrap) {
                player.pause();
                return;
            }
            next = 0;
        }
        Path p = ts.get(next);
        CraftMusic.LOGGER.info("Auto next: {}", (Object)p);
        player.play(p.toAbsolutePath().toString());
    }

    private static int resolveCurrentIndex(MiniaudioPlayer player, List<Path> ts) {
        String last = player.getLastPlayedAbsolutePath();
        if (last == null) {
            return -1;
        }
        for (int i = 0; i < ts.size(); ++i) {
            if (!ts.get(i).toAbsolutePath().toString().equalsIgnoreCase(last)) continue;
            return i;
        }
        return -1;
    }

    public static enum PlaybackMode {
        SEQUENTIAL,
        REPEAT_ALL,
        SHUFFLE,
        REPEAT_ONE;

    }
}

