/*
 * Decompiled with CFR 0.152.
 */
package com.tqk114514.craftmusic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tqk114514.craftmusic.CraftMusic;
import com.tqk114514.craftmusic.audio.MiniaudioPlayer;
import com.tqk114514.craftmusic.client.ClientConfig;
import com.tqk114514.craftmusic.client.LrcParser;
import com.tqk114514.craftmusic.client.Lyrics;
import com.tqk114514.craftmusic.client.MusicLibrary;
import com.tqk114514.craftmusic.client.PlaybackController;
import com.tqk114514.craftmusic.client.settings.SettingsScreen;
import java.awt.Desktop;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class QuickPlayScreen
extends Screen {
    private final MiniaudioPlayer player;
    private TrackList trackList;
    private EditBox searchBox;
    private Button prevBtn;
    private Button playToggleBtn;
    private Button nextBtn;
    private Button modeBtn;
    private Button lyricsBtn;
    private Button openFolderBtn;
    private Button settingsBtn;
    private List<MusicLibrary.TrackInfo> filteredTracks = new ArrayList<MusicLibrary.TrackInfo>();
    private int selectedIndex = -1;
    private boolean isPlaying = false;
    private Path currentPath = null;
    private long lastClickMs = 0L;
    private Path lastClickedPath = null;
    private static final int DOUBLE_CLICK_MS = 350;
    private int seekBarX = 2;
    private int seekBarY;
    private int seekBarW;
    private int seekBarH = 6;
    private boolean dragging = false;
    private int pendingSeekMs = -1;
    private int volBarX;
    private int volBarY;
    private int volBarW = 110;
    private int volBarH = 6;
    private boolean draggingVol = false;
    private Lyrics currentLyrics = Lyrics.empty();
    private String lyricsLoadedForPath = null;
    private float lyricScrollPos = -1.0f;
    private float lyricScrollVel = 0.0f;
    private long lyricLastUpdateMs = 0L;
    private static final float SCROLL_SPRING_K = 60.0f;
    private static final float SCROLL_DAMP_C = (float)(2.0 * Math.sqrt(60.0));
    private static final float MAX_DT = 0.05f;
    private int scaleCurrentIndex = -1;
    private int scalePrevIndex = -1;
    private long scaleAnimStartMs = 0L;
    private static final int SCALE_ANIM_MS = 180;
    private boolean noLyricsActive = false;
    private long noLyricsAnimStartMs = 0L;
    private int lyricsTopY;
    private int lyricsBottomY;
    private final float[] spectrumBuf = new float[64];
    private long lastSpectrumFetchMs = 0L;

    public QuickPlayScreen(MiniaudioPlayer player) {
        super((Component)Component.literal((String)"CraftMusic Quick Play"));
        this.player = player;
    }

    protected void init() {
        MusicLibrary.scan();
        int searchBoxHeight = 20;
        int searchBoxY = 40;
        int searchBoxGap = 5;
        int listTop = searchBoxY + searchBoxHeight + searchBoxGap;
        int controlsHeight = 28;
        int listBottomPadding = controlsHeight + 36;
        int listHeight = Math.max(20, this.height - listTop - listBottomPadding);
        int lyricsTop = 40;
        int lyricsHeight = Math.max(20, this.height - lyricsTop - listBottomPadding);
        this.lyricsTopY = lyricsTop;
        this.lyricsBottomY = lyricsTop + lyricsHeight;
        int midGap = 10;
        int rightPadding = 10;
        int leftWidth = (this.width - rightPadding - midGap) / 2;
        this.searchBox = new EditBox(this.font, 2, searchBoxY, leftWidth - 2, searchBoxHeight, (Component)Component.translatable((String)"craftmusic.ui.search"));
        this.searchBox.setHint((Component)Component.translatable((String)"craftmusic.ui.search.hint"));
        this.searchBox.setResponder(text -> this.filterTracks((String)text));
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.trackList = new TrackList(this.minecraft, leftWidth - 2, listHeight, listTop, 20);
        this.addRenderableWidget((GuiEventListener)this.trackList);
        this.filteredTracks = new ArrayList<MusicLibrary.TrackInfo>(MusicLibrary.getTrackInfos());
        int topY = 10;
        int leftPad = 10;
        int rightPad = 10;
        int gap = 5;
        int btnCount = 5;
        int availableW = Math.max(50, this.width - leftPad - rightPad - gap * (btnCount - 1));
        int eachW = Math.max(70, availableW / btnCount);
        int x = leftPad;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.refresh"), b -> {
            MusicLibrary.scan();
            this.filteredTracks = new ArrayList<MusicLibrary.TrackInfo>(MusicLibrary.getTrackInfos());
            this.searchBox.setValue("");
            this.trackList.reloadInfos(this.filteredTracks);
        }).bounds(x, topY, eachW, 20).build());
        boolean floating = ClientConfig.isFloatingLyrics();
        this.lyricsBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)(floating ? "craftmusic.ui.floating_lyrics.on" : "craftmusic.ui.floating_lyrics.off")), b -> {
            boolean cur = ClientConfig.isFloatingLyrics();
            ClientConfig.setFloatingLyrics(!cur);
            boolean now = !cur;
            this.lyricsBtn.setMessage((Component)Component.translatable((String)(now ? "craftmusic.ui.floating_lyrics.on" : "craftmusic.ui.floating_lyrics.off")));
        }).bounds(x += eachW + gap, topY, eachW, 20).build());
        this.openFolderBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.open_folder"), b -> this.openLibraryFolder()).bounds(x += eachW + gap, topY, eachW, 20).build());
        this.settingsBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.settings"), b -> Minecraft.getInstance().setScreen((Screen)new SettingsScreen(this))).bounds(x += eachW + gap, topY, eachW, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.close"), b -> Minecraft.getInstance().setScreen(null)).bounds(x += eachW + gap, topY, eachW, 20).build());
        int bottomY = this.height - controlsHeight;
        int leftPadB = 2;
        int rightPadB = 10;
        int gapB = 5;
        int btnCountB = 5;
        int gapsTotalB = gapB * (btnCountB - 1);
        int availableB = Math.max(100, this.width - leftPadB - rightPadB - gapsTotalB);
        int minVolW = 120;
        int btnW = Math.max(60, (availableB - minVolW) / 4);
        int modeExtra = 20;
        int modeW = btnW + modeExtra;
        int computedVolW = availableB - (btnW * 3 + modeW);
        if (computedVolW < 60) {
            int deficit = 60 - computedVolW;
            modeW = Math.max(60, modeW - deficit);
            computedVolW = 60;
        }
        int xb = leftPadB;
        this.prevBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.prev"), b -> this.playPrev()).bounds(xb, bottomY, btnW, 20).build());
        this.playToggleBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.play"), b -> this.togglePlayPause()).bounds(xb += btnW + gapB, bottomY, btnW, 20).build());
        this.nextBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"craftmusic.ui.next"), b -> this.playNext()).bounds(xb += btnW + gapB, bottomY, btnW, 20).build());
        this.volBarY = bottomY + 7;
        this.volBarX = xb += btnW + gapB;
        this.volBarW = Math.max(60, computedVolW);
        this.modeBtn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), b -> this.cycleMode()).bounds(xb += this.volBarW + gapB, bottomY, modeW, 20).build());
        this.updateModeButtonLabel();
        this.seekBarY = bottomY - 12;
        this.seekBarW = this.width - 2 - 10;
        if (!this.filteredTracks.isEmpty()) {
            this.selectedIndex = 0;
            this.trackList.selectIndex(0);
        }
        this.updateControlsEnabled();
        try {
            if (this.player != null && this.player.isOutputReady()) {
                this.player.setVolume(ClientConfig.getVolume());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.player != null && this.player.isOutputReady()) {
            block11: {
                this.isPlaying = this.player.isPlaying();
                String last = this.player.getLastPlayedAbsolutePath();
                if (last != null && !last.isBlank()) {
                    try {
                        this.currentPath = Paths.get(last, new String[0]);
                        List<Path> ls = MusicLibrary.getTracks();
                        if (ls == null) break block11;
                        for (int i = 0; i < ls.size(); ++i) {
                            if (!ls.get(i).toAbsolutePath().toString().equalsIgnoreCase(last)) continue;
                            this.selectedIndex = i;
                            if (this.trackList != null) {
                                this.trackList.selectIndex(i);
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.updatePlayButtonLabel();
        }
    }

    public void render(@Nonnull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gfx, mouseX, mouseY, partialTick);
        if (ClientConfig.isSpectrumEnabled() && this.player != null && this.player.isOutputReady()) {
            this.drawSpectrumBar(gfx);
        }
        super.render(gfx, mouseX, mouseY, partialTick);
        gfx.drawString(this.font, (Component)Component.translatable((String)"craftmusic.ui.title"), 2, 1, 0xFFFFFF, false);
        if (this.currentPath != null && (this.isPlaying || this.player != null && this.player.isPaused())) {
            String name = this.currentPath.getFileName().toString();
            int textX = 2;
            int textY = this.seekBarY - 12;
            gfx.drawString(this.font, (Component)Component.literal((String)name), textX, textY, 0xFFFFFF, false);
        }
        this.drawSeekBar(gfx, mouseX);
        this.drawVolumeBar(gfx, mouseX);
        this.syncFromPlayer();
        this.drawLyricsPanel(gfx);
    }

    private void drawSpectrumBar(GuiGraphics gfx) {
        int yBottom;
        int bands = 64;
        long now = System.currentTimeMillis();
        if (now - this.lastSpectrumFetchMs >= 33L) {
            try {
                this.player.getSpectrum(this.spectrumBuf, bands);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lastSpectrumFetchMs = now;
        }
        int x0 = 2;
        int x1 = this.width - 10;
        int barAreaHeight = yBottom = this.height - 4;
        int width = x1 - x0;
        int barGap = Math.max(1, width / (bands * 8));
        int barW = Math.max(1, (width - (bands - 1) * barGap) / bands);
        float volScale = this.player != null ? Math.max(0.0f, Math.min(1.0f, this.player.getVolume())) : ClientConfig.getVolume();
        for (int i = 0; i < bands; ++i) {
            float v = this.spectrumBuf[i] * volScale;
            if (v < 0.0f) {
                v = 0.0f;
            }
            if (v > 1.0f) {
                v = 1.0f;
            }
            int h = (int)(v * (float)(barAreaHeight - 4));
            int bx = x0 + i * (barW + barGap);
            int by = yBottom - h;
            int color = -1;
            gfx.fill(bx, by, bx + barW, yBottom, color);
        }
    }

    private void playPrev() {
        if (this.filteredTracks.isEmpty()) {
            return;
        }
        int current = this.resolveCurrentIndexFromFiltered();
        if (current < 0) {
            current = 0;
        }
        int idx = (current - 1 + this.filteredTracks.size()) % this.filteredTracks.size();
        this.playTrack(this.filteredTracks.get(idx).getAudioPath(), idx);
    }

    private void playNext() {
        if (this.filteredTracks.isEmpty()) {
            return;
        }
        int current = this.resolveCurrentIndexFromFiltered();
        if (current < 0) {
            current = -1;
        }
        int idx = (current + 1 + this.filteredTracks.size()) % this.filteredTracks.size();
        this.playTrack(this.filteredTracks.get(idx).getAudioPath(), idx);
    }

    private void togglePlayPause() {
        if (this.player == null || !this.player.isOutputReady()) {
            return;
        }
        if (this.isPlaying && !this.player.isPaused()) {
            this.player.pause();
            this.isPlaying = false;
            this.updatePlayButtonLabel();
            return;
        }
        if (this.player.isPaused()) {
            this.player.resume();
            this.isPlaying = true;
            this.updatePlayButtonLabel();
            return;
        }
        if (this.filteredTracks.isEmpty()) {
            return;
        }
        int idx = this.selectedIndex >= 0 ? this.selectedIndex : 0;
        this.playTrack(this.filteredTracks.get(idx).getAudioPath(), idx);
    }

    private void playTrack(Path p, int idx) {
        if (this.player == null || !this.player.isOutputReady()) {
            return;
        }
        CraftMusic.LOGGER.info("UI play: {}", (Object)p);
        int rc = this.player.play(p.toAbsolutePath().toString());
        if (rc == 0) {
            this.isPlaying = true;
            this.currentPath = p;
            this.selectedIndex = idx;
            if (this.trackList != null) {
                this.trackList.selectIndex(idx);
            }
            this.updateLyricsStateForCurrent();
            this.loadLyricsForCurrent();
        } else {
            this.isPlaying = false;
        }
        this.updatePlayButtonLabel();
        this.updateControlsEnabled();
    }

    private void updatePlayButtonLabel() {
        if (this.playToggleBtn != null) {
            String key = this.player != null && this.player.isPaused() ? "craftmusic.ui.resume" : (this.isPlaying ? "craftmusic.ui.pause" : "craftmusic.ui.play");
            this.playToggleBtn.setMessage((Component)Component.translatable((String)key));
        }
    }

    private void updateControlsEnabled() {
        boolean multi;
        boolean hasTracks = !this.filteredTracks.isEmpty();
        boolean bl = multi = hasTracks && this.filteredTracks.size() > 1;
        if (this.prevBtn != null) {
            this.prevBtn.active = multi;
        }
        if (this.nextBtn != null) {
            this.nextBtn.active = multi;
        }
        if (this.playToggleBtn != null) {
            boolean bl2 = this.playToggleBtn.active = hasTracks && this.player != null && this.player.isOutputReady();
        }
        if (this.modeBtn != null) {
            this.modeBtn.active = hasTracks;
        }
        if (this.openFolderBtn != null) {
            this.openFolderBtn.active = true;
        }
        if (this.lyricsBtn != null) {
            this.lyricsBtn.active = this.hasLyricsForCurrent();
        }
        if (this.settingsBtn != null) {
            this.settingsBtn.active = true;
        }
    }

    private void drawSeekBar(GuiGraphics gfx, int mouseX) {
        int pos;
        int x0 = this.seekBarX;
        int x1 = this.seekBarX + this.seekBarW;
        int y = this.seekBarY;
        gfx.fill(x0, y, x1, y + this.seekBarH, Integer.MIN_VALUE);
        int len = this.player != null ? this.player.getLengthMs() : 0;
        int n = pos = this.player != null ? this.player.getPositionMs() : 0;
        if (this.dragging && this.pendingSeekMs >= 0) {
            pos = this.pendingSeekMs;
        }
        float pct = len > 0 ? Math.min(1.0f, Math.max(0.0f, (float)pos / (float)len)) : 0.0f;
        int knobX = x0 + Math.round(pct * (float)this.seekBarW);
        gfx.fill(x0, y, knobX, y + this.seekBarH, -16733441);
        gfx.fill(knobX - 2, y - 2, knobX + 2, y + this.seekBarH + 2, -1);
        String timeStr = QuickPlayScreen.formatTime(pos) + " / " + QuickPlayScreen.formatTime(len);
        gfx.drawString(this.font, timeStr, x1 - Math.max(60, this.font.width(timeStr)), y - 10, -1, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseY >= (double)(this.seekBarY - 4) && mouseY <= (double)(this.seekBarY + this.seekBarH + 4) && mouseX >= (double)this.seekBarX && mouseX <= (double)(this.seekBarX + this.seekBarW)) {
                this.dragging = true;
                this.updatePendingSeek((int)mouseX);
                return true;
            }
            if (mouseY >= (double)(this.volBarY - 4) && mouseY <= (double)(this.volBarY + this.volBarH + 4) && mouseX >= (double)this.volBarX && mouseX <= (double)(this.volBarX + this.volBarW)) {
                this.draggingVol = true;
                this.updateVolumeFromMouse((int)mouseX);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.dragging && button == 0) {
            this.updatePendingSeek((int)mouseX);
            return true;
        }
        if (this.draggingVol && button == 0) {
            this.updateVolumeFromMouse((int)mouseX);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0) {
            this.dragging = false;
            if (this.player != null && this.player.isOutputReady() && this.pendingSeekMs >= 0) {
                this.player.seekToMs(this.pendingSeekMs);
                if (this.player.isPaused()) {
                    this.player.resume();
                    this.isPlaying = true;
                    this.updatePlayButtonLabel();
                }
                this.syncFromPlayer();
            }
            this.pendingSeekMs = -1;
            return true;
        }
        if (this.draggingVol && button == 0) {
            this.draggingVol = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void updatePendingSeek(int mouseX) {
        int target;
        if (this.player == null || !this.player.isOutputReady()) {
            return;
        }
        int x0 = this.seekBarX;
        int rel = Math.max(0, Math.min(this.seekBarW, mouseX - x0));
        int len = this.player.getLengthMs();
        this.pendingSeekMs = target = len > 0 ? (int)((float)rel / (float)this.seekBarW * (float)len) : 0;
    }

    private void drawVolumeBar(GuiGraphics gfx, int mouseX) {
        int x0 = this.volBarX;
        int x1 = this.volBarX + this.volBarW;
        int y = this.volBarY;
        gfx.fill(x0, y, x1, y + this.volBarH, Integer.MIN_VALUE);
        float vol = ClientConfig.getVolume();
        int filled = x0 + Math.round(vol * (float)this.volBarW);
        gfx.fill(x0, y, filled, y + this.volBarH, -20480);
        gfx.fill(filled - 2, y - 2, filled + 2, y + this.volBarH + 2, -1);
        String label = Component.translatable((String)"craftmusic.ui.volume").getString();
        String percent = Math.round(vol * 100.0f) + "%";
        int textY = y - 9;
        gfx.drawString(this.font, label, x0, textY, -1, false);
        gfx.drawString(this.font, percent, x1 - this.font.width(percent), textY, -1, false);
    }

    private void updateVolumeFromMouse(int mouseX) {
        int x0 = this.volBarX;
        int rel = Math.max(0, Math.min(this.volBarW, mouseX - x0));
        float v = (float)rel / (float)this.volBarW;
        if (this.player != null && this.player.isOutputReady()) {
            this.player.setVolume(v);
        }
        ClientConfig.setVolume(v);
    }

    private static String formatTime(int ms) {
        int totalSec = Math.max(0, ms / 1000);
        int m = totalSec / 60;
        int s = totalSec % 60;
        return String.format("%d:%02d", m, s);
    }

    private void loadLyricsForCurrent() {
        try {
            if (this.currentPath == null) {
                this.currentLyrics = Lyrics.empty();
                this.lyricsLoadedForPath = null;
                return;
            }
            String cur = this.currentPath.toAbsolutePath().toString();
            if (cur.equalsIgnoreCase(this.lyricsLoadedForPath)) {
                return;
            }
            List<MusicLibrary.TrackInfo> infos = MusicLibrary.getTrackInfos();
            Lyrics loaded = Lyrics.empty();
            if (infos != null) {
                for (MusicLibrary.TrackInfo info : infos) {
                    if (info == null || info.getAudioPath() == null || !info.getAudioPath().toAbsolutePath().toString().equalsIgnoreCase(cur)) continue;
                    Path lrc = info.getLyricsPath();
                    if (lrc == null) break;
                    loaded = LrcParser.parse(lrc);
                    break;
                }
            }
            this.currentLyrics = loaded;
            this.lyricsLoadedForPath = cur;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawLyricsPanel(GuiGraphics gfx) {
        List<Lyrics.Line> lines;
        int gap = 10;
        int rightPadding = 10;
        int leftWidth = (this.width - rightPadding - gap) / 2;
        int x0 = leftWidth + gap;
        int x1 = this.width - 10;
        int top = this.lyricsTopY;
        int bottom = this.lyricsBottomY;
        gfx.fill(x0, top, x1, bottom, -1879048192);
        List<Lyrics.Line> list = lines = this.currentLyrics != null ? this.currentLyrics.getLines() : Collections.emptyList();
        if (lines.isEmpty()) {
            String txt = Component.translatable((String)"craftmusic.ui.no_lyrics_or_instrumental").getString();
            int n = this.lyricsTopY + 8 + (this.lyricsBottomY - this.lyricsTopY - 16) / 2;
            Objects.requireNonNull(this.font);
            int centerY = n - 9 / 2;
            int midX = (x0 + x1) / 2;
            if (ClientConfig.isLyricEffects()) {
                float t;
                long now = System.currentTimeMillis();
                if (!this.noLyricsActive) {
                    this.noLyricsActive = true;
                    this.noLyricsAnimStartMs = now;
                }
                float eased = (t = Math.max(0.0f, Math.min(1.0f, (float)(now - this.noLyricsAnimStartMs) / 180.0f))) < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
                float scale = 1.0f + 0.08f * eased;
                this.drawCenteredScaledString(gfx, txt, midX, centerY, scale, -1);
            } else {
                this.noLyricsActive = false;
                int tx = midX - this.font.width(txt) / 2;
                gfx.drawString(this.font, txt, tx, centerY, -1, false);
            }
            return;
        }
        this.noLyricsActive = false;
        int curMs = this.player != null ? this.player.getPositionMs() : 0;
        int curIdx = this.findCurrentLineIndex(lines, curMs);
        long now = System.currentTimeMillis();
        if (!ClientConfig.isLyricEffects()) {
            this.lyricScrollPos = curIdx < 0 ? 0.0f : (float)Math.min(curIdx, lines.size() - 1);
            this.lyricScrollVel = 0.0f;
            this.lyricLastUpdateMs = now;
        } else if (this.lyricLastUpdateMs == 0L || this.lyricScrollPos < 0.0f) {
            this.lyricScrollPos = curIdx < 0 ? 0.0f : (float)Math.min(curIdx, lines.size() - 1);
            this.lyricScrollVel = 0.0f;
            this.lyricLastUpdateMs = now;
        } else {
            float target;
            float f = target = curIdx < 0 ? 0.0f : (float)Math.min(curIdx, lines.size() - 1);
            if (Math.abs(target - this.lyricScrollPos) > 3.0f) {
                this.lyricScrollPos = target;
                this.lyricScrollVel = 0.0f;
            } else {
                float dt = Math.min(0.05f, (float)(now - this.lyricLastUpdateMs) / 1000.0f);
                float delta = target - this.lyricScrollPos;
                float accel = 60.0f * delta - SCROLL_DAMP_C * this.lyricScrollVel;
                this.lyricScrollVel += accel * dt;
                this.lyricScrollPos += this.lyricScrollVel * dt;
            }
            this.lyricLastUpdateMs = now;
        }
        Objects.requireNonNull(this.font);
        int lineH = 9 + 2;
        int n = this.lyricsTopY + 8 + (this.lyricsBottomY - this.lyricsTopY - 16) / 2;
        Objects.requireNonNull(this.font);
        int centerY = n - 9 / 2;
        int midX = (x0 + x1) / 2;
        if (ClientConfig.isLyricEffects()) {
            if (this.scaleCurrentIndex != curIdx) {
                this.scalePrevIndex = this.scaleCurrentIndex;
                this.scaleCurrentIndex = curIdx;
                this.scaleAnimStartMs = now;
            }
        } else {
            this.scaleCurrentIndex = -1;
            this.scalePrevIndex = -1;
        }
        float drawCenterIndex = this.lyricScrollPos < 0.0f ? (curIdx < 0 ? 0.0f : (float)curIdx) : this.lyricScrollPos;
        int visiblePx = Math.max(0, this.lyricsBottomY - this.lyricsTopY - 16);
        int approxVisibleLines = Math.max(1, visiblePx / lineH + 1);
        int half = approxVisibleLines / 2;
        int firstIdx = Math.max(0, (int)Math.floor(drawCenterIndex) - half);
        int lastIdx = Math.min(lines.size() - 1, (int)Math.ceil(drawCenterIndex) + half);
        int textTopBound = this.lyricsTopY + 8;
        Objects.requireNonNull(this.font);
        int textBottomBound = this.lyricsBottomY - 8 - 9;
        for (int i = firstIdx; i <= lastIdx; ++i) {
            float eased;
            int color;
            float diff = (float)i - drawCenterIndex;
            int y = Math.round((float)centerY + diff * (float)lineH);
            if (y < textTopBound || y > textBottomBound) continue;
            String text = lines.get((int)i).text;
            int tx = midX - this.font.width(text) / 2;
            int n2 = color = i == curIdx ? -1 : -5592406;
            if (!ClientConfig.isLyricEffects()) {
                gfx.drawString(this.font, text, tx, y, color, false);
                continue;
            }
            float t = Math.max(0.0f, Math.min(1.0f, (float)(now - this.scaleAnimStartMs) / 180.0f));
            float f = eased = t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
            float scale = i == this.scaleCurrentIndex ? 1.0f + 0.08f * eased : (i == this.scalePrevIndex ? 1.08f - 0.08f * eased : 1.0f);
            this.drawCenteredScaledString(gfx, text, midX, y, scale, color);
        }
    }

    private int findCurrentLineIndex(List<Lyrics.Line> lines, int curMs) {
        if (lines == null || lines.isEmpty()) {
            return -1;
        }
        int lo = 0;
        int hi = lines.size() - 1;
        int ans = -1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int t = lines.get((int)mid).timeMs;
            if (t <= curMs) {
                ans = mid;
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return ans;
    }

    private void drawCenteredScaledString(GuiGraphics gfx, String text, int midX, int y, float scale, int argb) {
        if (scale <= 0.0f) {
            return;
        }
        if (Math.abs(scale - 1.0f) < 0.001f) {
            int tx = midX - this.font.width(text) / 2;
            gfx.drawString(this.font, text, tx, y, argb, false);
            return;
        }
        PoseStack pose = gfx.pose();
        pose.pushPose();
        float textW = this.font.width(text);
        float scaledW = textW * scale;
        float tx = (float)midX - scaledW / 2.0f;
        pose.translate(tx, (float)y, 0.0f);
        pose.scale(scale, scale, 1.0f);
        gfx.drawString(this.font, text, 0, 0, argb, false);
        pose.popPose();
    }

    private void filterTracks(String searchText) {
        if (searchText == null || searchText.isBlank()) {
            this.filteredTracks = new ArrayList<MusicLibrary.TrackInfo>(MusicLibrary.getTrackInfos());
        } else {
            String lowerSearch = searchText.toLowerCase(Locale.ROOT);
            this.filteredTracks = MusicLibrary.getTrackInfos().stream().filter(info -> {
                String fileName = info.getAudioPath().getFileName().toString().toLowerCase(Locale.ROOT);
                return fileName.contains(lowerSearch);
            }).collect(Collectors.toList());
        }
        this.trackList.reloadFilteredInfos(this.filteredTracks);
    }

    private int resolveCurrentIndexFromFiltered() {
        if (this.currentPath == null) {
            return -1;
        }
        String current = this.currentPath.toAbsolutePath().toString();
        for (int i = 0; i < this.filteredTracks.size(); ++i) {
            if (!this.filteredTracks.get(i).getAudioPath().toAbsolutePath().toString().equalsIgnoreCase(current)) continue;
            return i;
        }
        return -1;
    }

    private void cycleMode() {
        PlaybackController.cycleMode();
        this.updateModeButtonLabel();
    }

    private void updateModeButtonLabel() {
        if (this.modeBtn == null) {
            return;
        }
        String key = PlaybackController.modeTranslationKey();
        this.modeBtn.setMessage((Component)Component.translatable((String)"craftmusic.ui.mode", (Object[])new Object[]{Component.translatable((String)key)}));
    }

    private void syncFromPlayer() {
        if (this.player == null) {
            return;
        }
        String last = this.player.getLastPlayedAbsolutePath();
        if (last != null && !last.isBlank()) {
            if (this.currentPath == null || !this.currentPath.toAbsolutePath().toString().equalsIgnoreCase(last)) {
                try {
                    this.currentPath = Paths.get(last, new String[0]);
                    List<Path> ls = MusicLibrary.getTracks();
                    if (ls != null) {
                        for (int i = 0; i < ls.size(); ++i) {
                            if (!ls.get(i).toAbsolutePath().toString().equalsIgnoreCase(last)) continue;
                            this.selectedIndex = i;
                            if (this.trackList == null) break;
                            this.trackList.selectIndex(i);
                            break;
                        }
                    }
                    this.loadLyricsForCurrent();
                }
                catch (Exception ls) {}
            } else if (this.currentPath != null) {
                String cur = this.currentPath.toAbsolutePath().toString();
                if (this.lyricsLoadedForPath == null || !this.lyricsLoadedForPath.equalsIgnoreCase(cur)) {
                    this.loadLyricsForCurrent();
                }
            }
        }
        this.isPlaying = this.player.isPlaying();
        this.updatePlayButtonLabel();
        this.refreshLyricsControls();
    }

    private boolean hasLyricsForCurrent() {
        if (this.currentPath == null) {
            return false;
        }
        List<MusicLibrary.TrackInfo> infos = MusicLibrary.getTrackInfos();
        if (infos == null || infos.isEmpty()) {
            return false;
        }
        String cur = this.currentPath.toAbsolutePath().toString();
        for (MusicLibrary.TrackInfo info : infos) {
            String p;
            if (info == null || info.getAudioPath() == null || !(p = info.getAudioPath().toAbsolutePath().toString()).equalsIgnoreCase(cur)) continue;
            return info.hasLyrics();
        }
        return false;
    }

    private void updateLyricsStateForCurrent() {
        this.refreshLyricsControls();
    }

    private void refreshLyricsControls() {
        if (this.lyricsBtn != null) {
            this.lyricsBtn.active = true;
        }
    }

    private void openLibraryFolder() {
        try {
            MusicLibrary.ensureFolderExists();
            Path dir = MusicLibrary.getLibraryDir();
            if (dir == null) {
                return;
            }
            String path = dir.toAbsolutePath().toString();
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(dir.toFile());
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            new ProcessBuilder("explorer", path).start();
        }
        catch (Exception e) {
            CraftMusic.LOGGER.warn("Open folder failed: {}", (Object)e.toString());
        }
    }

    class TrackList
    extends ObjectSelectionList<TrackEntry> {
        private final int left = 2;
        private final int listWidth;

        public TrackList(Minecraft mc, int width, int height, int top, int itemHeight) {
            super(mc, width, height, top, itemHeight);
            this.left = 2;
            this.listWidth = width;
            this.reloadInfos(MusicLibrary.getTrackInfos());
        }

        public int getRowLeft() {
            return this.left;
        }

        protected int getScrollbarPosition() {
            return this.left + this.listWidth - 6;
        }

        public int getRowWidth() {
            return this.listWidth - 8;
        }

        void reload(List<Path> paths) {
            this.clearEntries();
            int i = 0;
            for (Path p : paths) {
                this.addEntry((AbstractSelectionList.Entry)new TrackEntry(this, p, i++));
            }
            if (QuickPlayScreen.this.selectedIndex >= 0 && QuickPlayScreen.this.selectedIndex < this.getItemCount()) {
                this.setSelected((AbstractSelectionList.Entry)((TrackEntry)this.getEntry(QuickPlayScreen.this.selectedIndex)));
            }
            QuickPlayScreen.this.updateControlsEnabled();
        }

        void reloadInfos(List<MusicLibrary.TrackInfo> infos) {
            this.clearEntries();
            int i = 0;
            for (MusicLibrary.TrackInfo info : infos) {
                this.addEntry((AbstractSelectionList.Entry)new TrackEntry(this, info.getAudioPath(), i++, info.hasLyrics()));
            }
            if (QuickPlayScreen.this.selectedIndex >= 0 && QuickPlayScreen.this.selectedIndex < this.getItemCount()) {
                this.setSelected((AbstractSelectionList.Entry)((TrackEntry)this.getEntry(QuickPlayScreen.this.selectedIndex)));
            }
            QuickPlayScreen.this.updateControlsEnabled();
        }

        void reloadFilteredInfos(List<MusicLibrary.TrackInfo> infos) {
            this.clearEntries();
            int i = 0;
            for (MusicLibrary.TrackInfo info : infos) {
                this.addEntry((AbstractSelectionList.Entry)new TrackEntry(this, info.getAudioPath(), i++, info.hasLyrics()));
            }
            if (!infos.isEmpty()) {
                QuickPlayScreen.this.selectedIndex = 0;
                this.setSelected((AbstractSelectionList.Entry)((TrackEntry)this.getEntry(0)));
            }
            QuickPlayScreen.this.updateControlsEnabled();
        }

        void selectIndex(int index) {
            if (index >= 0 && index < this.getItemCount()) {
                this.setSelected((AbstractSelectionList.Entry)((TrackEntry)this.getEntry(index)));
            }
            QuickPlayScreen.this.updateControlsEnabled();
        }
    }

    class TrackEntry
    extends ObjectSelectionList.Entry<TrackEntry> {
        private final Path path;
        private final TrackList parent;
        private final int index;
        private final boolean hasLyrics;

        TrackEntry(TrackList parent, Path path, int index) {
            this.parent = parent;
            this.path = path;
            this.index = index;
            this.hasLyrics = false;
        }

        TrackEntry(TrackList parent, Path path, int index, boolean hasLyrics) {
            this.parent = parent;
            this.path = path;
            this.index = index;
            this.hasLyrics = hasLyrics;
        }

        public void render(@Nonnull GuiGraphics gfx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            String name = this.path.getFileName().toString();
            String suffix = this.hasLyrics ? Component.translatable((String)"craftmusic.ui.has_lyrics").getString() : Component.translatable((String)"craftmusic.ui.no_lyrics").getString();
            Objects.requireNonNull(QuickPlayScreen.this.font);
            int fh = 9;
            int textY = y + Math.max(0, (entryHeight - fh) / 2);
            int textX = x + 6;
            gfx.drawString(QuickPlayScreen.this.font, name + "  [" + suffix + "]", textX, textY, 0xFFFFFF, false);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return false;
            }
            this.parent.setSelected((AbstractSelectionList.Entry)this);
            QuickPlayScreen.this.selectedIndex = this.index;
            long now = System.currentTimeMillis();
            boolean isDoubleClick = QuickPlayScreen.this.lastClickedPath != null && QuickPlayScreen.this.lastClickedPath.equals(this.path) && now - QuickPlayScreen.this.lastClickMs <= 350L;
            QuickPlayScreen.this.lastClickedPath = this.path;
            QuickPlayScreen.this.lastClickMs = now;
            if (isDoubleClick) {
                QuickPlayScreen.this.playTrack(this.path, this.index);
            }
            return true;
        }

        @Nonnull
        public Component getNarration() {
            String name = this.path.getFileName().toString();
            String suffix = this.hasLyrics ? Component.translatable((String)"craftmusic.ui.has_lyrics").getString() : Component.translatable((String)"craftmusic.ui.no_lyrics").getString();
            return Component.literal((String)(name + " [" + suffix + "]"));
        }
    }
}

