/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.layers.player;

import aquariusplayz.animalgarden.owl.interfaces.IOwlOnShoulder;
import aquariusplayz.animalgarden.owl.mob.owl.ModMobModel;
import aquariusplayz.animalgarden.owl.mob.owl.ModMobRenderState;
import aquariusplayz.animalgarden.owl.mob.owl.ModMobRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EntityType;

public class OwlOnShoulderLayer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    private final ModMobModel model;
    private final ModMobModel baby;
    private final ModMobRenderState mobState = new ModMobRenderState();

    public OwlOnShoulderLayer(RenderLayerParent<PlayerRenderState, PlayerModel> p_117346_, EntityModelSet entityModelSet) {
        super(p_117346_);
        this.model = new ModMobModel(entityModelSet.bakeLayer(ModMobModel.LAYER_LOCATION));
        this.baby = new ModMobModel(entityModelSet.bakeLayer(ModMobModel.BABY_LAYER_LOCATION));
        this.mobState.pose = ModMobModel.Pose.ON_SHOULDER;
    }

    public void render(PoseStack p_117318_, MultiBufferSource p_117319_, int p_117320_, PlayerRenderState p_365020_, float p_117322_, float p_117323_) {
        boolean right;
        if (p_365020_.entityType != EntityType.PLAYER) {
            return;
        }
        boolean left = ((IOwlOnShoulder)p_365020_).getOwlOnLeftShoulder();
        if (left) {
            this.renderOnShoulder(p_117318_, p_117319_, p_117320_, p_365020_, left, p_117322_, p_117323_, true);
        }
        if (right = ((IOwlOnShoulder)p_365020_).getOwlOnRightShoulder()) {
            this.renderOnShoulder(p_117318_, p_117319_, p_117320_, p_365020_, right, p_117322_, p_117323_, false);
        }
    }

    private void renderOnShoulder(PoseStack p_366319_, MultiBufferSource p_366949_, int p_369936_, PlayerRenderState p_361438_, boolean p_369073_, float p_363523_, float p_366258_, boolean side) {
        p_366319_.pushPose();
        p_366319_.translate(side ? 0.4f : -0.4f, p_361438_.isCrouching ? -1.3f : -1.5f, 0.0f);
        this.mobState.isOnPlayer = true;
        this.mobState.ageInTicks = p_361438_.ageInTicks;
        this.mobState.walkAnimationPos = p_361438_.walkAnimationPos;
        this.mobState.walkAnimationSpeed = p_361438_.walkAnimationSpeed;
        this.mobState.yRot = p_363523_;
        this.mobState.xRot = p_366258_;
        if (side) {
            this.mobState.rotateHeadAnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getRotateHeadAnimationStateLeft());
            this.mobState.winkAnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getWinkAnimationStateLeft());
            this.mobState.dance2AnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getDanceAnimationStateLeft());
            this.mobState.owlColor = ((IOwlOnShoulder)p_361438_).getLeftOwlcolor();
            this.mobState.isBaby = ((IOwlOnShoulder)p_361438_).isLeftBaby();
        } else {
            this.mobState.rotateHeadAnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getRotateHeadAnimationStateRight());
            this.mobState.winkAnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getWinkAnimationStateRight());
            this.mobState.dance2AnimationState.copyFrom(((IOwlOnShoulder)p_361438_).getDanceAnimationStateRight());
            this.mobState.owlColor = ((IOwlOnShoulder)p_361438_).getRightOwlcolor();
            this.mobState.isBaby = ((IOwlOnShoulder)p_361438_).isRightBaby();
        }
        if (this.mobState.isBaby) {
            this.baby.setupShoulderAnim(this.mobState);
            this.baby.renderToBuffer(p_366319_, p_366949_.getBuffer(this.baby.renderType(this.mobState.owlColor == 1 ? ModMobRenderer.SNOWY : ModMobRenderer.DEFAULT)), p_369936_, OverlayTexture.NO_OVERLAY);
        } else {
            this.model.setupShoulderAnim(this.mobState);
            this.model.renderToBuffer(p_366319_, p_366949_.getBuffer(this.model.renderType(this.mobState.owlColor == 1 ? ModMobRenderer.SNOWY : ModMobRenderer.DEFAULT)), p_369936_, OverlayTexture.NO_OVERLAY);
        }
        p_366319_.popPose();
    }
}

