/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.mixin;

import aquariusplayz.animalgarden.owl.interfaces.IOwlOnShoulder;
import aquariusplayz.animalgarden.owl.setup.Registrations;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerMixin
extends LivingEntity
implements IOwlOnShoulder {
    public final AnimationState danceLeftAnimationState = new AnimationState();
    public final AnimationState danceRightAnimationState = new AnimationState();
    public final AnimationState rotateHeadAnimationStateLeft = new AnimationState();
    public final AnimationState winkAnimationStateLeft = new AnimationState();
    public final AnimationState rotateHeadAnimationStateRight = new AnimationState();
    public final AnimationState winkAnimationStateRight = new AnimationState();

    @Shadow
    public abstract CompoundTag getShoulderEntityLeft();

    @Shadow
    public abstract CompoundTag getShoulderEntityRight();

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    public boolean animationEnded(AnimationState state, float animLength) {
        return (float)state.getTimeInMillis((float)this.tickCount) > animLength * 1000.0f;
    }

    @Override
    public AnimationState getRotateHeadAnimationStateLeft() {
        return this.rotateHeadAnimationStateLeft;
    }

    @Override
    public AnimationState getWinkAnimationStateLeft() {
        return this.winkAnimationStateLeft;
    }

    @Override
    public AnimationState getRotateHeadAnimationStateRight() {
        return this.rotateHeadAnimationStateRight;
    }

    @Override
    public AnimationState getWinkAnimationStateRight() {
        return this.winkAnimationStateRight;
    }

    @Override
    public AnimationState getDanceAnimationStateLeft() {
        return this.danceLeftAnimationState;
    }

    @Override
    public AnimationState getDanceAnimationStateRight() {
        return this.danceRightAnimationState;
    }

    public void setRecordPlayingNearby(BlockPos p_21082_, boolean p_21083_) {
        super.setRecordPlayingNearby(p_21082_, p_21083_);
        Player player = (Player)this;
        if (player.level().isClientSide()) {
            if (p_21083_) {
                CompoundTag left = this.getShoulderEntityLeft();
                EntityType entitytype = left.read("id", EntityType.CODEC).orElse(null);
                CompoundTag right = this.getShoulderEntityRight();
                EntityType entitytype2 = right.read("id", EntityType.CODEC).orElse(null);
                if (entitytype == Registrations.MOB.get()) {
                    this.danceLeftAnimationState.startIfStopped(player.tickCount);
                }
                if (entitytype2 == Registrations.MOB.get()) {
                    this.danceRightAnimationState.startIfStopped(player.tickCount);
                }
            } else {
                if (this.danceLeftAnimationState.isStarted()) {
                    this.danceLeftAnimationState.stop();
                }
                if (this.danceRightAnimationState.isStarted()) {
                    this.danceRightAnimationState.stop();
                }
            }
        }
    }
}

