/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.mixin;

import aquariusplayz.animalgarden.owl.interfaces.IOwlOnShoulder;
import aquariusplayz.animalgarden.owl.layers.player.OwlOnShoulderLayer;
import aquariusplayz.animalgarden.owl.setup.Registrations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class}, remap=false)
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel>
implements IOwlOnShoulder {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void PlayerRenderer(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        this.addLayer(new OwlOnShoulderLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)this, ctx.getModelSet()));
    }

    @Inject(at={@At(value="TAIL")}, method={"extractRenderState"}, cancellable=true)
    public void extractRenderState(AbstractClientPlayer player, PlayerRenderState state, float p_365590_, CallbackInfo ci) {
        if (player.getType() == EntityType.PLAYER) {
            this.getOwlOnShoulder(player, state);
        }
    }

    private void getOwlOnShoulder(AbstractClientPlayer player, PlayerRenderState state) {
        int num = Math.max(Minecraft.getInstance().getFps(), 1);
        CompoundTag left = player.getShoulderEntityLeft();
        EntityType entitytype = left.read("id", EntityType.CODEC).orElse(null);
        CompoundTag right = player.getShoulderEntityRight();
        EntityType entitytype2 = right.read("id", EntityType.CODEC).orElse(null);
        ((IOwlOnShoulder)state).getDanceAnimationStateLeft().copyFrom(((IOwlOnShoulder)player).getDanceAnimationStateLeft());
        ((IOwlOnShoulder)state).getDanceAnimationStateRight().copyFrom(((IOwlOnShoulder)player).getDanceAnimationStateRight());
        ((IOwlOnShoulder)state).getRotateHeadAnimationStateLeft().copyFrom(((IOwlOnShoulder)player).getRotateHeadAnimationStateLeft());
        ((IOwlOnShoulder)state).getRotateHeadAnimationStateRight().copyFrom(((IOwlOnShoulder)player).getRotateHeadAnimationStateRight());
        ((IOwlOnShoulder)state).getWinkAnimationStateLeft().copyFrom(((IOwlOnShoulder)player).getWinkAnimationStateLeft());
        ((IOwlOnShoulder)state).getWinkAnimationStateRight().copyFrom(((IOwlOnShoulder)player).getWinkAnimationStateRight());
        if (left.contains("Color")) {
            ((IOwlOnShoulder)state).setLeftOwlcolor(left.getIntOr("Color", 0));
        }
        if (right.contains("Color")) {
            ((IOwlOnShoulder)state).setRightOwlcolor(right.getIntOr("Color", 0));
        }
        if (left.contains("Age")) {
            ((IOwlOnShoulder)state).isLeftBaby(left.getIntOr("Age", 0) < 0);
        }
        if (right.contains("Age")) {
            ((IOwlOnShoulder)state).isRightBaby(right.getIntOr("Age", 0) < 0);
        }
        if (entitytype != Registrations.MOB.get() && ((IOwlOnShoulder)state).getOwlOnLeftShoulder()) {
            ((IOwlOnShoulder)state).setOwlOnLeftShoulder(false);
        }
        if (entitytype == Registrations.MOB.get()) {
            if (EntityType.byString((String)((String)left.getString("id").get())).filter(p_369258_ -> p_369258_ == Registrations.MOB.get()).isPresent()) {
                ((IOwlOnShoulder)state).setOwlOnLeftShoulder(true);
            } else {
                ((IOwlOnShoulder)state).setOwlOnLeftShoulder(false);
            }
        }
        if (entitytype2 != Registrations.MOB.get() && ((IOwlOnShoulder)state).getOwlOnRightShoulder()) {
            ((IOwlOnShoulder)state).setOwlOnRightShoulder(false);
        }
        if (entitytype2 == Registrations.MOB.get()) {
            if (EntityType.byString((String)((String)right.getString("id").get())).filter(p_369258_ -> p_369258_ == Registrations.MOB.get()).isPresent()) {
                ((IOwlOnShoulder)state).setOwlOnRightShoulder(true);
            } else {
                ((IOwlOnShoulder)state).setOwlOnRightShoulder(false);
            }
        }
    }
}

