/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.mob.owl;

import aquariusplayz.animalgarden.owl.mob.owl.goals.ModFollowMobGoal;
import aquariusplayz.animalgarden.owl.mob.owl.goals.ModLandOnOwnersShoulderGoal;
import aquariusplayz.animalgarden.owl.setup.Registrations;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ModMob
extends Parrot
implements NeutralMob {
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final TargetingConditions.Selector PREY_SELECTOR = (p_395238_, p_395683_) -> {
        EntityType entitytype = p_395238_.getType();
        return entitytype == EntityType.CHICKEN || entitytype == EntityType.RABBIT;
    };
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    public UUID persistentAngerTarget;
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState rotateHeadAnimationState = new AnimationState();
    public final AnimationState winkAnimationState = new AnimationState();
    public final AnimationState dance1AnimationState = new AnimationState();
    public final AnimationState dance2AnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public int danceType = new Random().nextInt(2);

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(20.0);
            this.setHealth(20.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(6.0);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_29389_, DifficultyInstance p_29390_, EntitySpawnReason p_366524_, SpawnGroupData p_29392_) {
        Holder holder = p_29389_.getBiome(this.blockPosition());
        boolean a = ((Biome)holder.value()).coldEnoughToSnow(this.blockPosition(), p_29389_.getSeaLevel());
        if (a) {
            this.setColor(1);
        }
        if (p_29392_ == null) {
            p_29392_ = new AgeableMob.AgeableMobGroupData(true);
        }
        return super.finalizeSpawn(p_29389_, p_29390_, p_366524_, p_29392_);
    }

    public boolean isBaby() {
        return this.getAge() < 0;
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel p_277963_, Animal p_277357_, AgeableMob p_277516_) {
        if (p_277516_ instanceof ModMob) {
            ModMob mob = (ModMob)p_277516_;
            mob.setColor(this.getColor());
        }
        super.finalizeSpawnChildFromBreeding(p_277963_, p_277357_, p_277516_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 9.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new OwlWanderGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new ModLandOnOwnersShoulderGoal(this));
        this.goalSelector.addGoal(5, (Goal)new ModFollowMobGoal(this, 1.0, 3.0f, 7.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(3, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected PathNavigation createNavigation(Level p_29417_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_29417_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public boolean isPartyParrot() {
        if (super.isPartyParrot()) {
            if (this.danceType == 0) {
                this.dance1AnimationState.startIfStopped(this.tickCount);
            } else {
                this.dance2AnimationState.startIfStopped(this.tickCount);
            }
            return true;
        }
        if (this.dance1AnimationState.isStarted()) {
            this.dance1AnimationState.stop();
        }
        if (this.dance2AnimationState.isStarted()) {
            this.dance2AnimationState.stop();
        }
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.isInSittingPose()) {
            if (!this.sitAnimationState.isStarted()) {
                this.sitAnimationState.start(this.tickCount);
            }
        } else if (this.sitAnimationState.isStarted()) {
            this.sitAnimationState.stop();
        }
        if (this.level().random.nextInt(400) == 0) {
            this.rotateHeadAnimationState.start(this.tickCount);
        }
        if (this.level().random.nextInt(75) == 0) {
            this.winkAnimationState.start(this.tickCount);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public static boolean randomHeadMovement(Level p_29383_, Entity p_29384_) {
        return false;
    }

    public static boolean randomEyeMovement(Level p_29383_, Entity p_29384_) {
        return false;
    }

    public InteractionResult mobInteract(Player p_29414_, InteractionHand p_29415_) {
        ItemStack itemstack = p_29414_.getItemInHand(p_29415_);
        if (!this.isTame() && itemstack.is(ItemTags.MEAT)) {
            this.usePlayerItem(p_29414_, p_29415_, itemstack);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PARROT_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            if (!this.level().isClientSide()) {
                if (this.random.nextInt(3) == 0) {
                    this.tame(p_29414_);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && itemstack.is(ItemTags.MEAT)) {
            if (!this.isFlying() && this.isTame() && this.isOwnedBy((LivingEntity)p_29414_)) {
                if (!this.level().isClientSide() && this.getHealth() < this.getMaxHealth()) {
                    this.heal(5.0f);
                    this.usePlayerItem(p_29414_, p_29415_, itemstack);
                }
                if (!this.isSilent()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PARROT_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
                }
                return super.mobInteract(p_29414_, p_29415_);
            }
        } else if (!this.isFlying() && this.isTame() && this.isOwnedBy((LivingEntity)p_29414_)) {
            if (!this.level().isClientSide()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
            }
            return InteractionResult.SUCCESS.withoutItem();
        }
        return super.mobInteract(p_29414_, p_29415_);
    }

    public boolean isFood(ItemStack p_29446_) {
        return p_29446_.is(ItemTags.MEAT);
    }

    public static boolean checkOwlSpawnRules(EntityType<ModMob> p_218242_, LevelAccessor p_218243_, EntitySpawnReason p_367372_, BlockPos p_218245_, RandomSource p_218246_) {
        return p_218243_.getBlockState(p_218245_.below()).is(BlockTags.PARROTS_SPAWNABLE_ON) && ModMob.isBrightEnoughToSpawn((BlockAndTintGetter)p_218243_, (BlockPos)p_218245_);
    }

    protected void checkFallDamage(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public boolean canMate(Animal p_27569_) {
        if (p_27569_ == this) {
            return false;
        }
        return p_27569_.getClass() != ((Object)((Object)this)).getClass() ? false : this.isInLove() && p_27569_.isInLove();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)((EntityType)Registrations.MOB.get()).create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (mob != null && p_148994_ instanceof ModMob) {
            ModMob mob1 = (ModMob)p_148994_;
            if (this.isTame()) {
                mob.setColor(this.getColor());
                mob.setOwnerReference(this.getOwnerReference());
                mob.setTame(true, true);
            }
        }
        return mob;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registrations.HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registrations.HURT.get();
    }

    protected void playStepSound(BlockPos p_29419_, BlockState p_29420_) {
        this.playSound(SoundEvents.PARROT_STEP, 0.15f, 1.0f);
    }

    public float getVoicePitch() {
        return ModMob.getPitch(this.random);
    }

    public static float getPitch(RandomSource p_218237_) {
        return (p_218237_.nextFloat() - p_218237_.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isPushable() {
        return true;
    }

    protected void doPush(Entity p_29367_) {
        if (!(p_29367_ instanceof Player)) {
            super.doPush(p_29367_);
        }
    }

    public boolean wantsToAttack(LivingEntity p_395043_, LivingEntity p_394450_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_395043_ instanceof Creeper || p_395043_ instanceof Ghast || p_395043_ instanceof ArmorStand) {
            return false;
        }
        if (p_395043_ instanceof ModMob) {
            ModMob mob = (ModMob)p_395043_;
            return !mob.isTame() || mob.getOwner() != p_394450_;
        }
        if (p_395043_ instanceof Player) {
            Player player1;
            Player player = (Player)p_395043_;
            if (p_394450_ instanceof Player && !(player1 = (Player)p_394450_).canHarmPlayer(player)) {
                return false;
            }
        }
        return p_395043_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_395043_).isTamed() ? false : !(p_395043_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_395043_).isTame();
    }

    public boolean hurtServer(ServerLevel p_368472_, DamageSource p_364880_, float p_366649_) {
        if (this.isInvulnerableTo(p_368472_, p_364880_)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurtServer(p_368472_, p_364880_, p_366649_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(COLOR, (Object)0);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        p_29422_.putInt("Color", this.getColor());
        this.addPersistentAngerSaveData(p_29422_);
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.setColor(p_29402_.getIntOr("Color", 0));
        this.readPersistentAngerSaveData(this.level(), p_29402_);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    private void setColor(int p_262613_) {
        this.entityData.set(COLOR, (Object)p_262613_);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_396897_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_396897_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_393236_) {
        this.persistentAngerTarget = p_393236_;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected boolean canFlyToOwner() {
        return true;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    class OwlWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public OwlWanderGoal(PathfinderMob p_186224_, double p_186225_) {
            super(p_186224_, p_186225_);
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = null;
            if (this.mob.isInWater() || ModMob.this.isInLove() || ModMob.this.isAggressive()) {
                vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)15);
            }
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.getPosition() : vec3;
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos blockpos = this.mob.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 3.0)), (int)Mth.floor((double)(this.mob.getY() - 6.0)), (int)Mth.floor((double)(this.mob.getZ() - 3.0)), (int)Mth.floor((double)(this.mob.getX() + 3.0)), (int)Mth.floor((double)(this.mob.getY() + 6.0)), (int)Mth.floor((double)(this.mob.getZ() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.mob.level().getBlockState((BlockPos)blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos1, Direction.DOWN))).getBlock() instanceof LeavesBlock || blockstate.is(BlockTags.LOGS)) || !this.mob.level().isEmptyBlock(blockpos1) || !this.mob.level().isEmptyBlock((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.atBottomCenterOf((Vec3i)blockpos1);
            }
            return null;
        }
    }

    public static enum Variant implements StringRepresentable
    {
        RED_BLUE(0, "red_blue"),
        BLUE(1, "blue"),
        GREEN(2, "green"),
        YELLOW_BLUE(3, "yellow_blue"),
        GRAY(4, "gray");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int p_262571_, String p_262693_) {
            this.id = p_262571_;
            this.name = p_262693_;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int p_262643_) {
            return BY_ID.apply(p_262643_);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

