/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.mob.owl;

import aquariusplayz.animalgarden.owl.mob.owl.ModMob;
import aquariusplayz.animalgarden.owl.mob.owl.ModMobAnimations;
import aquariusplayz.animalgarden.owl.mob.owl.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_owl", (String)"owl"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_owl", (String)"owl_baby"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart lefteye;
    private final ModelPart righteye;
    private final ModelPart body;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart rightwing;
    private final ModelPart leftwing;
    private final ModelPart tail;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.root = root.getChild("rootz");
        this.head = this.root.getChild("head");
        this.lefteye = this.head.getChild("lefteye");
        this.righteye = this.head.getChild("righteye");
        this.body = this.root.getChild("body");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
        this.rightwing = this.root.getChild("rightwing");
        this.leftwing = this.root.getChild("leftwing");
        this.tail = this.root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(27, 24).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(42, 42).addBox(-3.05f, -4.05f, -3.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).texOffs(44, 7).addBox(1.05f, -4.05f, -3.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).texOffs(31, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(13, 39).addBox(-2.0f, -3.0f, -3.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(35, 42).addBox(-1.0f, -2.05f, -3.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.05f)).texOffs(44, 18).addBox(-0.5f, -0.15f, -3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.05f)).texOffs(9, 42).addBox(-4.1f, -5.1f, -3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 42).addBox(3.1f, -5.1f, -3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition lefteye = head.addOrReplaceChild("lefteye", CubeListBuilder.create().texOffs(0, 33).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)2.0f, (float)-1.0f, (float)-2.1f));
        PartDefinition righteye = head.addOrReplaceChild("righteye", CubeListBuilder.create().texOffs(27, 31).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)-2.0f, (float)-1.0f, (float)-2.1f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -5.0f, 8.0f, 4.0f, 7.0f, new CubeDeformation(-0.5f)).texOffs(0, 12).addBox(-4.0f, 0.75f, -5.0f, 8.0f, 4.0f, 7.0f, new CubeDeformation(-0.75f)), PartPose.offset((float)0.0f, (float)-5.75f, (float)1.0f));
        PartDefinition leftleg = root.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(44, 14).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(28, 44).addBox(-0.5f, 0.8f, -1.3f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(5, 46).addBox(0.3f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(10, 46).addBox(-0.5f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(15, 46).addBox(-1.3f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)1.5f, (float)-1.75f, (float)-0.25f));
        PartDefinition rightleg = root.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(44, 10).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(44, 21).addBox(-1.3f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(0, 45).addBox(0.3f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(42, 45).addBox(-0.5f, 0.8f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(23, 44).addBox(-0.5f, 0.8f, -1.3f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-1.5f, (float)-1.75f, (float)-0.25f));
        PartDefinition rightwing = root.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(31, 15).addBox(-1.0f, -0.25f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 38).addBox(-1.0f, 1.75f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 31).addBox(-1.0f, 2.75f, -1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-6.0f, (float)-0.5f));
        PartDefinition leftwing = root.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(31, 7).addBox(0.0f, -0.25f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(13, 33).addBox(0.0f, 1.75f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(0.0f, 2.75f, -1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-6.0f, (float)-0.5f));
        PartDefinition tail = root.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(35, 38).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)2.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((EntityRenderState)p_368486_);
        if (p_368486_.isOnPlayer) {
            this.setupShoulderAnim(p_368486_);
        } else {
            if (p_368486_.isSitting) {
                this.animate(p_368486_.sitAnimationState, ModMobAnimations.SIT, p_368486_.ageInTicks, 1.0f);
            } else {
                this.animateWalk(ModMobAnimations.FLY, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 3.0f, 2.5f);
            }
            this.animate(p_368486_.rotateHeadAnimationState, ModMobAnimations.ROTATE_HEAD, p_368486_.ageInTicks, 1.0f);
            this.animate(p_368486_.winkAnimationState, ModMobAnimations.WINK, p_368486_.ageInTicks, 1.0f);
            this.animate(p_368486_.dance1AnimationState, ModMobAnimations.DANCE, p_368486_.ageInTicks, 1.0f);
            this.animate(p_368486_.dance2AnimationState, ModMobAnimations.DANCE2, p_368486_.ageInTicks, 1.0f);
        }
    }

    public void setupShoulderAnim(ModMobRenderState p_368486_) {
        super.setupAnim((EntityRenderState)p_368486_);
        this.animate(p_368486_.rotateHeadAnimationState, ModMobAnimations.ROTATE_HEAD, p_368486_.ageInTicks, 1.0f);
        this.animate(p_368486_.winkAnimationState, ModMobAnimations.WINK, p_368486_.ageInTicks, 1.0f);
        this.animate(p_368486_.dance2AnimationState, ModMobAnimations.DANCE2, p_368486_.ageInTicks, 1.0f);
    }

    public static Pose getPose(ModMob p_364386_) {
        if (p_364386_.isPartyParrot()) {
            return Pose.PARTY;
        }
        if (p_364386_.isInSittingPose()) {
            return Pose.SITTING;
        }
        return p_364386_.isFlying() ? Pose.FLYING : Pose.STANDING;
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }

    public static enum Pose {
        FLYING,
        STANDING,
        SITTING,
        PARTY,
        ON_SHOULDER;

    }
}

