/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.owl.mob.owl.goals;

import aquariusplayz.animalgarden.owl.mob.owl.ModMob;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ModLandOnOwnersShoulderGoal
extends Goal {
    private final ModMob entity;
    private boolean isSittingOnShoulder;

    public ModLandOnOwnersShoulderGoal(ModMob p_25483_) {
        this.entity = p_25483_;
    }

    public boolean canUse() {
        if (this.entity.isInLove() || this.entity.isAngry()) {
            return false;
        }
        LivingEntity livingEntity = this.entity.getOwner();
        if (!(livingEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverplayer = (ServerPlayer)livingEntity;
        boolean flag = !serverplayer.isSpectator() && !serverplayer.getAbilities().flying && !serverplayer.isInWater() && !serverplayer.isInPowderSnow;
        return !this.entity.isOrderedToSit() && flag && this.entity.canSitOnShoulder();
    }

    public boolean canContinueToUse() {
        if (this.entity.isInLove() || this.entity.isAngry()) {
            return false;
        }
        return super.canContinueToUse();
    }

    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    public void start() {
        this.isSittingOnShoulder = false;
    }

    public void tick() {
        LivingEntity livingEntity;
        if (!this.isSittingOnShoulder && !this.entity.isInSittingPose() && !this.entity.isLeashed() && (livingEntity = this.entity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            if (this.entity.getBoundingBox().intersects(serverplayer.getBoundingBox())) {
                this.isSittingOnShoulder = this.entity.setEntityOnShoulder(serverplayer);
            }
        }
    }
}

