/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.loader;

import com.sighs.oneenoughblock.loader.Entry;
import com.sighs.oneenoughblock.loader.EntryLoader;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class EntryCache {
    public static final HashMap<Block, Block> UnitMapCache = new HashMap();
    public static final HashMap<TagKey<Block>, Block> TagMapCache = new HashMap();

    public static void putEntry(Entry rule) {
        String result = rule.getResult();
        for (String match : rule.getMatch()) {
            TagKey from;
            Block to = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(result.trim()));
            if (to == null) {
                return;
            }
            if (match.startsWith("#")) {
                from = BlockTags.create((ResourceLocation)new ResourceLocation(match.trim().substring(1)));
                TagMapCache.put((TagKey<Block>)from, to);
                return;
            }
            from = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(match.trim()));
            if (from == null) continue;
            UnitMapCache.put((Block)from, to);
        }
    }

    public static void clearCache() {
        UnitMapCache.clear();
        TagMapCache.clear();
    }

    public static void loadAllRule() {
        EntryCache.clearCache();
        EntryLoader.loadAll().forEach(EntryCache::putEntry);
    }
}

