/*
 * Decompiled with CFR 0.152.
 */
package be.elmital;

import be.elmital.guild.PerkElement;
import be.elmital.guild.PerkElementScreen;
import be.elmital.npc.NPCHandler;
import be.elmital.packet.NPCConversationPacket;
import be.elmital.packet.OpenGuildPerkTreePacket;
import be.elmital.packet.OpenMenuPacket;
import be.elmital.packet.OpenURLPacket;
import be.elmital.packet.PerkTreePacket;
import be.elmital.packet.TogglePacket;
import be.elmital.packet.UnlockPerkPacket;
import be.elmital.packet.Utils;
import be.elmital.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterRPP
implements ModInitializer {
    public static class_310 CLIENT;
    public static PerkElementScreen PERK_TREE_SCREEN;
    public static final class_2960 REDCORE_CHANNEL;
    public static final Logger LOGGER;
    public static final int GENERIC_Y_OFFSET = 6;
    public static final int EXTRA_GENERIC_SIZE = 1;
    public static BetterRPP instance;
    public NPCHandler npcHandler;
    public boolean activated;

    public static boolean isActive() {
        return BetterRPP.instance.activated;
    }

    public void onInitialize() {
        instance = this;
        this.npcHandler = new NPCHandler();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            CLIENT = client;
            if (handler.method_45734() == null || handler.method_45734().method_2994() || handler.method_45734().method_52811()) {
                return;
            }
            final Timer t = new Timer();
            t.schedule(new TimerTask(this){

                @Override
                public void run() {
                    Utils.registerDelegated(TogglePacket.ID, TogglePacket.PACKET_CODEC, Utils.PacketType.CALL_BACK);
                    Utils.sendPacket(new TogglePacket());
                    t.cancel();
                }
            }, 200L);
        });
        LOGGER.info("Mod enable!");
    }

    public static LinkedHashMap<PerkElement.Builder, String> readPerkTree(String stringBytes) {
        JsonObject json = (JsonObject)new Gson().fromJson(stringBytes, JsonObject.class);
        LinkedHashMap<PerkElement.Builder, String> map = new LinkedHashMap<PerkElement.Builder, String>();
        int nullCount = 0;
        for (JsonElement elements : json.get("elements").getAsJsonArray()) {
            String desc;
            JsonObject subJson = elements.getAsJsonObject();
            class_1792 item = subJson.has("item") ? (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)subJson.get("item").getAsString())) : null;
            String label = subJson.get("label").getAsString();
            String path = subJson.get("path").getAsString();
            String type = subJson.get("type").getAsString();
            String parent = subJson.has("parent") ? subJson.get("parent").getAsString() : null;
            boolean reachable = subJson.has("reachable") ? subJson.get("reachable").getAsBoolean() : true;
            String string = desc = subJson.has("description") ? subJson.get("description").getAsString() : "Branche de l'arbre";
            if (type.equalsIgnoreCase("PERK")) {
                int maxLvl = subJson.get("maxlvl").getAsInt();
                int lvl = subJson.get("lvl").getAsInt();
                map.put(PerkElement.Builder.create(PerkElement.Type.PERK, path, reachable || lvl > 0, reachable && lvl < maxLvl).display((class_1799)null, (class_2561)class_2561.method_43470((String)(label + (String)(lvl == 0 ? "" : " " + StringUtils.intToRoman(lvl)))), (class_2561)class_2561.method_43470((String)(desc + "\nNiveau max : " + maxLvl)), null), parent);
                continue;
            }
            if (type.equalsIgnoreCase("NODE")) {
                map.put(PerkElement.Builder.create(PerkElement.Type.NODE, path, true, false).display((class_1935)item, (class_2561)class_2561.method_43470((String)label), (class_2561)class_2561.method_43470((String)desc), class_2960.method_60655((String)"better-rpp", (String)"textures/gui/perktree/background.png")), "null" + nullCount++);
                continue;
            }
            if (!type.equalsIgnoreCase("BRANCH")) continue;
            map.put(PerkElement.Builder.create(PerkElement.Type.BRANCH, path, true, false).display((class_1799)null, (class_2561)class_2561.method_43470((String)label), (class_2561)class_2561.method_43470((String)desc), null), parent);
        }
        return map;
    }

    public void toggleValidation(boolean activated) {
        BetterRPP.instance.activated = activated;
        if (activated) {
            Utils.registerDelegated(PerkTreePacket.ID, PerkTreePacket.PACKET_CODEC, Utils.PacketType.CALL_BACK);
            Utils.register(OpenMenuPacket.ID, OpenMenuPacket.PACKET_CODEC, Utils.PacketType.CLIENT_TO_SERVER);
            Utils.register(UnlockPerkPacket.ID, UnlockPerkPacket.PACKET_CODEC, Utils.PacketType.CLIENT_TO_SERVER);
            Utils.registerDelegated(OpenGuildPerkTreePacket.ID, OpenGuildPerkTreePacket.PACKET_CODEC, Utils.PacketType.SERVER_TO_CLIENT);
            Utils.registerDelegated(OpenURLPacket.ID, OpenURLPacket.PACKET_CODEC, Utils.PacketType.SERVER_TO_CLIENT);
            Utils.registerDelegated(NPCConversationPacket.ID, NPCConversationPacket.PACKET_CODEC, Utils.PacketType.SERVER_TO_CLIENT);
            Utils.sendPacket(new PerkTreePacket());
        }
    }

    static {
        REDCORE_CHANNEL = class_2960.method_60655((String)"redcore", (String)"betterrpp");
        LOGGER = LoggerFactory.getLogger((String)"better-rpp");
    }
}

