/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.guild.PerkElement;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PerkElementPositioner {
    private final PerkElement perkElement;
    @Nullable
    private final PerkElementPositioner parent;
    @Nullable
    private final PerkElementPositioner previousSibling;
    private final int childrenSize;
    private final List<PerkElementPositioner> children = Lists.newArrayList();
    private PerkElementPositioner optionalLast;
    @Nullable
    private PerkElementPositioner substituteChild;
    private int depth;
    private float row;
    private float relativeRowInSiblings;
    private float field_1266;
    private float field_1265;

    public PerkElementPositioner(PerkElement perkElement, @Nullable PerkElementPositioner parent, @Nullable PerkElementPositioner previousSibling, int childrenSize, int depth) {
        if (perkElement.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position an invisible perk element!");
        }
        this.perkElement = perkElement;
        this.parent = parent;
        this.previousSibling = previousSibling;
        this.childrenSize = childrenSize;
        this.optionalLast = this;
        this.depth = depth;
        this.row = -1.0f;
        PerkElementPositioner perkElementPositioner = null;
        for (PerkElement perkElement2 : perkElement.getChildren()) {
            perkElementPositioner = this.findChildrenRecursively(perkElement2, perkElementPositioner);
        }
    }

    @Nullable
    private PerkElementPositioner findChildrenRecursively(PerkElement perkElement, @Nullable PerkElementPositioner lastChild) {
        if (perkElement.getDisplay() != null) {
            lastChild = new PerkElementPositioner(perkElement, this, lastChild, this.children.size() + 1, this.depth + 1);
            this.children.add(lastChild);
        } else {
            for (PerkElement perkElement2 : perkElement.getChildren()) {
                lastChild = this.findChildrenRecursively(perkElement2, lastChild);
            }
        }
        return lastChild;
    }

    private void calculateRecursively() {
        if (this.children.isEmpty()) {
            this.row = this.previousSibling != null ? this.previousSibling.row + 1.0f : 0.0f;
        } else {
            PerkElementPositioner perkElementPositioner = null;
            for (PerkElementPositioner perkElementPositioner2 : this.children) {
                perkElementPositioner2.calculateRecursively();
                perkElementPositioner = perkElementPositioner2.onFinishCalculation(perkElementPositioner == null ? perkElementPositioner2 : perkElementPositioner);
            }
            this.onFinishChildrenCalculation();
            float f = (this.children.get((int)0).row + this.children.get((int)(this.children.size() - 1)).row) / 2.0f;
            if (this.previousSibling != null) {
                this.row = this.previousSibling.row + 1.0f;
                this.relativeRowInSiblings = this.row - f;
            } else {
                this.row = f;
            }
        }
    }

    private float findMinRowRecursively(float deltaRow, int depth, float minRow) {
        this.row += deltaRow;
        this.depth = depth;
        if (this.row < minRow) {
            minRow = this.row;
        }
        for (PerkElementPositioner perkElementPositioner : this.children) {
            minRow = perkElementPositioner.findMinRowRecursively(deltaRow + this.relativeRowInSiblings, depth + 1, minRow);
        }
        return minRow;
    }

    private void increaseRowRecursively(float deltaRow) {
        this.row += deltaRow;
        for (PerkElementPositioner perkElementPositioner : this.children) {
            perkElementPositioner.increaseRowRecursively(deltaRow);
        }
    }

    private void onFinishChildrenCalculation() {
        float f = 0.0f;
        float g = 0.0f;
        for (int i = this.children.size() - 1; i >= 0; --i) {
            PerkElementPositioner perkElementPositioner = this.children.get(i);
            perkElementPositioner.row += f;
            perkElementPositioner.relativeRowInSiblings += f;
            f += perkElementPositioner.field_1265 + (g += perkElementPositioner.field_1266);
        }
    }

    @Nullable
    private PerkElementPositioner getFirstChild() {
        if (this.substituteChild != null) {
            return this.substituteChild;
        }
        return !this.children.isEmpty() ? this.children.get(0) : null;
    }

    @Nullable
    private PerkElementPositioner getLastChild() {
        if (this.substituteChild != null) {
            return this.substituteChild;
        }
        return !this.children.isEmpty() ? this.children.get(this.children.size() - 1) : null;
    }

    private PerkElementPositioner onFinishCalculation(PerkElementPositioner last) {
        if (this.previousSibling == null) {
            return last;
        }
        PerkElementPositioner perkElementPositioner = this;
        PerkElementPositioner perkElementPositioner2 = this;
        PerkElementPositioner perkElementPositioner3 = this.previousSibling;
        PerkElementPositioner perkElementPositioner4 = this.parent.children.get(0);
        float f = this.relativeRowInSiblings;
        float g = this.relativeRowInSiblings;
        float h = perkElementPositioner3.relativeRowInSiblings;
        float i = perkElementPositioner4.relativeRowInSiblings;
        while (perkElementPositioner3.getLastChild() != null && perkElementPositioner.getFirstChild() != null) {
            perkElementPositioner3 = perkElementPositioner3.getLastChild();
            perkElementPositioner = perkElementPositioner.getFirstChild();
            perkElementPositioner4 = perkElementPositioner4.getFirstChild();
            perkElementPositioner2 = perkElementPositioner2.getLastChild();
            perkElementPositioner2.optionalLast = this;
            float j = perkElementPositioner3.row + h - (perkElementPositioner.row + f) + 1.0f;
            if (j > 0.0f) {
                perkElementPositioner3.getLast(this, last).pushDown(this, j);
                f += j;
                g += j;
            }
            h += perkElementPositioner3.relativeRowInSiblings;
            f += perkElementPositioner.relativeRowInSiblings;
            i += perkElementPositioner4.relativeRowInSiblings;
            g += perkElementPositioner2.relativeRowInSiblings;
        }
        if (perkElementPositioner3.getLastChild() != null && perkElementPositioner2.getLastChild() == null) {
            perkElementPositioner2.substituteChild = perkElementPositioner3.getLastChild();
            perkElementPositioner2.relativeRowInSiblings += h - g;
        } else {
            if (perkElementPositioner.getFirstChild() != null && perkElementPositioner4.getFirstChild() == null) {
                perkElementPositioner4.substituteChild = perkElementPositioner.getFirstChild();
                perkElementPositioner4.relativeRowInSiblings += f - i;
            }
            last = this;
        }
        return last;
    }

    private void pushDown(PerkElementPositioner positioner, float extraRowDistance) {
        float f = positioner.childrenSize - this.childrenSize;
        if (f != 0.0f) {
            positioner.field_1266 -= extraRowDistance / f;
            this.field_1266 += extraRowDistance / f;
        }
        positioner.field_1265 += extraRowDistance;
        positioner.row += extraRowDistance;
        positioner.relativeRowInSiblings += extraRowDistance;
    }

    private PerkElementPositioner getLast(PerkElementPositioner perkElementPositioner, PerkElementPositioner perkElementPositioner2) {
        return this.optionalLast != null && perkElementPositioner.parent.children.contains(this.optionalLast) ? this.optionalLast : perkElementPositioner2;
    }

    private void apply() {
        if (this.perkElement.getDisplay() != null) {
            this.perkElement.getDisplay().setPos(this.depth, this.row);
        }
        if (!this.children.isEmpty()) {
            for (PerkElementPositioner perkElementPositioner : this.children) {
                perkElementPositioner.apply();
            }
        }
    }

    public static void arrangeForTree(PerkElement root) {
        if (root.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position children of an invisible root!");
        }
        PerkElementPositioner perkElementPositioner = new PerkElementPositioner(root, null, null, 1, 0);
        perkElementPositioner.calculateRecursively();
        float f = perkElementPositioner.findMinRowRecursively(0.0f, 0, perkElementPositioner.row);
        if (f < 0.0f) {
            perkElementPositioner.increaseRowRecursively(-f);
        }
        perkElementPositioner.apply();
    }
}

