/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.packet;

import be.elmital.packet.DecodeExecutionDelegated;
import java.nio.charset.StandardCharsets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class Utils {
    public static <C extends class_8710, I extends class_8710.class_9154<C>> boolean register(I id, class_9139<? super class_9129, C> codec, PacketType type) {
        if (type.equals((Object)PacketType.CLIENT_TO_SERVER) || type.equals((Object)PacketType.CALL_BACK)) {
            try {
                PayloadTypeRegistry.playC2S().register(id, codec);
            }
            catch (IllegalArgumentException ignored) {
                return false;
            }
            if (type.equals((Object)PacketType.CLIENT_TO_SERVER)) {
                return true;
            }
        }
        if (type.equals((Object)PacketType.SERVER_TO_CLIENT) || type.equals((Object)PacketType.CALL_BACK)) {
            try {
                PayloadTypeRegistry.playS2C().register(id, codec);
                return true;
            }
            catch (IllegalArgumentException ignored) {
                return false;
            }
        }
        return false;
    }

    public static <C extends class_8710 & DecodeExecutionDelegated<C>, I extends class_8710.class_9154<C>> void registerDelegated(I id, class_9139<? super class_9129, C> codec, PacketType type) {
        if (Utils.register(id, codec, type)) {
            ClientPlayNetworking.registerGlobalReceiver(id, (payload, context) -> ((DecodeExecutionDelegated)payload).execute(payload, context));
        }
    }

    public static <C extends class_8710> void sendPacket(C packet) {
        ClientPlayNetworking.send(packet);
    }

    public static String readStringFromRedCore(class_9129 buf) {
        int readableBytes = buf.readInt();
        if (readableBytes <= 0) {
            throw new IllegalStateException("Warning, invalid (zero length) payload received");
        }
        String decoded = buf.toString(buf.readerIndex(), readableBytes, StandardCharsets.UTF_8);
        buf.method_52988(buf.readerIndex() + readableBytes);
        return decoded;
    }

    public static Float readFloatFromRedCore(class_9129 buf) {
        return Float.valueOf(Float.intBitsToFloat(buf.readInt()));
    }

    public static void writeStringToRedCore(class_9129 buf, String string) {
        buf.method_53002(string.length());
        buf.method_52983(string.getBytes(StandardCharsets.UTF_8));
    }

    public static enum PacketType {
        CLIENT_TO_SERVER,
        SERVER_TO_CLIENT,
        CALL_BACK;

    }
}

