/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.guild.PerkElementDisplay;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PerkElement {
    @Nullable
    private final PerkElement parent;
    @Nullable
    private final PerkElementDisplay display;
    private final boolean isUnlocked;
    private final boolean canBeUnlockOrUpgrade;
    private final class_2960 id;
    private final String path;
    private final String[][] requirements;
    private final Set<PerkElement> children = Sets.newLinkedHashSet();
    private final class_2561 text;
    private final Type type;

    public PerkElement(class_2960 id, @Nullable PerkElement parent, @Nullable PerkElementDisplay display, boolean canBeUnlockOrUpgrade, String path, String[][] requirements, boolean isUnlocked, Type type) {
        this.id = id;
        this.display = display;
        this.parent = parent;
        this.canBeUnlockOrUpgrade = canBeUnlockOrUpgrade;
        this.path = path;
        this.requirements = requirements;
        this.type = type;
        if (parent != null) {
            parent.addChild(this);
        }
        if (display == null) {
            this.text = class_2561.method_43470((String)id.toString());
        } else {
            class_2561 text = display.getTitle();
            class_5250 text2 = class_2564.method_10889((class_5250)text.method_27661(), (class_2583)class_2583.field_24360).method_27693("\n").method_10852(display.getDescription());
            class_5250 text3 = text.method_27661().method_27694(arg_0 -> PerkElement.lambda$new$0((class_2561)text2, arg_0));
            this.text = class_2564.method_10885((class_2561)text3);
        }
        this.isUnlocked = isUnlocked;
    }

    public Builder createTask() {
        return new Builder(this.type, this.path, this.parent == null ? null : this.parent.getId(), this.display, this.requirements, this.isUnlocked, this.canBeUnlockOrUpgrade);
    }

    @Nullable
    public PerkElement getParent() {
        return this.parent;
    }

    public PerkElement getRoot() {
        return PerkElement.getRoot(this);
    }

    public static PerkElement getRoot(PerkElement perkElement) {
        PerkElement perkElement2 = perkElement;
        PerkElement perkElement3;
        while ((perkElement3 = perkElement2.getParent()) != null) {
            perkElement2 = perkElement3;
        }
        return perkElement2;
    }

    @Nullable
    public PerkElementDisplay getDisplay() {
        return this.display;
    }

    public String toString() {
        class_2960 var10000 = this.getId();
        return "PerkElement{id=" + String.valueOf(var10000) + ", parent=" + String.valueOf(this.parent == null ? "null" : this.parent.getId()) + ", display=" + String.valueOf(this.display) + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
    }

    public Iterable<PerkElement> getChildren() {
        return this.children;
    }

    public int getRequirementCount() {
        return this.requirements.length;
    }

    public boolean isUnlocked() {
        return this.isUnlocked;
    }

    public boolean canBeUnlockOrUpgrade() {
        return this.canBeUnlockOrUpgrade;
    }

    public Type getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public void addChild(PerkElement child) {
        this.children.add(child);
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerkElement)) {
            return false;
        }
        PerkElement perkElement = (PerkElement)o;
        return this.id.equals((Object)perkElement.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String[][] getRequirements() {
        return this.requirements;
    }

    public class_2561 toHoverableText() {
        return this.text;
    }

    private static /* synthetic */ class_2583 lambda$new$0(class_2561 text2, class_2583 style) {
        return style.method_10949((class_2568)new class_2568.class_10613(text2));
    }

    public static enum Type {
        BRANCH(26, class_124.field_1080),
        NODE(0, class_124.field_1068),
        PERK(52, class_124.field_1060);

        private final int textureV;
        private final class_124 titleFormat;

        private Type(int textureV, class_124 titleFormat) {
            this.textureV = textureV;
            this.titleFormat = titleFormat;
        }

        public int getTextureV() {
            return this.textureV;
        }

        public class_124 getTitleFormat() {
            return this.titleFormat;
        }
    }

    public static class Builder {
        private final Type type;
        private final String path;
        @Nullable
        private class_2960 parentId;
        @Nullable
        private PerkElement parentObj;
        @Nullable
        private PerkElementDisplay display;
        private final boolean isUnlocked;
        private final boolean canBeUnlockOrUpgrade;
        @Nullable
        private String[][] requirements;

        Builder(Type type, String path, @Nullable class_2960 parentId, @Nullable PerkElementDisplay display, String[][] requirements, boolean isUnlocked, boolean canBeUnlockOrUpgrade) {
            this.type = type;
            this.path = path;
            this.parentId = parentId;
            this.display = display;
            this.requirements = requirements;
            this.isUnlocked = isUnlocked;
            this.canBeUnlockOrUpgrade = canBeUnlockOrUpgrade;
        }

        private Builder(Type type, String path, boolean isUnlocked, boolean canBeUnlockOrUpgrade) {
            this.type = type;
            this.path = path;
            this.isUnlocked = isUnlocked;
            this.canBeUnlockOrUpgrade = canBeUnlockOrUpgrade;
        }

        public static Builder create(Type type, String path, boolean isUnlocked, boolean canBeUnlockOrUpgrade) {
            return new Builder(type, path, isUnlocked, canBeUnlockOrUpgrade);
        }

        public Builder parent(PerkElement parent) {
            this.parentObj = parent;
            return this;
        }

        public Builder parent(class_2960 parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder display(class_1799 icon, class_2561 title, class_2561 description, @Nullable class_2960 background) {
            return this.display(new PerkElementDisplay(icon, title, description, background));
        }

        public Builder display(class_1935 icon, class_2561 title, class_2561 description, @Nullable class_2960 background) {
            if (this.canBeUnlockOrUpgrade) {
                description = class_2561.method_43473().method_10852(description).method_10852((class_2561)class_2561.method_43470((String)"\nClique pour am\u00e9liorer").method_27692(class_124.field_1054));
            }
            return this.display(new PerkElementDisplay(icon == null ? null : new class_1799((class_1935)icon.method_8389()), title, description, background));
        }

        public Builder display(PerkElementDisplay display) {
            this.display = display;
            return this;
        }

        public Builder requirements(String[][] requirements) {
            this.requirements = requirements;
            return this;
        }

        public boolean findParent(Function<class_2960, PerkElement> parentProvider) {
            if (this.parentId == null) {
                return true;
            }
            if (this.parentObj == null) {
                this.parentObj = parentProvider.apply(this.parentId);
            }
            return this.parentObj != null;
        }

        public PerkElement build(class_2960 id) {
            if (!this.findParent(idx -> null)) {
                throw new IllegalStateException("Tried to build incomplete perk element!");
            }
            if (this.requirements == null) {
                this.requirements = new String[0][];
            }
            return new PerkElement(id, this.parentObj, this.display, this.canBeUnlockOrUpgrade, this.path, this.requirements, this.isUnlocked, this.type);
        }

        public PerkElement build(String id) {
            return this.build(class_2960.method_60654((String)id));
        }

        public String toString() {
            class_2960 var10000 = this.parentId;
            return "Task PerkElement{parentId=" + String.valueOf(var10000) + ", display=" + String.valueOf(this.display) + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
        }

        public String getPath() {
            return this.path;
        }
    }
}

