/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.guild.PerkElement;
import be.elmital.guild.PerkElementDisplay;
import be.elmital.guild.PerkElementScreen;
import be.elmital.guild.PerkElementTabType;
import be.elmital.guild.PerkElementWidget;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PerkElementTab {
    private final class_310 client;
    private final PerkElementScreen screen;
    private final PerkElementTabType type;
    private final int index;
    private final PerkElement root;
    private final PerkElementDisplay display;
    @Nullable
    private final class_1799 icon;
    private final class_2561 title;
    private final PerkElementWidget rootWidget;
    private final Map<PerkElement, PerkElementWidget> widgets = Maps.newLinkedHashMap();
    double originX;
    double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;
    private PerkElementWidget focused;

    public PerkElementTab(class_310 client, PerkElementScreen screen, PerkElementTabType type, int index, PerkElement root, PerkElementDisplay display) {
        this.client = client;
        this.screen = screen;
        this.type = type;
        this.index = index;
        this.root = root;
        this.display = display;
        this.icon = display.getIcon();
        this.title = display.getTitle();
        this.rootWidget = new PerkElementWidget(this, client, root, display);
        this.addWidget(this.rootWidget, root);
    }

    public PerkElementTabType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public PerkElement getRoot() {
        return this.root;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public PerkElementDisplay getDisplay() {
        return this.display;
    }

    public void drawBackground(class_332 context, int x, int y, boolean selected) {
        this.type.drawBackground(context, x, y, selected, this.index);
    }

    public void drawIcon(class_332 context, int x, int y) {
        this.type.drawIcon(context, x, y, this.index, this.icon);
    }

    public void render(class_332 context, int x, int y) {
        if (!this.initialized) {
            this.originX = 117 - (this.maxPanX + this.minPanX) / 2;
            this.originY = 56 - (this.maxPanY + this.minPanY) / 2;
            this.initialized = true;
        }
        context.method_44379(x, y, x + 234, y + 113);
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)x, (float)y);
        class_2960 identifier = Objects.requireNonNullElse(this.display.getBackground(), class_1060.field_5285);
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        int k = i % 16;
        int l = j % 16;
        for (int m = -1; m <= 15; ++m) {
            for (int n = -1; n <= 8; ++n) {
                context.method_25290(class_10799.field_56883, identifier, k + 16 * m, l + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.rootWidget.renderLines(context, i, j, true);
        this.rootWidget.renderLines(context, i, j, false);
        this.rootWidget.renderWidgets(context, i, j);
        context.method_51448().popMatrix();
        context.method_44380();
    }

    public void drawWidgetTooltip(class_332 context, int mouseX, int mouseY, int x, int y) {
        context.method_51448().pushMatrix();
        context.method_51448().translate(0.0f, 0.0f);
        context.method_25294(0, 0, 234, 113, class_3532.method_15375((float)(this.alpha * 255.0f)) << 24);
        boolean bl = false;
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 113) {
            for (PerkElementWidget perkElementWidget : this.widgets.values()) {
                if (!perkElementWidget.shouldRender(i, j, mouseX, mouseY)) continue;
                bl = true;
                this.focused = perkElementWidget;
                perkElementWidget.drawTooltip(context, i, j, this.alpha, x, y);
                break;
            }
        }
        if (!bl) {
            this.focused = null;
        }
        context.method_51448().popMatrix();
        this.alpha = bl ? class_3532.method_15363((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY) {
        return this.type.isClickOnTab(screenX, screenY, this.index, mouseX, mouseY);
    }

    @Nullable
    public static PerkElementTab create(class_310 client, PerkElementScreen screen, int index, PerkElement root) {
        if (root.getDisplay() == null) {
            return null;
        }
        for (PerkElementTabType perkElementTabType : PerkElementTabType.values()) {
            if (index < perkElementTabType.getTabCount()) {
                return new PerkElementTab(client, screen, perkElementTabType, index, root, root.getDisplay());
            }
            index -= perkElementTabType.getTabCount();
        }
        return null;
    }

    public void move(double offsetX, double offsetY) {
        if (this.maxPanX - this.minPanX > 234) {
            this.originX = class_3532.method_15350((double)(this.originX + offsetX), (double)(-(this.maxPanX - 234)), (double)0.0);
        }
        if (this.maxPanY - this.minPanY > 113) {
            this.originY = class_3532.method_15350((double)(this.originY + offsetY), (double)(-(this.maxPanY - 113)), (double)0.0);
        }
    }

    public void addAdvancement(PerkElement perkElement) {
        if (perkElement.getDisplay() != null) {
            PerkElementWidget perkElementWidget = new PerkElementWidget(this, this.client, perkElement, perkElement.getDisplay());
            this.addWidget(perkElementWidget, perkElement);
        }
    }

    private void addWidget(PerkElementWidget widget, PerkElement perkElement) {
        this.widgets.put(perkElement, widget);
        int i = widget.getX();
        int j = i + 28;
        int k = widget.getY();
        int l = k + 27;
        this.minPanX = Math.min(this.minPanX, i);
        this.maxPanX = Math.max(this.maxPanX, j);
        this.minPanY = Math.min(this.minPanY, k);
        this.maxPanY = Math.max(this.maxPanY, l);
        for (PerkElementWidget perkElementWidget : this.widgets.values()) {
            perkElementWidget.addToTree();
        }
    }

    public Collection<PerkElementWidget> getWidgets() {
        return this.widgets.values();
    }

    @Nullable
    public PerkElementWidget getWidget(PerkElement perkElement) {
        return this.widgets.get(perkElement);
    }

    public PerkElementScreen getScreen() {
        return this.screen;
    }

    public PerkElementWidget getFocused() {
        return this.focused;
    }
}

