/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.guild.PerkElementScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public enum PerkElementTabType {
    ABOVE(0, 0, 28, 32, 8),
    BELOW(84, 0, 28, 32, 8),
    LEFT(0, 64, 32, 28, 5),
    RIGHT(96, 64, 32, 28, 5);

    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int tabCount;

    private PerkElementTabType(int u, int v, int width, int height, int tabCount) {
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.tabCount = tabCount;
    }

    public int getTabCount() {
        return this.tabCount;
    }

    public void drawBackground(class_332 context, int x, int y, boolean selected, int index) {
        int i = this.u;
        if (index > 0) {
            i += this.width;
        }
        if (index == this.tabCount - 1) {
            i += this.width;
        }
        int j = selected ? this.v + this.height : this.v;
        context.method_25290(class_10799.field_56883, PerkElementScreen.TABS_TEXTURE, x + this.getTabX(index), y + this.getTabY(index), (float)i, (float)j, this.width, this.height, 256, 256);
    }

    public void drawIcon(class_332 context, int x, int y, int index, class_1799 stack) {
        int i = x + this.getTabX(index);
        int j = y + this.getTabY(index);
        switch (this.ordinal()) {
            case 0: {
                i += 6;
                j += 9;
                break;
            }
            case 1: {
                i += 6;
                j += 6;
                break;
            }
            case 2: {
                i += 10;
                j += 5;
                break;
            }
            case 3: {
                i += 6;
                j += 5;
            }
        }
        if (stack != null) {
            context.method_51445(stack, i, j);
        }
    }

    public int getTabX(int index) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> (this.width + 4) * index;
            case 2 -> -this.width + 4;
            case 3 -> 248;
        };
    }

    public int getTabY(int index) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -this.height + 4;
            case 1 -> 136;
            case 2, 3 -> this.height * index;
        };
    }

    public boolean isClickOnTab(int screenX, int screenY, int index, double mouseX, double mouseY) {
        int i = screenX + this.getTabX(index);
        int j = screenY + this.getTabY(index);
        return mouseX > (double)i && mouseX < (double)(i + this.width) && mouseY > (double)j && mouseY < (double)(j + this.height);
    }
}

