/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.guild.PerkElement;
import be.elmital.guild.PerkElementDisplay;
import be.elmital.guild.PerkElementTab;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PerkElementWidget {
    private static final class_2960 WIDGETS_TEXTURE = class_2960.method_60655((String)"better-rpp", (String)"textures/gui/perktree/widgets.png");
    private static final int[] SPLIT_OFFSET_CANDIDATES = new int[]{0, 10, -10, 25, -25};
    private final PerkElementTab tab;
    private final PerkElement perkElement;
    private final PerkElementDisplay display;
    private final class_5481 title;
    private final int width;
    private final List<class_5481> description;
    private final class_310 client;
    @Nullable
    private PerkElementWidget parent;
    private final List<PerkElementWidget> children = Lists.newArrayList();
    private final int x;
    private final int y;

    public PerkElementWidget(PerkElementTab tab, class_310 client, PerkElement perkElement, PerkElementDisplay display) {
        this.tab = tab;
        this.perkElement = perkElement;
        this.display = display;
        this.client = client;
        this.title = class_2477.method_10517().method_30934(client.field_1772.method_1714((class_5348)display.getTitle(), 163));
        this.x = class_3532.method_15375((float)(display.getX() * 28.0f));
        this.y = class_3532.method_15375((float)(display.getY() * 27.0f));
        int i = perkElement.getRequirementCount();
        int j = String.valueOf(i).length();
        int k = i > 1 ? client.field_1772.method_1727("  ") + client.field_1772.method_1727("0") * j * 2 + client.field_1772.method_1727("/") : 0;
        int l = 29 + client.field_1772.method_30880(this.title) + k;
        this.description = class_2477.method_10517().method_30933(this.wrapDescription((class_2561)class_2564.method_10889((class_5250)display.getDescription().method_27661(), (class_2583)class_2583.field_24360.method_10977(perkElement.getType().getTitleFormat())), l));
        for (class_5481 orderedText : this.description) {
            l = Math.max(l, client.field_1772.method_30880(orderedText));
        }
        this.width = l + 3 + 5;
    }

    private static float getMaxWidth(class_5225 textHandler, List<class_5348> lines) {
        Stream var10000 = lines.stream();
        Objects.requireNonNull(textHandler);
        return (float)var10000.mapToDouble(arg_0 -> ((class_5225)textHandler).method_27488(arg_0)).max().orElse(0.0);
    }

    private List<class_5348> wrapDescription(class_2561 text, int width) {
        class_5225 textHandler = this.client.field_1772.method_27527();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : SPLIT_OFFSET_CANDIDATES) {
            List list2 = textHandler.method_27495((class_5348)text, width - i, class_2583.field_24360);
            float g = Math.abs(PerkElementWidget.getMaxWidth(textHandler, list2) - (float)width);
            if (g <= 10.0f) {
                return list2;
            }
            if (!(g < f)) continue;
            f = g;
            list = list2;
        }
        return list;
    }

    @Nullable
    private PerkElementWidget getParent(PerkElement perkElement) {
        while ((perkElement = perkElement.getParent()) != null && perkElement.getDisplay() == null) {
        }
        if (perkElement != null && perkElement.getDisplay() != null) {
            return this.tab.getWidget(perkElement);
        }
        return null;
    }

    public void renderLines(class_332 context, int x, int y, boolean border) {
        if (this.parent != null) {
            int n;
            int i = x + this.parent.x + 13;
            int j = x + this.parent.x + 26 + 4;
            int k = y + this.parent.y + 13;
            int l = x + this.x + 13;
            int m = y + this.y + 13;
            int n2 = n = border ? class_9848.method_61324((int)255, (int)42, (int)0, (int)0) : class_9848.method_61324((int)255, (int)112, (int)0, (int)0);
            if (border) {
                context.method_51738(j, i, k - 1, n);
                context.method_51738(j + 1, i, k, n);
                context.method_51738(j, i, k + 1, n);
                context.method_51738(l, j - 1, m - 1, n);
                context.method_51738(l, j - 1, m, n);
                context.method_51738(l, j - 1, m + 1, n);
                context.method_51742(j - 1, m, k, n);
                context.method_51742(j + 1, m, k, n);
            } else {
                context.method_51738(j, i, k, n);
                context.method_51738(l, j, m, n);
                context.method_51742(j, m, k, n);
            }
        }
        for (PerkElementWidget perkElementWidget : this.children) {
            perkElementWidget.renderLines(context, x, y, border);
        }
    }

    public void renderWidgets(class_332 context, int x, int y) {
        if (!this.perkElement.getType().equals((Object)PerkElement.Type.BRANCH)) {
            context.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, x + this.x + 3, y + this.y, (float)this.perkElement.getType().getTextureV(), (float)(128 + (this.perkElement.isUnlocked() ? 0 : 1) * 26), 26, 26, 256, 256);
        }
        if (this.perkElement.getType().equals((Object)PerkElement.Type.PERK)) {
            String[] path = this.perkElement.getPath().split("\\.");
            context.method_25290(class_10799.field_56883, class_2960.method_60655((String)"better-rpp", (String)("textures/gui/perktree/" + path[path.length - 1] + ".png")), x + this.x + 7, y + this.y + 4, 0.0f, 0.0f, 52, 52, 174, 172);
        }
        for (PerkElementWidget perkElementWidget : this.children) {
            perkElementWidget.renderWidgets(context, x, y);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void addChild(PerkElementWidget widget) {
        this.children.add(widget);
    }

    public void drawTooltip(class_332 context, int originX, int originY, float alpha, int x, int y) {
        boolean bl = x + originX + this.x + this.width + 26 >= this.tab.getScreen().field_22789;
        String string = null;
        int i = string == null ? 0 : this.client.field_1772.method_1727(string);
        int var10000 = 113 - originY - this.y - 26;
        int var10002 = this.description.size();
        Objects.requireNonNull(this.client.field_1772);
        boolean bl2 = var10000 <= 6 + var10002 * 9;
        float f = 1.0f;
        int j = class_3532.method_15375((float)(f * (float)this.width));
        j = this.width / 2;
        int k = this.width - j;
        int l = originY + this.y;
        int m = bl ? originX + this.x - this.width + 26 + 6 : originX + this.x;
        int var10001 = this.description.size();
        Objects.requireNonNull(this.client.field_1772);
        int n = 32 + var10001 * 9;
        if (!this.description.isEmpty()) {
            if (bl2) {
                context.method_52706(class_10799.field_56883, class_2960.method_60654((String)"advancements/title_box"), m, l + 26 - n, this.width, n);
            } else {
                context.method_52706(class_10799.field_56883, class_2960.method_60654((String)"advancements/title_box"), m, l, this.width, n);
            }
        }
        context.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, m, l, 0.0f, (float)((this.perkElement.getType().equals((Object)PerkElement.Type.BRANCH) ? 1 : 0) * 26), j, 26, 256, 256);
        context.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, m + j, l, (float)(200 - k), (float)((this.perkElement.getType().equals((Object)PerkElement.Type.BRANCH) ? 1 : 0) * 26), k, 26, 256, 256);
        if (!this.perkElement.getType().equals((Object)PerkElement.Type.BRANCH)) {
            context.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, originX + this.x + 3, originY + this.y, (float)this.perkElement.getType().getTextureV(), (float)(128 + (this.perkElement.isUnlocked() ? 0 : 1) * 26), 26, 26, 256, 256);
        }
        if (bl) {
            context.method_35720(this.client.field_1772, this.title, m + 5, originY + this.y + 9, -1);
            if (string != null) {
                context.method_25303(this.client.field_1772, string, originX + this.x - i, originY + this.y + 9, -1);
            }
        } else {
            context.method_35720(this.client.field_1772, this.title, originX + this.x + 32, originY + this.y + 9, -1);
            if (string != null) {
                context.method_25303(this.client.field_1772, string, originX + this.x + this.width - i - 5, originY + this.y + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                class_327 var21 = this.client.field_1772;
                class_5481 var22 = this.description.get(o);
                int var10003 = m + 5;
                int var10004 = l + 26 - n + 7;
                Objects.requireNonNull(this.client.field_1772);
                context.method_51430(var21, var22, var10003, var10004 + o * 9, -5592406, false);
            }
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                class_327 var21 = this.client.field_1772;
                class_5481 var22 = this.description.get(o);
                int var10003 = m + 5;
                int var10004 = originY + this.y + 9 + 17;
                Objects.requireNonNull(this.client.field_1772);
                context.method_51430(var21, var22, var10003, var10004 + o * 9, -5592406, false);
            }
        }
        if (this.perkElement.getType().equals((Object)PerkElement.Type.PERK)) {
            String[] path = this.perkElement.getPath().split("\\.");
            context.method_25290(class_10799.field_56883, class_2960.method_60655((String)"better-rpp", (String)("textures/gui/perktree/" + path[path.length - 1] + ".png")), originX + this.x + 7, originY + this.y + 4, 0.0f, 0.0f, 52, 52, 174, 172);
        }
    }

    public boolean shouldRender(int originX, int originY, int mouseX, int mouseY) {
        int i = originX + this.x;
        int j = i + 26;
        int k = originY + this.y;
        int l = k + 26;
        return mouseX >= i && mouseX <= j && mouseY >= k && mouseY <= l;
    }

    public void addToTree() {
        if (this.parent == null && this.perkElement.getParent() != null) {
            this.parent = this.getParent(this.perkElement);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public PerkElement getPerkElement() {
        return this.perkElement;
    }
}

