/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.guild;

import be.elmital.BetterRPP;
import be.elmital.guild.PerkElement;
import be.elmital.guild.PerkElementPositioner;
import be.elmital.guild.PerkElementTab;
import be.elmital.guild.PerkElementWidget;
import be.elmital.packet.UnlockPerkPacket;
import be.elmital.packet.Utils;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class PerkElementScreen
extends class_437 {
    private static final class_2960 WINDOW_TEXTURE = class_2960.method_60655((String)"better-rpp", (String)"textures/gui/perktree/window.png");
    public static final class_2960 TABS_TEXTURE = class_2960.method_60655((String)"better-rpp", (String)"textures/gui/perktree/tabs.png");
    private static final class_2561 SAD_LABEL_TEXT = class_2561.method_43470((String)"Pas de Guilde");
    private static final class_2561 EMPTY_TEXT = class_2561.method_43470((String)"C'est vide!");
    private static final class_2561 TITLE = class_2561.method_43470((String)"Arbre de comp\u00e9tence").method_27692(class_124.field_1061);
    private final Map<PerkElement, PerkElementTab> tabs = Maps.newLinkedHashMap();
    @Nullable
    private PerkElementTab selectedTab;
    private final LinkedHashMap<PerkElement.Builder, String> tree;
    private boolean movingTab;

    public PerkElementScreen(LinkedHashMap<PerkElement.Builder, String> tree) {
        super(class_333.field_18967);
        this.tree = tree;
    }

    protected void method_25426() {
        this.tabs.clear();
        this.selectedTab = null;
        Set<Map.Entry<PerkElement.Builder, String>> set = this.tree.entrySet();
        LinkedHashMap<String, PerkElement> elements = new LinkedHashMap<String, PerkElement>();
        this.tree.forEach((builder, string) -> {
            for (Map.Entry entry : set) {
                if (!((String)entry.getValue()).equalsIgnoreCase((String)string)) continue;
                PerkElement inElements = (PerkElement)elements.get(string);
                if (inElements != null) {
                    builder.parent(inElements);
                    break;
                }
                inElements = ((PerkElement.Builder)entry.getKey()).build("better-rp/" + builder.getPath());
                elements.put(inElements.getPath(), inElements);
                break;
            }
            elements.put(builder.getPath(), builder.build("better-rp/" + builder.getPath()));
        });
        elements.forEach((string, perkElement) -> {
            if (perkElement.getType().equals((Object)PerkElement.Type.NODE)) {
                PerkElementPositioner.arrangeForTree(perkElement);
                this.onRootAdded((PerkElement)perkElement);
            } else {
                this.onDependentAdded((PerkElement)perkElement);
            }
        });
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.values().iterator().next();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int i = (this.field_22789 - 252) / 2;
            int j = (this.field_22790 - 140) / 2;
            for (PerkElementTab perkElementTab : this.tabs.values()) {
                if (!perkElementTab.isClickOnTab(i, j, mouseX, mouseY)) continue;
                this.selectedTab = perkElementTab;
                return super.method_25402(mouseX, mouseY, button);
            }
            if (this.selectedTab != null) {
                for (PerkElementWidget widget : this.selectedTab.getWidgets()) {
                    if (this.selectedTab.getFocused() == null || !widget.getPerkElement().canBeUnlockOrUpgrade() || !this.selectedTab.getFocused().equals(widget) || !widget.getPerkElement().getType().equals((Object)PerkElement.Type.PERK)) continue;
                    this.method_25419();
                    if (BetterRPP.isActive()) {
                        Utils.sendPacket(new UnlockPerkPacket(widget.getPerkElement().getPath()));
                    }
                    return false;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i = (this.field_22789 - 252) / 2;
        int j = (this.field_22790 - 140) / 2;
        this.method_25420(context, mouseX, mouseY, delta);
        this.drawAdvancementTree(context, mouseX, mouseY, i, j);
        this.drawWindow(context, i, j);
        this.drawWidgetTooltip(context, mouseX, mouseY, i, j);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            this.movingTab = false;
            return false;
        }
        if (!this.movingTab) {
            this.movingTab = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.move(deltaX, deltaY);
        }
        return true;
    }

    private void drawAdvancementTree(class_332 context, int mouseX, int mouseY, int x, int y) {
        PerkElementTab perkElementTab = this.selectedTab;
        if (perkElementTab == null) {
            context.method_25294(x + 9, y + 18, x + 9 + 234, y + 18 + 113, -16777216);
            int i = x + 9 + 117;
            class_327 var10001 = this.field_22793;
            class_2561 var10002 = EMPTY_TEXT;
            int var10004 = y + 18 + 56;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(var10001, var10002, i, var10004 - 4, -1);
            var10001 = this.field_22793;
            var10002 = SAD_LABEL_TEXT;
            var10004 = y + 18 + 113;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(var10001, var10002, i, var10004 - 9, -1);
        } else {
            perkElementTab.render(context, x + 9, y + 18);
        }
    }

    public void drawWindow(class_332 context, int x, int y) {
        RenderSystem.enableBlend();
        context.method_25290(class_1921::method_62277, WINDOW_TEXTURE, x, y, 0.0f, 0.0f, 252, 140, 256, 256);
        if (this.tabs.size() > 1) {
            for (PerkElementTab perkElementTab : this.tabs.values()) {
                perkElementTab.drawBackground(context, x, y, perkElementTab == this.selectedTab);
            }
            for (PerkElementTab perkElementTab : this.tabs.values()) {
                perkElementTab.drawIcon(context, x, y);
            }
        }
        context.method_51439(this.field_22793, TITLE, x + 72, y + 4, 0x404040, false);
    }

    private void drawWidgetTooltip(class_332 context, int mouseX, int mouseY, int x, int y) {
        if (this.selectedTab != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(x + 9), (float)(y + 18), 400.0f);
            RenderSystem.enableDepthTest();
            this.selectedTab.drawWidgetTooltip(context, mouseX - x - 9, mouseY - y - 18, x, y);
            RenderSystem.disableDepthTest();
            context.method_51448().method_22909();
        }
        if (this.tabs.size() > 1) {
            for (PerkElementTab perkElementTab : this.tabs.values()) {
                if (!perkElementTab.isClickOnTab(x, y, mouseX, mouseY)) continue;
                context.method_51438(this.field_22793, perkElementTab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void onRootAdded(PerkElement root) {
        PerkElementTab perkElementTab = PerkElementTab.create(this.field_22787, this, this.tabs.size(), root);
        if (perkElementTab != null) {
            this.tabs.put(root, perkElementTab);
        }
    }

    public void onRootRemoved(PerkElement root) {
    }

    public void onDependentAdded(PerkElement dependent) {
        PerkElementTab perkElementTab = this.getTab(dependent);
        if (perkElementTab != null) {
            perkElementTab.addAdvancement(dependent);
        }
    }

    public void onDependentRemoved(PerkElement dependent) {
    }

    public void selectTab(@Nullable PerkElement perkElement) {
        this.selectedTab = this.tabs.get(perkElement);
    }

    public void onClear() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public PerkElementWidget getAdvancementWidget(PerkElement perkElement) {
        PerkElementTab perkElementTab = this.getTab(perkElement);
        return perkElementTab == null ? null : perkElementTab.getWidget(perkElement);
    }

    @Nullable
    private PerkElementTab getTab(PerkElement perkElement) {
        while (perkElement.getParent() != null) {
            perkElement = perkElement.getParent();
        }
        return this.tabs.get(perkElement);
    }
}

