/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.fancydooranim;

import io.github.yxmna.fancydooranim.DoorAnimMath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DoorAnimationTracker {
    private static final Logger LOG = LoggerFactory.getLogger((String)"fancy-door-anim");
    public static final long ANIM_DURATION_NANOS = 240000000L;
    public static final long REVEAL_LEAD_NANOS = 50000000L;
    private static final long DEDUPE_WINDOW_NANOS = 150000000L;
    private static final Map<class_2338, Entry> entries = new HashMap<class_2338, Entry>();

    public static void put(class_2338 pos, boolean opening, class_2750 hinge, class_2756 half, class_2350 facing) {
        long now = System.nanoTime();
        Entry existing = entries.get(pos);
        if (existing != null && existing.opening == opening && existing.hinge == hinge && existing.facing == facing && now - existing.startNanos < 150000000L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[FDA] dedupe {} at {} (duplicate trigger suppressed)", (Object)(opening ? "OPEN" : "CLOSE"), (Object)pos);
            }
            return;
        }
        entries.put(pos, new Entry(opening, now, hinge, half, facing));
        if (LOG.isDebugEnabled()) {
            LOG.debug("[FDA] put {} at {} hinge={} half={} facing={} size={}", new Object[]{opening ? "OPEN" : "CLOSE", pos, hinge, half, facing, entries.size()});
        }
    }

    public static void pruneExpired() {
        long now = System.nanoTime();
        Iterator<Map.Entry<class_2338, Entry>> it = entries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, Entry> e = it.next();
            if (now - e.getValue().startNanos <= 240000000L) continue;
            it.remove();
        }
    }

    public static void clearAll() {
        entries.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("[FDA] clearAll");
        }
    }

    public static Float computeAngleDeg(class_2338 pos) {
        Entry e = entries.get(pos);
        if (e == null) {
            return null;
        }
        long now = System.nanoTime();
        if (!e.revealScheduled && now >= e.hideUntilNanos) {
            e.revealScheduled = true;
            DoorAnimationTracker.requestRerender(pos);
        }
        if (now - e.startNanos >= 240000000L) {
            entries.remove(pos);
            DoorAnimationTracker.requestRerender(pos);
            return null;
        }
        return Float.valueOf(DoorAnimMath.currentAngleDeg(e.facing, e.hinge, e.opening, e.startNanos, now, 240000000L));
    }

    public static void forEachActive(BiConsumer<class_2338, Entry> consumer) {
        HashMap<class_2338, Entry> snapshot = new HashMap<class_2338, Entry>(entries);
        for (Map.Entry<class_2338, Entry> it : snapshot.entrySet()) {
            consumer.accept(it.getKey(), it.getValue());
        }
    }

    public static boolean isDoorHiddenAt(class_2338 pos) {
        long now = System.nanoTime();
        Entry e = entries.get(pos);
        if (e != null && now < e.hideUntilNanos) {
            return true;
        }
        Entry lower = entries.get(pos.method_10074());
        return lower != null && now < lower.hideUntilNanos;
    }

    private static void requestRerender(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null || mc.field_1769 == null) {
            return;
        }
        DoorAnimationTracker.forceRerenderPos(mc, pos);
        DoorAnimationTracker.forceRerenderPos(mc, pos.method_10084());
    }

    private static void forceRerenderPos(class_310 mc, class_2338 p) {
        block5: {
            class_2680 s = mc.field_1687.method_8320(p);
            if (s == null) {
                return;
            }
            try {
                if (s.method_28498((class_2769)class_2741.field_12537)) {
                    class_2680 sFlip = (class_2680)s.method_28493((class_2769)class_2741.field_12537);
                    mc.field_1769.method_21596(p, s, sFlip);
                    mc.field_1769.method_21596(p, sFlip, s);
                    return;
                }
                if (s.method_28498((class_2769)class_2741.field_12484)) {
                    class_2680 sFlip = (class_2680)s.method_28493((class_2769)class_2741.field_12484);
                    mc.field_1769.method_21596(p, s, sFlip);
                    mc.field_1769.method_21596(p, sFlip, s);
                    return;
                }
                mc.field_1769.method_21596(p, s, s);
            }
            catch (Throwable t) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace("[FDA] rerender failed at {}: {}", (Object)p, (Object)t.toString());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Entry {
        public final boolean opening;
        public final long startNanos;
        public final class_2750 hinge;
        public final class_2756 half;
        public final class_2350 facing;
        public final long hideUntilNanos;
        public boolean revealScheduled = false;

        public Entry(boolean opening, long startNanos, class_2750 hinge, class_2756 half, class_2350 facing) {
            this.opening = opening;
            this.startNanos = startNanos;
            this.hinge = hinge;
            this.half = half;
            this.facing = facing;
            long end = startNanos + 240000000L;
            long lead = Math.min(50000000L, Math.max(0L, 239000000L));
            this.hideUntilNanos = Math.max(startNanos, end - lead);
        }
    }
}

