/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.fancydooranim;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2750;

@Environment(value=EnvType.CLIENT)
public final class DoorAnimMath {
    public static final float DOOR_THICKNESS = 0.1875f;

    private DoorAnimMath() {
    }

    public static Inset lateralInsetTowardHinge(class_2350 facing, class_2750 hinge, float angleDeg) {
        float a = Math.abs(angleDeg);
        float inset = 0.1875f * (float)Math.sin(Math.toRadians(a));
        Pivot p = DoorAnimMath.hingePivot(facing, hinge);
        float dx = 0.0f;
        float dz = 0.0f;
        switch (facing) {
            case field_11043: 
            case field_11035: {
                dx = p.x < 0.5f ? inset : -inset;
                break;
            }
            case field_11034: 
            case field_11039: {
                dz = p.z < 0.5f ? inset : -inset;
                break;
            }
        }
        return new Inset(dx, dz);
    }

    public static float targetAngleDeg(class_2350 facing, class_2750 hinge, boolean opening) {
        int sign = DoorAnimMath.angleSign(facing, hinge);
        return opening ? 90.0f * (float)sign : 0.0f;
    }

    public static int angleSign(class_2350 facing, class_2750 hinge) {
        return hinge == class_2750.field_12588 ? 1 : -1;
    }

    public static Pivot hingePivot(class_2350 facing, class_2750 hinge) {
        switch (facing) {
            case field_11043: {
                return hinge == class_2750.field_12588 ? new Pivot(0.0f, 1.0f) : new Pivot(1.0f, 1.0f);
            }
            case field_11034: {
                return hinge == class_2750.field_12588 ? new Pivot(0.0f, 0.0f) : new Pivot(0.0f, 1.0f);
            }
            case field_11035: {
                return hinge == class_2750.field_12588 ? new Pivot(1.0f, 0.0f) : new Pivot(0.0f, 0.0f);
            }
            case field_11039: {
                return hinge == class_2750.field_12588 ? new Pivot(1.0f, 1.0f) : new Pivot(1.0f, 0.0f);
            }
        }
        return new Pivot(0.0f, 0.0f);
    }

    public static float ease01(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        float u = 1.0f - t;
        return 1.0f - u * u * u;
    }

    public static float currentAngleDeg(class_2350 facing, class_2750 hinge, boolean opening, long startNanos, long nowNanos, long durationNanos) {
        float t = (float)(nowNanos - startNanos) / (float)durationNanos;
        float k = DoorAnimMath.ease01(t);
        int sign = DoorAnimMath.angleSign(facing, hinge);
        float target = 90.0f * (float)sign;
        return opening ? k * target : (1.0f - k) * target;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Pivot {
        public final float x;
        public final float z;

        public Pivot(float x, float z) {
            this.x = x;
            this.z = z;
        }

        public String toString() {
            return "Pivot{x=" + this.x + ", z=" + this.z + "}";
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Inset {
        public final float dx;
        public final float dz;

        public Inset(float dx, float dz) {
            this.dx = dx;
            this.dz = dz;
        }
    }
}

