/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.fancydooranim;

import io.github.yxmna.fancydooranim.DoorAnimationTracker;
import io.github.yxmna.fancydooranim.model.DoorHidingModel;
import io.github.yxmna.fancydooranim.render.DoorAnimatedOverlay;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FancyDoorAnimClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fancy-door-anim");
    private static boolean greeted = false;

    public void onInitializeClient() {
        LOGGER.info("Fancy Door Anim client initializing...");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            DoorAnimationTracker.pruneExpired();
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DoorAnimationTracker.clearAll());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> DoorAnimationTracker.clearAll());
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.modifyModelAfterBake().register((bakedModel, ctx2) -> {
            String path = null;
            class_2960 resId = ctx2.resourceId();
            if (resId != null) {
                path = resId.method_12832();
            } else {
                class_1091 top = ctx2.topLevelId();
                if (top != null && top.comp_2875() != null) {
                    path = top.comp_2875().method_12832();
                }
            }
            if (path != null) {
                boolean isDoorModel;
                boolean bl = isDoorModel = path.contains("_door") || path.contains("/door/") || path.endsWith("door_bottom") || path.endsWith("door_top");
                if (isDoorModel && bakedModel != null) {
                    return new DoorHidingModel(bakedModel);
                }
            }
            return bakedModel;
        }));
        DoorAnimatedOverlay.init();
    }
}

