/*
 * Decompiled with CFR 0.152.
 */
package net.giok3r.whereami;

import net.giok3r.whereami.CompassDirection;
import net.giok3r.whereami.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import org.apache.commons.lang3.mutable.MutableInt;

@EventBusSubscriber(value={Dist.CLIENT}, modid="whereami")
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getDebugOverlay().showDebugScreen()) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Font font = mc.font;
        Level level = player.level();
        MutableInt guiY = new MutableInt(10);
        ClientEvents.renderLocation(event, guiY, player, font);
        ClientEvents.renderBiome(event, guiY, level, player, font);
        ClientEvents.renderTimeAndDay(event, guiY, level, font);
    }

    private static void renderLocation(RenderGuiEvent.Post event, MutableInt guiY, LocalPlayer player, Font font) {
        MutableComponent text;
        if (!Config.displayLocation && !Config.displayDirection) {
            return;
        }
        int x = (int)player.position().x;
        int y = (int)player.position().y;
        int z = (int)player.position().z;
        CompassDirection direction = CompassDirection.fromAngle(player.getYRot());
        if (Config.displayLocation) {
            String directionSuffix = Config.displayDirection ? " " + direction.name() : "";
            text = Component.literal((String)(x + ", " + y + ", " + z + directionSuffix));
        } else {
            text = Component.literal((String)direction.name());
        }
        event.getGuiGraphics().drawString(font, (Component)text, 10, guiY.getAndAdd(10), -1, true);
    }

    private static void renderBiome(RenderGuiEvent.Post event, MutableInt guiY, Level level, LocalPlayer player, Font font) {
        if (!Config.displayBiome) {
            return;
        }
        Holder biomeHolder = level.getBiome(player.blockPosition());
        if (biomeHolder.getKey() != null) {
            ResourceLocation biomeId = biomeHolder.getKey().location();
            MutableComponent biomeName = Component.translatable((String)("biome." + biomeId.getNamespace() + "." + biomeId.getPath()));
            event.getGuiGraphics().drawString(font, (Component)biomeName, 10, guiY.getAndAdd(10), -3355444, true);
        }
    }

    private static void renderTimeAndDay(RenderGuiEvent.Post event, MutableInt guiY, Level level, Font font) {
        String amOrPm;
        int hour;
        if (!Config.displayTimeAndDay) {
            return;
        }
        int time = (int)level.getDayTime() % 24000;
        if (time < 7000) {
            hour = time / 1000 + 6;
            amOrPm = hour == 12 ? "PM" : "AM";
        } else if (time < 19000) {
            hour = time / 1000 - 6;
            amOrPm = hour == 12 ? "AM" : "PM";
        } else {
            hour = time / 1000 - 18;
            amOrPm = "AM";
        }
        int minute = (int)((double)(time % 1000) * 0.06);
        int day = (int)(level.getDayTime() / 24000L);
        String timeStr = String.format("%d:%02d %s (Day %d)", hour, minute, amOrPm, day);
        event.getGuiGraphics().drawString(font, timeStr, 10, guiY.getAndAdd(10), -5592406, true);
    }
}

