/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.night.progression.mixin;

import com.devnemo.nemos.night.progression.interfaces.IFurnaceHelper;
import com.devnemo.nemos.night.progression.interfaces.IServerLevelHelper;
import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class NeoForgeAbstractFurnaceBlockEntityMixin
implements IFurnaceHelper {
    @Shadow
    int litTimeRemaining;
    @Shadow
    int cookingTotalTime;
    @Shadow
    protected NonNullList<ItemStack> items;

    @Shadow
    protected abstract int getBurnDuration(FuelValues var1, ItemStack var2);

    @ModifyExpressionValue(method={"serverTick"}, at={@At(value="MIXINEXTRAS:EXPRESSION", ordinal=0)})
    @Definitions(value={@Definition(id="furnace", local={@Local(argsOnly=true, type=AbstractFurnaceBlockEntity.class)}), @Definition(id="cookingTimer", field={"Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingTimer:I"})})
    @Expression(value={"furnace.cookingTimer"})
    private static int updateCookingTimer(int original, @Local(argsOnly=true) ServerLevel serverLevel, @Local(argsOnly=true) AbstractFurnaceBlockEntity furnace, @Local RecipeHolder<? extends AbstractCookingRecipe> recipeHolder, @Local SingleRecipeInput singleRecipeInput, @Local(ordinal=1) boolean flag) {
        IFurnaceHelper furnaceHelper = (IFurnaceHelper)furnace;
        IServerLevelHelper serverLevelHelper = (IServerLevelHelper)serverLevel;
        long progressingTicks = serverLevelHelper.nemosNightProgression$getAfterSleepTime() - serverLevelHelper.nemosNightProgression$getBeforeSleepTime();
        ItemStack itemStack = (ItemStack)furnaceHelper.nemosNightProgression$getItems().get(1);
        int burnDuration = furnaceHelper.nemosNightProgression$getBurnDuration(serverLevel.fuelValues(), itemStack);
        int updatedLitTimeRemaining = furnaceHelper.nemosNightProgression$getLitTimeRemaining() + itemStack.getCount() * burnDuration;
        long updatedCookingTimer = (long)original + progressingTicks - 1L;
        long lowest = Math.min((long)updatedLitTimeRemaining, updatedCookingTimer);
        boolean shouldHandleNightProgression = serverLevelHelper.nemosNightProgression$shouldHandleNightProgression();
        int progressedTicks = 0;
        if (!shouldHandleNightProgression) {
            return original;
        }
        while (lowest > (long)furnaceHelper.nemosNightProgression$getCookingTotalTime()) {
            lowest -= (long)furnaceHelper.nemosNightProgression$getCookingTotalTime();
            updatedLitTimeRemaining -= furnaceHelper.nemosNightProgression$getCookingTotalTime();
            updatedCookingTimer -= (long)furnaceHelper.nemosNightProgression$getCookingTotalTime();
            progressedTicks += furnaceHelper.nemosNightProgression$getCookingTotalTime();
            if (AbstractFurnaceBlockEntity.burn((RegistryAccess)serverLevel.registryAccess(), recipeHolder, (SingleRecipeInput)singleRecipeInput, furnaceHelper.nemosNightProgression$getItems(), (int)furnace.getMaxStackSize())) {
                furnace.setRecipeUsed(recipeHolder);
            }
            flag = true;
        }
        if (burnDuration != 0) {
            int usedItems = progressedTicks / burnDuration;
            if (usedItems >= 1) {
                itemStack.shrink(usedItems);
            }
            furnaceHelper.nemosNightProgression$setLitTimeRemaining(updatedLitTimeRemaining - itemStack.getCount() * burnDuration);
        } else {
            furnaceHelper.nemosNightProgression$setLitTimeRemaining(updatedLitTimeRemaining);
        }
        return (int)updatedCookingTimer;
    }

    @Override
    public int nemosNightProgression$getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    @Override
    public NonNullList<ItemStack> nemosNightProgression$getItems() {
        return this.items;
    }

    @Override
    public int nemosNightProgression$getBurnDuration(FuelValues fuelValues, ItemStack itemStack) {
        return this.getBurnDuration(fuelValues, itemStack);
    }

    @Override
    public int nemosNightProgression$getLitTimeRemaining() {
        return this.litTimeRemaining;
    }

    @Override
    public void nemosNightProgression$setLitTimeRemaining(int litTimeRemaining) {
        this.litTimeRemaining = litTimeRemaining;
    }
}

