/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.night.progression.mixin;

import com.devnemo.nemos.night.progression.interfaces.IServerLevelHelper;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements IServerLevelHelper {
    @Shadow
    @Final
    private MinecraftServer server;
    @Unique
    private boolean nemosNightProgression$shouldHandleNightProgression = false;
    @Unique
    private long nemosNightProgression$beforeSleepTime = 0L;
    @Unique
    private long nemosNightProgression$afterSleepTime = 0L;

    @Shadow
    public abstract ServerLevel getLevel();

    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V")})
    private void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        long j = this.getDayTime() + 24000L;
        this.nemosNightProgression$setShouldHandleNightProgression(true);
        this.nemosNightProgression$setBeforeSleepTime(this.getDayTime());
        this.nemosNightProgression$setAfterSleepTime(j - j % 24000L);
        long ticksSlept = this.nemosNightProgression$afterSleepTime - this.nemosNightProgression$beforeSleepTime;
        ((GameRules.IntegerValue)this.getLevel().getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).set(3 * (int)ticksSlept, this.server);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickAtEnd(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ((GameRules.IntegerValue)this.getLevel().getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).set(3, this.server);
        this.nemosNightProgression$setShouldHandleNightProgression(false);
    }

    @Override
    public boolean nemosNightProgression$shouldHandleNightProgression() {
        return this.nemosNightProgression$shouldHandleNightProgression;
    }

    @Override
    public void nemosNightProgression$setShouldHandleNightProgression(boolean shouldHandleNightProgression) {
        this.nemosNightProgression$shouldHandleNightProgression = shouldHandleNightProgression;
    }

    @Override
    public long nemosNightProgression$getBeforeSleepTime() {
        return this.nemosNightProgression$beforeSleepTime;
    }

    @Override
    public void nemosNightProgression$setBeforeSleepTime(long beforeSleepTime) {
        this.nemosNightProgression$beforeSleepTime = beforeSleepTime;
    }

    @Override
    public long nemosNightProgression$getAfterSleepTime() {
        return this.nemosNightProgression$afterSleepTime;
    }

    @Override
    public void nemosNightProgression$setAfterSleepTime(long afterSleepTime) {
        this.nemosNightProgression$afterSleepTime = afterSleepTime;
    }
}

