/*
 * Decompiled with CFR 0.152.
 */
package no2.bugfixerupper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no2.bugfixerupper.BugFixerUpper;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BugFixerUpperMixinPlugin
implements IMixinConfigPlugin {
    private static final String CONFIG_FILE_NAME = "bug-fixer-upper-config.properties";
    private Properties config;

    public void onLoad(String mixinPackage) {
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        this.config = new Properties();
        Path configPath = Paths.get("config", CONFIG_FILE_NAME);
        InputStream configStream = null;
        try {
            if (Files.exists(configPath, new LinkOption[0])) {
                configStream = Files.newInputStream(configPath, new OpenOption[0]);
                this.config.load(configStream);
            } else {
                configStream = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
                if (configStream != null) {
                    this.config.load(configStream);
                } else {
                    this.createDefaultConfig(configPath);
                }
            }
        }
        catch (IOException e) {
            BugFixerUpper.LOGGER.error("Failed to load BugFixerUpper config, creating default: {}", (Object)e.getMessage());
            this.createDefaultConfig(configPath);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createDefaultConfig(Path configPath) {
        Properties defaultConfig = new Properties();
        Set<String> detectedPackages = this.detectMixinPackages();
        for (String packageName : detectedPackages) {
            defaultConfig.setProperty(packageName, "true");
        }
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
                defaultConfig.store(out, "BugFixerUpper Mixin Configuration\nSet to false to disable specific mixin packages\nParent packages control their children (e.g., misc=false disables all misc.* packages)\nChildren packages can only be configured if their parent packages are enabled");
            }
            this.config = defaultConfig;
            BugFixerUpper.LOGGER.info("Created default BugFixerUpper config at: {}", (Object)configPath);
        }
        catch (IOException e) {
            BugFixerUpper.LOGGER.error("Failed to create default config: {}", (Object)e.getMessage());
            this.config = defaultConfig;
        }
    }

    private Set<String> detectMixinPackages() {
        HashSet<String> packages = new HashSet<String>();
        try {
            this.detectPackagesFromMixinConfig("bug-fixer-upper.mixins.json", "no2.bugfixerupper.mixin", packages);
            this.detectPackagesFromMixinConfig("bug-fixer-upper.client.mixins.json", "no2.bugfixerupper.mixin.client", packages);
        }
        catch (Exception e) {
            BugFixerUpper.LOGGER.error("Failed to auto-detect mixin packages: {}", (Object)e.getMessage());
        }
        return packages;
    }

    private void detectPackagesFromMixinConfig(String configFileName, String basePackage, Set<String> packages) {
        try {
            InputStream configStream = this.getClass().getClassLoader().getResourceAsStream(configFileName);
            if (configStream == null) {
                return;
            }
            String jsonContent = new Scanner(configStream, StandardCharsets.UTF_8).useDelimiter("\\A").next();
            configStream.close();
            String mixinsSection = this.extractJsonArray(jsonContent, "mixins");
            this.extractPackages(basePackage, packages, mixinsSection);
            String clientSection = this.extractJsonArray(jsonContent, "client");
            this.extractPackages(basePackage, packages, clientSection);
        }
        catch (Exception e) {
            BugFixerUpper.LOGGER.error("Failed to parse mixin config {}: {}", (Object)configFileName, (Object)e.getMessage());
        }
    }

    private void extractPackages(String basePackage, Set<String> packages, String clientSection) {
        if (clientSection != null) {
            String[] clientEntries;
            for (String entry : clientEntries = clientSection.split(",")) {
                String fullClassName;
                String packagePath;
                String mixinClass = entry.trim().replaceAll("\"", "").trim();
                if (mixinClass.isEmpty() || (packagePath = this.extractPackagePath(fullClassName = basePackage + "." + mixinClass)) == null) continue;
                this.addPackageHierarchy(packagePath, packages);
            }
        }
    }

    private String extractJsonArray(String json, String arrayName) {
        String pattern = "\"" + arrayName + "\"\\s*:\\s*\\[([^]]+)]";
        Pattern p = Pattern.compile(pattern, 32);
        Matcher m = p.matcher(json);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private void addPackageHierarchy(String packagePath, Set<String> packages) {
        String[] parts = packagePath.split("\\.");
        for (int i = 1; i <= parts.length; ++i) {
            String currentPath = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i));
            packages.add(currentPath);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String packagePath = this.extractPackagePath(mixinClassName);
        if (packagePath != null) {
            return this.isPackageEnabled(packagePath);
        }
        BugFixerUpper.LOGGER.warn("Fallback to enabled for mixin class {}", (Object)mixinClassName);
        return true;
    }

    private String extractPackagePath(String mixinClassName) {
        String remainder;
        int lastDotIndex;
        String basePackage = "no2.bugfixerupper.mixin.";
        if (mixinClassName.startsWith(basePackage) && (lastDotIndex = (remainder = mixinClassName.substring(basePackage.length())).lastIndexOf(46)) > 0) {
            return remainder.substring(0, lastDotIndex);
        }
        return null;
    }

    private boolean isPackageEnabled(String packagePath) {
        String[] parts = packagePath.split("\\.");
        for (int i = 1; i <= parts.length; ++i) {
            boolean enabled;
            String currentPath = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i));
            String value = this.config.getProperty(currentPath);
            if (value == null || (enabled = Boolean.parseBoolean(value))) continue;
            return false;
        }
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

