/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.database;

import dev.akatriggered.G1axStats;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DatabaseManager {
    private final G1axStats plugin;
    private Connection connection;
    private final ConcurrentHashMap<String, Integer> cache = new ConcurrentHashMap();

    public DatabaseManager(G1axStats plugin) {
        this.plugin = plugin;
        this.initDatabase();
        this.startCacheFlushTask();
    }

    private void initDatabase() {
        try {
            File dbFile = new File(this.plugin.getDataFolder(), "stats.db");
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getPath());
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS player_kills (killer_uuid TEXT NOT NULL, victim_uuid TEXT NOT NULL, kills INTEGER DEFAULT 0, PRIMARY KEY (killer_uuid, victim_uuid))");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize database: " + e.getMessage());
        }
    }

    public CompletableFuture<Integer> getKills(String killerUuid, String victimUuid) {
        String key = killerUuid + ":" + victimUuid;
        Integer cached = this.cache.get(key);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            Integer n;
            block8: {
                PreparedStatement stmt = this.connection.prepareStatement("SELECT kills FROM player_kills WHERE killer_uuid = ? AND victim_uuid = ?");
                try {
                    stmt.setString(1, killerUuid);
                    stmt.setString(2, victimUuid);
                    ResultSet rs = stmt.executeQuery();
                    int kills = rs.next() ? rs.getInt("kills") : 0;
                    this.cache.put(key, kills);
                    n = kills;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().warning("Failed to get kills: " + e.getMessage());
                        return 0;
                    }
                }
                stmt.close();
            }
            return n;
        });
    }

    public void incrementKills(String killerUuid, String victimUuid) {
        String key = killerUuid + ":" + victimUuid;
        this.cache.merge(key, 1, Integer::sum);
    }

    private void startCacheFlushTask() {
        new BukkitRunnable(){

            public void run() {
                DatabaseManager.this.flushCache();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 1200L, 1200L);
    }

    private void flushCache() {
        if (this.cache.isEmpty()) {
            return;
        }
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT OR REPLACE INTO player_kills (killer_uuid, victim_uuid, kills) VALUES (?, ?, ?)");){
            for (Map.Entry<String, Integer> entry : this.cache.entrySet()) {
                String[] parts = entry.getKey().split(":");
                stmt.setString(1, parts[0]);
                stmt.setString(2, parts[1]);
                stmt.setInt(3, entry.getValue());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to flush cache: " + e.getMessage());
        }
    }

    public void close() {
        this.flushCache();
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to close database: " + e.getMessage());
        }
    }
}

