/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.manager;

import dev.akatriggered.database.DatabaseManager;
import dev.akatriggered.util.ColorUtil;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class StatsManager {
    private final DatabaseManager databaseManager;

    public StatsManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public void handleKill(Player killer, Player victim) {
        String killerUuid = killer.getUniqueId().toString();
        String victimUuid = victim.getUniqueId().toString();
        this.databaseManager.incrementKills(killerUuid, victimUuid);
        CompletableFuture.allOf(this.databaseManager.getKills(killerUuid, victimUuid), this.databaseManager.getKills(victimUuid, killerUuid)).thenAccept(v -> this.databaseManager.getKills(killerUuid, victimUuid).thenAccept(killerKills -> this.databaseManager.getKills(victimUuid, killerUuid).thenAccept(victimKills -> {
            String message = ColorUtil.colorize(String.format("&a%s &7%d &8- &c%s &7%d", killer.getName(), killerKills, victim.getName(), victimKills));
            killer.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        })));
    }

    public CompletableFuture<Integer> getKills(Player killer, Player victim) {
        return this.databaseManager.getKills(killer.getUniqueId().toString(), victim.getUniqueId().toString());
    }

    public void shutdown() {
    }
}

