/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class ColorUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");

    public static String colorize(String text) {
        text = ColorUtil.translateHexColors(text);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private static String translateHexColors(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace('#', 'x');
            StringBuilder magic = new StringBuilder("&");
            for (char c : replaceSharp.toCharArray()) {
                magic.append('&').append(c);
            }
            matcher.appendReplacement(buffer, magic.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

