/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys;

import de.bitcoinclient.bountys.commands.BountiesAdminCommand;
import de.bitcoinclient.bountys.commands.BountiesCommand;
import de.bitcoinclient.bountys.events.KillEvents;
import de.bitcoinclient.bountys.events.ServerInteractEvents;
import de.bitcoinclient.bountys.inventorys.AddBountyInventory;
import de.bitcoinclient.bountys.inventorys.list.PlayersCache;
import de.bitcoinclient.bountys.inventorys.list.PlayersInventory;
import de.bitcoinclient.bountys.utils.builders.ConfigManager;
import de.bitcoinclient.bountys.utils.config.LanguageConfig;
import de.bitcoinclient.bountys.utils.config.PluginConfig;
import de.bitcoinclient.bountys.utils.modrinth.ModrinthAPI;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Bountys
extends JavaPlugin {
    private static Logger logger = Logger.getLogger("Bountys");
    private static Economy econ = null;
    private static ConfigManager bountys;
    private static ConfigManager languages;
    private static PluginConfig pluginConfig;

    public void onEnable() {
        if (!this.setupEconomy()) {
            logger.severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)Bountys.getProvidingPlugin(Bountys.class));
            return;
        }
        pluginConfig = new PluginConfig();
        ModrinthAPI.checkVersion();
        try {
            bountys = new ConfigManager("plugins/Bounties", "bounties");
            languages = new ConfigManager("plugins/Bounties", "language");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LanguageConfig.load();
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new ServerInteractEvents(), (Plugin)this);
        pluginManager.registerEvents((Listener)new KillEvents(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayersInventory(), (Plugin)this);
        pluginManager.registerEvents((Listener)new AddBountyInventory(), (Plugin)this);
        PlayersCache.load();
        this.getCommand("bounties").setExecutor((CommandExecutor)new BountiesCommand());
        this.getCommand("bountyadmin").setExecutor((CommandExecutor)new BountiesAdminCommand());
        Bountys.getLoggerManager().info("Bounties was successfully activated!");
    }

    public void onDisable() {
        Bountys.getLoggerManager().info("Bountys was successfully unloaded!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            Bountys.getLoggerManager().severe("Vault Plugin wasn`t detected!");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            Bountys.getLoggerManager().severe("Economy is missing");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return true;
    }

    public static Logger getLoggerManager() {
        return logger;
    }

    public static Economy getEcon() {
        return econ;
    }

    public static String getPrefix() {
        return LanguageConfig.prefix;
    }

    public static ConfigManager getBountys() {
        return bountys;
    }

    public static ConfigManager getLanguageConfig() {
        return languages;
    }

    public static PluginConfig getPluginConfig() {
        return pluginConfig;
    }
}

