/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.commands;

import de.bitcoinclient.bountys.utils.config.BountyManager;
import de.bitcoinclient.bountys.utils.config.LanguageConfig;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class BountiesAdminCommand
implements CommandExecutor,
TabExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (!(sender instanceof Player)) {
            Bukkit.getConsoleSender().sendMessage(LanguageConfig.getMessages("command.bounties.onlyPlayer"));
            return true;
        }
        Player player = ((Player)sender).getPlayer();
        if (!player.hasPermission(LanguageConfig.getMessages("command.bountiesAdmin.permission"))) {
            player.sendMessage(LanguageConfig.getMessages("command.falsePermission"));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(LanguageConfig.getMessages("command.bountiesAdmin.info1"));
            player.sendMessage(LanguageConfig.getMessages("command.bountiesAdmin.info2"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reloadConfig")) {
            LanguageConfig.load();
            player.sendMessage(LanguageConfig.getMessages("command.bountiesAdmin.reloadSuccess"));
            return true;
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("removeBounty")) {
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(LanguageConfig.getMessages("command.bountiesAdmin.playerOffline").replace("%targetName%", args[1]));
                return true;
            }
            if (!BountyManager.hasBounty((OfflinePlayer)target)) {
                player.sendMessage(LanguageConfig.getMessages("command.bountiesAdmin.noBounty").replace("%targetName%", args[1]));
                return true;
            }
            BountyManager.removeBounty(player, target);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String alias, String[] args) {
        Player player = (Player)commandSender;
        ArrayList<String> list = new ArrayList<String>();
        if (!player.hasPermission(LanguageConfig.getMessages("command.bountiesAdmin.permission"))) {
            return list;
        }
        if (args.length == 0) {
            return list;
        }
        if (args.length == 1) {
            list.add("removeBounty");
            list.add("reloadConfig");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("removeBounty")) {
            Bukkit.getOnlinePlayers().forEach(player1 -> list.add(player1.getName()));
        }
        ArrayList<String> completer = new ArrayList<String>();
        String arg = args[args.length - 1].toLowerCase();
        for (String s : list) {
            String s1 = s.toLowerCase();
            if (!s1.startsWith(arg)) continue;
            completer.add(s);
        }
        return completer;
    }
}

