/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.inventorys.list;

import de.bitcoinclient.bountys.utils.builders.ItemBuilder;
import de.bitcoinclient.bountys.utils.config.LanguageConfig;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class IPlayer {
    private final UUID playerUUID;
    private final String playerName;
    private boolean online;
    private boolean hasBounty;
    private double bounty;

    public IPlayer(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.online = false;
        this.hasBounty = false;
        this.bounty = 0.0;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setHasBounty(boolean hasBounty) {
        this.hasBounty = hasBounty;
    }

    public boolean isHasBounty() {
        return this.hasBounty;
    }

    public void setBounty(double bounty) {
        this.bounty = bounty;
    }

    public double getBounty() {
        return this.bounty;
    }

    public ItemStack toItem() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.PLAYER_HEAD);
        itemBuilder.setSkullOwner(this.getPlayerUUID());
        itemBuilder.setName("\u00a77" + this.getPlayerName());
        itemBuilder.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        itemBuilder.addLoreLine(" ");
        itemBuilder.addLoreLine(LanguageConfig.getMessages("player.online") + (this.isOnline() ? "\u00a7a\u2714" : "\u00a7c\u2718"));
        itemBuilder.addLoreLine(LanguageConfig.getMessages("player.hasBounty") + (this.isHasBounty() ? "\u00a7a\u2714" : "\u00a7c\u2718"));
        if (this.isHasBounty()) {
            itemBuilder.addLoreLine(LanguageConfig.getMessages("player.bountyAmount") + this.getBounty() + LanguageConfig.getMessages("system.currency"));
        }
        itemBuilder.addLoreLine(LanguageConfig.getMessages("player.loreInfo"));
        itemBuilder.setLocalizedName("bounty_players_select#" + String.valueOf(this.getPlayerUUID()));
        itemBuilder.addLoreLine(" ");
        return itemBuilder.toItemStack();
    }
}

