/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.inventorys.list;

import de.bitcoinclient.bountys.Bountys;
import de.bitcoinclient.bountys.inventorys.list.IPlayer;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayersCache {
    public static HashMap<UUID, IPlayer> players = new HashMap();
    public static TreeMap<String, IPlayer> sortedNames = new TreeMap();

    public static void load() {
        players.clear();
        sortedNames.clear();
        Bukkit.getOnlinePlayers().forEach(player -> {
            IPlayer iPlayer = new IPlayer(player.getUniqueId(), player.getName());
            iPlayer.setOnline(true);
            players.put(player.getUniqueId(), iPlayer);
            sortedNames.put(iPlayer.getPlayerName(), iPlayer);
            if (Bountys.getBountys().hasInConfig(player.getUniqueId().toString())) {
                PlayersCache.updateBounty(player, true);
            }
        });
    }

    public static void updateOnline(Player player, boolean isOnline) {
        IPlayer iPlayer = !sortedNames.containsKey(player.getName()) ? new IPlayer(player.getUniqueId(), player.getName()) : sortedNames.get(player.getName());
        iPlayer.setOnline(isOnline);
        sortedNames.remove(player.getName());
        players.remove(player.getUniqueId());
        sortedNames.put(player.getName(), iPlayer);
        players.put(player.getUniqueId(), iPlayer);
    }

    public static void removePlayer(Player player) {
        sortedNames.remove(player.getName());
        players.remove(player.getUniqueId());
    }

    public static void updateBounty(Player player, boolean hasBounty) {
        IPlayer iPlayer = !sortedNames.containsKey(player.getName()) ? new IPlayer(player.getUniqueId(), player.getName()) : sortedNames.get(player.getName());
        iPlayer.setHasBounty(hasBounty);
        iPlayer.setBounty(Bountys.getBountys().getValueAsDouble(player.getUniqueId().toString()));
        sortedNames.remove(player.getName());
        players.remove(player.getUniqueId());
        sortedNames.put(player.getName(), iPlayer);
        players.put(player.getUniqueId(), iPlayer);
    }
}

