/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.inventorys.list;

import de.bitcoinclient.bountys.Bountys;
import de.bitcoinclient.bountys.inventorys.AddBountyInventory;
import de.bitcoinclient.bountys.inventorys.list.Filter;
import de.bitcoinclient.bountys.inventorys.list.IPlayer;
import de.bitcoinclient.bountys.inventorys.list.PlayersCache;
import de.bitcoinclient.bountys.utils.builders.ItemBuilder;
import de.bitcoinclient.bountys.utils.config.LanguageConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class PlayersInventory
implements Listener {
    public static HashMap<UUID, Filter> playersFilter = new HashMap();
    public static HashMap<UUID, Inventory> playersInventory = new HashMap();
    public static HashMap<UUID, Integer> page = new HashMap();

    public static void createInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)LanguageConfig.getMessages("gui.bounties.title"));
        playersFilter.remove(player.getUniqueId());
        playersFilter.put(player.getUniqueId(), Filter.ALPHABET);
        page.remove(player.getUniqueId());
        page.put(player.getUniqueId(), 0);
        inventory = PlayersInventory.loadTaskBar(inventory, Filter.ALPHABET);
        inventory = PlayersInventory.loadInventory(inventory, Filter.ALPHABET, 0);
        player.openInventory(inventory);
        playersInventory.remove(player.getUniqueId());
        playersInventory.put(player.getUniqueId(), inventory);
    }

    public static void createInventory(Player player, Filter filter, int invPage) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)LanguageConfig.getMessages("gui.bounties.title"));
        playersFilter.remove(player.getUniqueId());
        playersFilter.put(player.getUniqueId(), filter);
        page.remove(player.getUniqueId());
        page.put(player.getUniqueId(), invPage);
        inventory = PlayersInventory.loadTaskBar(inventory, filter);
        inventory = PlayersInventory.loadInventory(inventory, filter, invPage);
        player.openInventory(inventory);
        playersInventory.remove(player.getUniqueId());
        playersInventory.put(player.getUniqueId(), inventory);
    }

    @EventHandler
    public void onInteract(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!playersInventory.containsKey(player.getUniqueId())) {
            return;
        }
        ClickType clickType = event.getClick();
        ItemStack item = event.getCurrentItem();
        if (event.getInventory() == playersInventory.get(player.getUniqueId())) {
            if (item == null) {
                return;
            }
            event.setCancelled(true);
            if (!item.hasItemMeta() && !item.getItemMeta().hasLocalizedName()) {
                return;
            }
            String localizedName = item.getItemMeta().getLocalizedName();
            if (localizedName.startsWith("bounty_players_select#")) {
                UUID uuid = UUID.fromString(localizedName.split("#")[1]);
                if (uuid.toString().equalsIgnoreCase(player.getUniqueId().toString())) {
                    player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.1f);
                }
                if (Bountys.getEcon().has((OfflinePlayer)player, 10.0)) {
                    AddBountyInventory.createInventory(uuid, 10.0, player);
                } else {
                    player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.1f);
                }
            }
            if (localizedName.equalsIgnoreCase("players_forward")) {
                int inventoryPage = page.get(player.getUniqueId());
                if (45 * inventoryPage > PlayersCache.players.size()) {
                    player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.1f);
                    return;
                }
                PlayersInventory.createInventory(player, playersFilter.get(player.getUniqueId()), inventoryPage + 1);
            }
            if (localizedName.equalsIgnoreCase("players_back")) {
                if (page.get(player.getUniqueId()) == 0) {
                    player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.1f);
                    return;
                }
                PlayersInventory.createInventory(player, playersFilter.get(player.getUniqueId()), page.get(player.getUniqueId()) - 1);
            }
            if (localizedName.equalsIgnoreCase("players_filter")) {
                Filter filter = playersFilter.get(player.getUniqueId());
                int up = 0;
                for (int i = 0; i < Arrays.stream(Filter.values()).toList().size(); ++i) {
                    if (filter != Arrays.stream(Filter.values()).toList().get(i)) continue;
                    up = i + 1;
                    break;
                }
                if (up == Filter.values().length) {
                    up = 0;
                }
                playersFilter.replace(player.getUniqueId(), Arrays.stream(Filter.values()).toList().get(up));
                PlayersInventory.createInventory(player, playersFilter.get(player.getUniqueId()), 0);
                return;
            }
        }
    }

    private static Inventory loadInventory(Inventory inventory, Filter filter, int page) {
        AtomicInteger temp = new AtomicInteger(0);
        if (filter == Filter.ALPHABET) {
            if (page == 0) {
                PlayersCache.sortedNames.forEach((s, iPlayer) -> {
                    if (temp.get() > 45) {
                        return;
                    }
                    inventory.setItem(temp.get(), iPlayer.toItem());
                    temp.set(temp.get() + 1);
                });
            } else {
                PlayersCache.sortedNames.forEach((s, iPlayer) -> {
                    temp.set(temp.get() + 1);
                    if (temp.get() < 45 * page) {
                        return;
                    }
                    if (temp.get() > 90 * page) {
                        return;
                    }
                    inventory.setItem(temp.get() - 45 * page, iPlayer.toItem());
                });
            }
        }
        if (filter == Filter.BOUNTYAMOUNT) {
            HashMap players = new HashMap();
            PlayersCache.sortedNames.forEach((s, iPlayer) -> players.put(iPlayer.getBounty() + s, iPlayer));
            TreeMap<String, IPlayer> sortedPlayers = new TreeMap<String, IPlayer>(players);
            if (page == 0) {
                sortedPlayers.forEach((s, iPlayer) -> {
                    if (temp.get() > 45) {
                        return;
                    }
                    inventory.setItem(temp.get(), iPlayer.toItem());
                    temp.set(temp.get() + 1);
                });
            } else {
                sortedPlayers.forEach((s, iPlayer) -> {
                    temp.set(temp.get() + 1);
                    if (temp.get() < 45 * page) {
                        return;
                    }
                    if (temp.get() > 90 * page) {
                        return;
                    }
                    inventory.setItem(temp.get() - 45 * page, iPlayer.toItem());
                });
            }
        }
        if (filter == Filter.BOUNTY) {
            ArrayList use = new ArrayList();
            PlayersCache.players.forEach((uuid, iPlayer) -> {
                if (iPlayer.isHasBounty()) {
                    use.add(iPlayer.getPlayerName());
                }
            });
            Collections.sort(use);
            if (page == 0) {
                for (int i = 0; i < use.size(); ++i) {
                    if (temp.get() > 45) continue;
                    temp.set(temp.get() + 1);
                    inventory.setItem(i, PlayersCache.sortedNames.get(use.get(i)).toItem());
                }
                if (temp.get() < 45) {
                    PlayersCache.sortedNames.forEach((s, iPlayer) -> {
                        if (temp.get() > 45) {
                            return;
                        }
                        if (use.contains(s)) {
                            return;
                        }
                        inventory.setItem(temp.get(), iPlayer.toItem());
                        temp.set(temp.get() + 1);
                    });
                }
            } else {
                for (int i = 0; i < use.size(); ++i) {
                    temp.set(temp.get() + 1);
                    if (temp.get() < 45 * page || temp.get() > 90 * page) continue;
                    inventory.setItem(temp.get() - 45 * page, PlayersCache.sortedNames.get(use.get(i)).toItem());
                }
                if (temp.get() < 90 * page) {
                    PlayersCache.sortedNames.forEach((s, iPlayer) -> {
                        if (temp.get() > 90 * page) {
                            return;
                        }
                        if (use.contains(s)) {
                            return;
                        }
                        inventory.setItem(temp.get(), iPlayer.toItem());
                        temp.set(temp.get() + 1);
                    });
                }
            }
        }
        temp.set(0);
        return inventory;
    }

    private static Inventory loadTaskBar(Inventory inventory, Filter filter) {
        for (int i = 0; i < 8; ++i) {
            inventory.setItem(i + 45, new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName(" ").addItemFlags(ItemFlag.HIDE_ATTRIBUTES).toItemStack());
        }
        inventory.setItem(45, new ItemBuilder(Material.PLAYER_HEAD).setName("\u00a77<-").setSkullOwnerValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTE0NTljZmM0NGNjNTFkZGYyNzk4ODU5NmQyZGU4YWM4NTU2ZTkzZDc5NDYyMTljZjY0YzkwYzhjMDVmY2EifX19").setLocalizedName("players_back").addItemFlags(ItemFlag.HIDE_ATTRIBUTES).toItemStack());
        ItemBuilder itemBuilder = new ItemBuilder(Material.OAK_SIGN).setName(LanguageConfig.getMessages("gui.filter.item.name")).setLocalizedName("players_filter").addLoreLine(" ").addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        for (Filter value : Filter.values()) {
            if (value == filter) {
                itemBuilder.addLoreLine("\u00a7a> \u00a7r" + value.getFilterName());
                continue;
            }
            itemBuilder.addLoreLine("\u00a77> \u00a7r" + value.getFilterName());
        }
        itemBuilder.addLoreLine(" ");
        itemBuilder.addLoreLine(LanguageConfig.getMessages("gui.filter.item.lore"));
        itemBuilder.addLoreLine(" ");
        inventory.setItem(49, itemBuilder.toItemStack());
        inventory.setItem(53, new ItemBuilder(Material.PLAYER_HEAD).setName("\u00a77->").setSkullOwnerValue("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjNmYWJjMzg5MWM5NjJjOTEzOTU5ZDY1YmU5MGRhYTVkZTEyMTFmYTQwODdkYWUzODZmZjRlZDQyNDhmIn19fQ==").setLocalizedName("players_forward").addItemFlags(ItemFlag.HIDE_ATTRIBUTES).toItemStack());
        return inventory;
    }
}

