/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.utils.builders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private final JsonObject object;
    private final File config;

    public ConfigManager(String path, String fileName) throws IOException {
        if (!new File(new File(" ").getPath().replace(" ", "") + path).exists()) {
            new File(new File(" ").getPath().replace(" ", "") + path).mkdirs();
        }
        this.config = new File(new File(" ").getPath().replace(" ", "") + path, fileName + ".json");
        if (!this.config.exists()) {
            FileWriter writer = new FileWriter(this.config);
            writer.write("{}");
            writer.flush();
            writer.close();
        }
        this.object = new JsonParser().parse((Reader)new FileReader(this.config)).getAsJsonObject();
    }

    public ConfigManager(String fileName) throws IOException {
        if (!new File(new File(" ").getPath().replace(" ", "") + "plugins").exists()) {
            new File(new File(" ").getPath().replace(" ", "") + "plugins").mkdirs();
        }
        this.config = new File(new File(" ").getPath().replace(" ", "") + "plugins", fileName + ".json");
        if (!this.config.exists()) {
            FileWriter writer = new FileWriter(this.config);
            writer.write("{}");
            writer.flush();
            writer.close();
        }
        this.object = new JsonParser().parse((Reader)new FileReader(this.config)).getAsJsonObject();
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(this.config);
            writer.write(this.object.toString().replace("{", "{\n").replace("}", "\n}").replace(",", ",\n"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add2Config(String id, Object value, boolean isForced) {
        if (isForced) {
            if (value instanceof String) {
                this.object.addProperty(id, (String)value);
            }
            if (value instanceof Integer) {
                this.object.addProperty(id, (Number)((Integer)value));
            }
            if (value instanceof Boolean) {
                this.object.addProperty(id, Boolean.valueOf((Boolean)value));
            }
            if (value instanceof Double) {
                this.object.addProperty(id, (Number)((Double)value));
            }
            if (value == null) {
                this.object.remove(id);
            }
        } else if (!this.object.has(id)) {
            if (value instanceof String) {
                this.object.addProperty(id, (String)value);
            }
            if (value instanceof Integer) {
                this.object.addProperty(id, (Number)((Integer)value));
            }
            if (value instanceof Boolean) {
                this.object.addProperty(id, Boolean.valueOf((Boolean)value));
            }
            if (value instanceof Double) {
                this.object.addProperty(id, (Number)((Double)value));
            }
            if (value == null) {
                this.object.remove(id);
            }
        }
        this.save();
    }

    public String getValueAsString(String id) {
        if (this.object.has(id)) {
            return this.object.get(id).getAsString();
        }
        return "";
    }

    public int getValueAsInt(String id) {
        if (this.object.has(id)) {
            return this.object.get(id).getAsInt();
        }
        return -1;
    }

    public boolean getValueAsBoolean(String id) {
        if (this.object.has(id)) {
            return this.object.get(id).getAsBoolean();
        }
        return false;
    }

    public double getValueAsDouble(String id) {
        if (this.object.has(id)) {
            return this.object.get(id).getAsDouble();
        }
        return -1.0;
    }

    public boolean hasInConfig(String id) {
        return this.object.has(id);
    }

    public JsonObject getObject() {
        return this.object;
    }
}

