/*
 * Decompiled with CFR 0.152.
 */
package de.bitcoinclient.bountys.utils.builders;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ItemBuilder {
    private final ItemStack item;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack item) {
        this.item = item;
    }

    public ItemBuilder(Material material, int amount) {
        this.item = new ItemStack(material, amount);
    }

    public ItemBuilder setName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setDisplayName(name);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setCustomModelData(int data) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(data));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLocalizedName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setItemName(name);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setUnbreakable(unbreakable);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int level) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addEnchant(enchantment, level, true);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int level) {
        this.item.addUnsafeEnchantment(enchantment, level);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> enchantments) {
        this.item.addEnchantments(enchantments);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.item.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setLore(String ... lines) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLore(Arrays.asList(lines));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLore(List<String> lines) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLore(lines);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(String line) {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList lores = itemMeta.getLore() == null ? new ArrayList() : new ArrayList(itemMeta.getLore());
        if (!lores.contains(line)) {
            return this;
        }
        lores.remove(line);
        itemMeta.setLore(lores);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(int index) {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList lores = itemMeta.getLore() == null ? new ArrayList() : new ArrayList(itemMeta.getLore());
        if (index < 0 || index > lores.size()) {
            return this;
        }
        lores.remove(index);
        itemMeta.setLore(lores);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String line) {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList<String> lores = itemMeta.getLore() == null ? new ArrayList<String>() : new ArrayList(itemMeta.getLore());
        lores.add(line);
        itemMeta.setLore(lores);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLines(String ... lines) {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList<String> lores = itemMeta.getLore() == null ? new ArrayList<String>() : new ArrayList(itemMeta.getLore());
        lores.addAll(Arrays.asList(lines));
        itemMeta.setLore(lores);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLoreLine(String line, int position) {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList<String> lores = itemMeta.getLore() == null ? new ArrayList<String>() : new ArrayList(itemMeta.getLore());
        lores.set(position, line);
        itemMeta.setLore(lores);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addItemFlags(flags);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    @Deprecated
    public ItemBuilder setSkullOwner(String owner) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)owner));
        this.item.setItemMeta((ItemMeta)skullMeta);
        return this;
    }

    public ItemBuilder setSkullOwner(UUID uuid) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
        this.item.setItemMeta((ItemMeta)skullMeta);
        return this;
    }

    public ItemBuilder setSkullOwnerValue(String value) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(itemMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException error) {
            error.printStackTrace();
        }
        this.item.setItemMeta((ItemMeta)skullMeta);
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return this;
        }
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
        leatherArmorMeta.setColor(color);
        this.item.setItemMeta((ItemMeta)leatherArmorMeta);
        return this;
    }

    public ItemBuilder setBasePotionData(PotionType potionType) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.setBasePotionType(potionType);
        this.item.setItemMeta((ItemMeta)potionMeta);
        return this;
    }

    public ItemBuilder addCustomPotionEffect(PotionEffect potionEffect) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.addCustomEffect(potionEffect, true);
        this.item.setItemMeta((ItemMeta)potionMeta);
        return this;
    }

    public ItemBuilder setPotionColor(Color color) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.setColor(color);
        this.item.setItemMeta((ItemMeta)potionMeta);
        return this;
    }

    public ItemStack toItemStack() {
        return this.item;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ItemMeta getItemMeta() {
        if (this.item.getItemMeta() == null) {
            this.item.setItemMeta(Bukkit.getItemFactory().getItemMeta(this.item.getType()));
        }
        return this.item.getItemMeta();
    }
}

