/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.pcal.mobfilter.Rule;
import org.apache.logging.log4j.Level;

class Config {
    private final List<Rule> rules;
    private final Level logLevel;

    public static Builder builder() {
        return new Builder();
    }

    Config(List<Rule> rules, Level logLevel) {
        this.rules = Objects.requireNonNull(rules);
        this.logLevel = Objects.requireNonNull(logLevel);
    }

    List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public static class Builder {
        private final ImmutableList.Builder<Rule> rules = ImmutableList.builder();
        private Level logLevel = Level.INFO;

        void addRule(Rule rule) {
            this.rules.add((Object)Objects.requireNonNull(rule));
        }

        void setLogLevel(Level logLevel) {
            this.logLevel = logLevel;
        }

        Config build() {
            return new Config((List<Rule>)this.rules.build(), this.logLevel);
        }
    }
}

