/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

interface Matcher<T> {
    public boolean isMatch(T var1);

    public static <T> Matcher<T> of(final T[] matchItems) {
        int HASH_CUTOFF = 3;
        if (matchItems.length == 0) {
            return new Matcher<T>(){

                @Override
                public boolean isMatch(T s) {
                    return false;
                }

                public String toString() {
                    return "[]";
                }
            };
        }
        if (matchItems.length == 1) {
            return new Matcher<T>(){

                @Override
                public boolean isMatch(T s) {
                    return s != null && s.equals(matchItems[0]);
                }

                public String toString() {
                    return "[" + String.valueOf(matchItems[0]) + "]";
                }
            };
        }
        if (matchItems.length <= 3) {
            return new Matcher<T>(){

                @Override
                public boolean isMatch(T s) {
                    if (s == null) {
                        return false;
                    }
                    for (Object a : matchItems) {
                        if (!Objects.equals(a, s)) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return Arrays.toString(matchItems);
                }
            };
        }
        final HashSet<T> set = new HashSet<T>(Arrays.asList(matchItems));
        return new Matcher<T>(){

            @Override
            public boolean isMatch(T s) {
                if (s == null) {
                    return false;
                }
                return set.contains(s);
            }

            public String toString() {
                return Arrays.toString(matchItems);
            }
        };
    }
}

