/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import java.util.List;
import java.util.Objects;
import net.pcal.mobfilter.RuleCheck;
import net.pcal.mobfilter.SpawnAttempt;

record Rule(String name, List<RuleCheck> checks, RuleAction action) {
    Rule {
        Objects.requireNonNull(name);
        Objects.requireNonNull(checks);
        Objects.requireNonNull(action);
    }

    public Boolean isSpawnAllowed(SpawnAttempt att) {
        for (RuleCheck check : this.checks) {
            if (check.isMatch(att)) continue;
            return null;
        }
        return this.action == RuleAction.ALLOW_SPAWN;
    }

    public String getName() {
        return this.name;
    }

    public static enum RuleAction {
        ALLOW_SPAWN,
        DISALLOW_SPAWN;

    }
}

