/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.pcal.mobfilter.MFConfig;
import net.pcal.mobfilter.Rule;
import net.pcal.mobfilter.RuleList;
import net.pcal.mobfilter.SimpleConfigLoader;
import net.pcal.mobfilter.SpawnAttempt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public final class MFService {
    private final Logger logger = LogManager.getLogger(MFService.class);
    private RuleList config;
    private Level logLevel = Level.INFO;
    private String configError = null;
    private final File jsonConfigFile = Paths.get("config", "mobfilter.json5").toFile();
    private final File simpleConfigFile = Paths.get("config", "mobfilter.simple").toFile();
    private final ThreadLocal<class_3730> spawnReason = new ThreadLocal();

    public static MFService get() {
        return SingletonHolder.INSTANCE;
    }

    public void notifyEntityCreate(class_1937 level, class_3730 reason, class_1297 entity) {
        if (level.method_8608()) {
            return;
        }
        if (!(entity instanceof class_1308)) {
            return;
        }
        if (reason == null) {
            this.logger.debug(() -> "[MobFilter] Ignoring attempt to set null spawnReason for " + String.valueOf(entity));
            return;
        }
        if (this.spawnReason.get() != null && this.spawnReason.get() != reason) {
            this.logger.trace(() -> "[MobFilter] Unexpectedly changing existing spawnReason for " + String.valueOf(entity) + " from " + String.valueOf(this.spawnReason.get()) + " to " + String.valueOf(reason));
        }
        this.spawnReason.set(reason);
    }

    public boolean isSpawnAllowed(class_3218 serverLevel, class_1297 entity, MinecraftThreadType threadTypeGuess) {
        if (this.config == null) {
            return true;
        }
        if (serverLevel.method_8608()) {
            return true;
        }
        if (!(entity instanceof class_1308)) {
            return true;
        }
        class_3730 reason = this.spawnReason.get();
        if (reason == null) {
            this.logger.debug(() -> "[MobFilter] No spawnReason was set for " + String.valueOf(entity.method_5864()));
        } else {
            this.spawnReason.remove();
        }
        class_1299 entityType = entity.method_5864();
        SpawnAttempt att = this.determineThreadType(threadTypeGuess) == MinecraftThreadType.SERVER ? new SpawnAttempt.MainThreadSpawnAttempt(serverLevel, reason, entityType.method_5891(), entityType, entity.method_24515(), this.logger) : new SpawnAttempt.WorldgenThreadSpawnAttempt(reason, entityType.method_5891(), entityType, entity.method_24515(), this.logger);
        boolean allowSpawn = MFService.isSpawnAllowed(att, this.config.getRules());
        if (this.logLevel.isLessSpecificThan(Level.DEBUG)) {
            if (allowSpawn) {
                this.logger.debug(() -> "[MobFilter] ALLOW " + String.valueOf(att.getSpawnReason()) + " " + String.valueOf(att.getEntityId()) + " at [" + att.getBlockPos().method_23854() + "]");
            } else {
                this.logger.debug(() -> "[MobFilter] DISALLOW " + String.valueOf(att.getSpawnReason()) + " " + String.valueOf(att.getEntityId()) + " at [" + att.getBlockPos().method_23854() + "]");
            }
        }
        return allowSpawn;
    }

    public void ensureConfigFilesExist() {
        InputStream in;
        if (!this.simpleConfigFile.exists()) {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream("default-mobfilter.simple");
                try {
                    if (in == null) {
                        throw new IllegalStateException("unable to load default-mobfilter.simple");
                    }
                    this.simpleConfigFile.getParentFile().mkdirs();
                    Files.copy(in, this.simpleConfigFile.toPath(), new CopyOption[0]);
                    this.logger.info(() -> "[MobFilter] Wrote default config file to " + this.simpleConfigFile.getAbsolutePath());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                this.logger.catching(Level.ERROR, (Throwable)e);
                this.logger.error(() -> "[MobFilter] Failed to write default configuration file to " + this.simpleConfigFile.getAbsolutePath());
            }
        }
        if (!this.jsonConfigFile.exists()) {
            try {
                in = this.getClass().getClassLoader().getResourceAsStream("default-mobfilter.json5");
                try {
                    if (in == null) {
                        throw new IllegalStateException("unable to load default-mobfilter.json5");
                    }
                    this.jsonConfigFile.getParentFile().mkdirs();
                    Files.copy(in, this.jsonConfigFile.toPath(), new CopyOption[0]);
                    this.logger.info(() -> "[MobFilter] Wrote default config file to " + this.jsonConfigFile.getAbsolutePath());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e) {
                this.logger.catching(Level.ERROR, (Throwable)e);
                this.logger.error(() -> "[MobFilter] Failed to write default configuration file to " + this.jsonConfigFile.getAbsolutePath());
            }
        }
    }

    boolean getDefaultRuleCheckResult() {
        return true;
    }

    String getConfigError() {
        return this.configError;
    }

    void loadConfig() {
        FileInputStream in;
        this.configError = null;
        this.config = null;
        this.setLogLevel(Level.INFO);
        this.ensureConfigFilesExist();
        RuleList.Builder configBuilder = RuleList.builder();
        this.logger.info(() -> "[MobFilter] Loading configuration");
        try {
            this.logger.debug(() -> "[MobFilter] Loading config from " + this.jsonConfigFile.getAbsolutePath());
            in = new FileInputStream(this.jsonConfigFile);
            try {
                MFConfig.loadRules(in, configBuilder);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            this.configError = e.getMessage();
            this.logger.catching(Level.ERROR, (Throwable)e);
            this.logger.error(() -> "[MobFilter] Failed to load " + this.jsonConfigFile.getAbsolutePath());
        }
        try {
            this.logger.debug(() -> "[MobFilter] Loading config from " + this.simpleConfigFile.getAbsolutePath());
            in = new FileInputStream(this.simpleConfigFile);
            try {
                SimpleConfigLoader.loadRules(in, configBuilder);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            this.configError = e.getMessage();
            this.logger.catching(Level.ERROR, (Throwable)e);
            this.logger.error(() -> "[MobFilter] Failed to load config from " + this.simpleConfigFile.getAbsolutePath());
        }
        this.config = configBuilder.build();
        if (this.config.getLogLevel() != null) {
            this.setLogLevel(this.config.getLogLevel());
        }
        this.logger.info(() -> "[MobFilter] Log level is " + String.valueOf(this.logger.getLevel()));
        if (this.config.getRules().isEmpty()) {
            this.logger.warn("[MobFilter] No rules configured");
        } else {
            this.logger.info(() -> "[MobFilter] " + this.config.getRules().size() + " rule(s) loaded:");
            for (Rule rule : this.config.getRules()) {
                this.logger.info(() -> "[MobFilter] - " + rule.toString());
            }
        }
    }

    private static boolean isSpawnAllowed(SpawnAttempt att, List<Rule> rules) {
        att.getLogger().trace(() -> "[MobFilter] IS_SPAWN_ALLOWED " + String.valueOf(att));
        for (Rule rule : rules) {
            att.getLogger().trace(() -> "[MobFilter]   RULE '" + rule.getName() + "'");
            Boolean isSpawnAllowed = rule.isSpawnAllowed(att);
            if (isSpawnAllowed == null) continue;
            att.getLogger().trace(() -> "[MobFilter]   RETURN " + isSpawnAllowed);
            return isSpawnAllowed;
        }
        att.getLogger().trace(() -> "[MobFilter]   RETURN true (no rules matched)");
        return true;
    }

    private MinecraftThreadType determineThreadType(MinecraftThreadType threadTypeGuess) {
        String threadName = Thread.currentThread().getName();
        boolean threadNameLooksLikeWorldgen = threadName.contains("Worker");
        if (threadTypeGuess == MinecraftThreadType.WORLDGEN) {
            if (!threadNameLooksLikeWorldgen) {
                this.logger.debug(() -> "[MobFilter] Thread guess is " + String.valueOf((Object)MinecraftThreadType.WORLDGEN) + " but the name is " + threadName);
            }
            return MinecraftThreadType.WORLDGEN;
        }
        if (threadNameLooksLikeWorldgen) {
            this.logger.debug(() -> "[MobFilter] Overriding guessed MAIN thread to WORLDGEN because current thread name is " + threadName);
            return MinecraftThreadType.WORLDGEN;
        }
        return MinecraftThreadType.SERVER;
    }

    private void setLogLevel(Level logLevel) {
        Configurator.setLevel((String)MFService.class.getName(), (Level)logLevel);
        this.logLevel = logLevel;
    }

    private static final class SingletonHolder {
        private static final MFService INSTANCE = new MFService();

        private SingletonHolder() {
        }
    }

    public static enum MinecraftThreadType {
        SERVER,
        WORLDGEN;

    }
}

