/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import java.util.EnumSet;
import net.minecraft.class_1311;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.pcal.mobfilter.IdMatcher;
import net.pcal.mobfilter.MFService;
import net.pcal.mobfilter.Matcher;
import net.pcal.mobfilter.SpawnAttempt;

interface RuleCheck {
    public boolean isMatch(SpawnAttempt var1);

    public record WorldNameCheck(Matcher<String> worldNames) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            String worldName = att.getWorldName();
            if (worldName == null) {
                att.getLogger().debug(() -> "[MobFilter] WorldNameCheck: world name could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.worldNames.isMatch(worldName);
            }
            att.getLogger().trace(() -> "[MobFilter] WorldNameCheck: " + worldName + " in " + String.valueOf(this.worldNames) + " " + isMatch);
            return isMatch;
        }
    }

    public record RandomCheck(double odds) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            double r = Math.random();
            boolean isMatch = r < this.odds;
            att.getLogger().trace(() -> "[MobFilter] RadomCheck: " + r + " < " + this.odds + " " + isMatch);
            return isMatch;
        }
    }

    public record TimeOfDayCheck(long min, long max) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            Long val;
            boolean isMatch;
            Long dayTime = att.getDayTime();
            if (dayTime == null) {
                att.getLogger().debug(() -> "[MobFilter] TimeOfDayCheck: day time could not be determined, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
                val = null;
            } else {
                long TICKS_PER_DAY = 24000L;
                val = dayTime % 24000L;
                isMatch = this.min <= val && val <= this.max;
            }
            att.getLogger().trace(() -> "[MobFilter] TimeOfDayCheck: " + this.min + " <= " + val + " <= " + this.max + " " + isMatch);
            return isMatch;
        }
    }

    public record WeatherCheck(Matcher<WeatherType> matcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            WeatherType weather = WeatherCheck.getWeatherType(att);
            if (weather == null) {
                att.getLogger().debug(() -> "[MobFilter] WeatherCheck: weather could not be determined, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.matcher.isMatch(weather);
            }
            att.getLogger().trace(() -> "[MobFilter] WeatherCheck: " + String.valueOf(this.matcher) + " at " + String.valueOf((Object)weather) + ": " + isMatch);
            return isMatch;
        }

        private static WeatherType getWeatherType(SpawnAttempt att) {
            class_2338 blockpos = att.getBlockPos();
            if (blockpos == null) {
                att.getLogger().debug(() -> "[MobFilter] WeatherCheck: no block position");
                return null;
            }
            Boolean isThundering = att.isThundering();
            if (isThundering == null) {
                att.getLogger().debug(() -> "[MobFilter] WeatherCheck: isThundering could not be determined");
                return null;
            }
            if (isThundering.booleanValue()) {
                return WeatherType.THUNDER;
            }
            Boolean isRaining = att.isRainingAt(att.getBlockPos());
            if (isRaining == null) {
                att.getLogger().debug(() -> "[MobFilter] WeatherCheck: isRaining could not be determined");
                return null;
            }
            if (isRaining.booleanValue()) {
                class_1959 biome = att.getBiome(att.getBlockPos());
                if (biome == null) {
                    att.getLogger().debug(() -> "[MobFilter] WeatherCheck: biome could not be determined");
                    return null;
                }
                if (biome.method_48163() && biome.method_33599(att.getBlockPos(), att.getBlockPos().method_10264())) {
                    return WeatherType.SNOW;
                }
                return WeatherType.RAIN;
            }
            return WeatherType.CLEAR;
        }
    }

    public static enum WeatherType {
        CLEAR,
        RAIN,
        THUNDER,
        SNOW;

    }

    public record MoonPhaseCheck(Matcher<Integer> matcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            Integer val = att.getMoonPhase();
            if (val == null) {
                att.getLogger().debug(() -> "[MobFilter] MoonPhaseCheck: moon phase could not be determined, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.matcher.isMatch(val);
            }
            att.getLogger().trace(() -> "[MobFilter] MoonPhaseCheck: " + String.valueOf(this.matcher) + " contains " + val + " " + isMatch);
            return isMatch;
        }
    }

    public record SkylightLevelCheck(int min, int max) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            Integer val = att.getBrightness(class_1944.field_9284, att.getBlockPos());
            if (val == null) {
                att.getLogger().debug(() -> "[MobFilter] SkylightLevelCheck: skylight level could not be determined, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.min <= val && val <= this.max;
            }
            att.getLogger().trace(() -> "[MobFilter] SkylightLevelCheck: " + this.min + " <= " + val + " <= " + this.max + " " + isMatch);
            return isMatch;
        }
    }

    public record LightLevelCheck(int min, int max) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            Integer val = att.getMaxLocalRawBrightness(att.getBlockPos());
            if (val == null) {
                att.getLogger().debug(() -> "[MobFilter] LightLevelCheck: light level could not be determined, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.min <= val && val <= this.max;
            }
            att.getLogger().trace(() -> "[MobFilter] LightLevelCheck: " + this.min + " <= " + val + " <= " + this.max + " " + isMatch);
            return isMatch;
        }
    }

    public record BlockPosCheck(class_2350.class_2351 axis, int min, int max) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            Integer val;
            boolean isMatch;
            class_2338 blockPos = att.getBlockPos();
            if (blockPos == null) {
                att.getLogger().debug(() -> "[MobFilter] BlockPosCheck: no block position, assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
                val = null;
            } else {
                val = att.getBlockPos().method_30558(this.axis);
                isMatch = this.min <= val && val <= this.max;
            }
            att.getLogger().trace(() -> "[MobFilter] BlockPosCheck: " + String.valueOf(this.axis) + " " + this.min + " <= " + val + " <= " + this.max + " " + isMatch);
            return isMatch;
        }
    }

    public record BlockIdCheck(IdMatcher blockMatcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            class_2960 blockId = att.getBlockId();
            if (blockId == null) {
                att.getLogger().debug(() -> "[MobFilter] BlockIdCheck: block ID could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.blockMatcher.isMatch(blockId);
            }
            att.getLogger().trace(() -> "[MobFilter] BlockIdCheck: " + String.valueOf(blockId) + " in " + String.valueOf(this.blockMatcher) + " " + isMatch);
            return isMatch;
        }
    }

    public record EntityIdCheck(IdMatcher entityMatcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            class_2960 entityId = att.getEntityId();
            if (entityId == null) {
                att.getLogger().debug(() -> "[MobFilter] EntityIdCheck: entity ID could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.entityMatcher.isMatch(entityId);
            }
            att.getLogger().trace(() -> "[MobFilter] EntityNameCheck: " + String.valueOf(entityId) + " in " + String.valueOf(this.entityMatcher) + " " + isMatch);
            return isMatch;
        }
    }

    public record CategoryCheck(EnumSet<class_1311> categories) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            class_1311 mobCategory = att.getMobCategory();
            if (mobCategory == null) {
                att.getLogger().debug(() -> "[MobFilter] CategoryCheck: category could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.categories.contains(mobCategory);
            }
            att.getLogger().trace(() -> "[MobFilter] CategoryCheck: " + String.valueOf(this.categories) + " " + String.valueOf(mobCategory) + " " + isMatch + " " + isMatch);
            return isMatch;
        }
    }

    public record SpawnReasonCheck(EnumSet<class_3730> reasons) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            boolean isMatch;
            class_3730 spawnReason = att.getSpawnReason();
            if (spawnReason == null) {
                att.getLogger().debug(() -> "[MobFilter] SpawnReasonCheck: reason could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                isMatch = MFService.get().getDefaultRuleCheckResult();
            } else {
                isMatch = this.reasons.contains(spawnReason);
            }
            att.getLogger().trace(() -> "[MobFilter] SpawnReasonCheck: " + String.valueOf(this.reasons) + " " + String.valueOf(spawnReason) + " " + isMatch + " " + isMatch);
            return isMatch;
        }
    }

    public record BiomeCheck(IdMatcher biomeMatcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            class_2960 biomeId = att.getBiomeId();
            if (biomeId == null) {
                att.getLogger().debug(() -> "[MobFilter] BiomeCheck: biome ID could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                return true;
            }
            boolean isMatch = this.biomeMatcher.isMatch(biomeId);
            att.getLogger().trace(() -> "[MobFilter] BiomeCheck " + String.valueOf(biomeId) + " in " + String.valueOf(this.biomeMatcher) + " " + isMatch);
            return isMatch;
        }
    }

    public record DimensionCheck(IdMatcher dimensionMatcher) implements RuleCheck
    {
        @Override
        public boolean isMatch(SpawnAttempt att) {
            class_2960 dimensionId = att.getDimensionId();
            if (dimensionId == null) {
                att.getLogger().debug(() -> "[MobFilter] DimensionCheck: dimension ID could not be determined for " + String.valueOf(att.getEntityType()) + ", assuming match");
                return true;
            }
            boolean isMatch = this.dimensionMatcher.isMatch(dimensionId);
            att.getLogger().trace(() -> "[MobFilter] DimensionCheck " + String.valueOf(dimensionId) + " in " + String.valueOf(this.dimensionMatcher) + " " + isMatch);
            return isMatch;
        }
    }
}

