/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.pcal.mobfilter.IdMatcher;
import net.pcal.mobfilter.Rule;
import net.pcal.mobfilter.RuleCheck;
import net.pcal.mobfilter.RuleList;

class SimpleConfigLoader {
    SimpleConfigLoader() {
    }

    static void loadRules(InputStream in, RuleList.Builder configBuilder) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(in), StandardCharsets.UTF_8));){
            String line;
            int i = 0;
            ArrayList<String> groupIds = null;
            Boolean currentPolarity = null;
            while ((line = reader.readLine()) != null) {
                boolean groupPolarity;
                String idPattern;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (idPattern = (groupPolarity = line.startsWith("!")) ? line.substring(1).trim() : line).isEmpty()) continue;
                if (groupIds == null) {
                    groupIds = new ArrayList<String>();
                }
                if (currentPolarity == null) {
                    currentPolarity = groupPolarity;
                }
                if (currentPolarity != groupPolarity) {
                    if (!groupIds.isEmpty()) {
                        RuleCheck.EntityIdCheck check = new RuleCheck.EntityIdCheck(IdMatcher.of(groupIds.toArray(new String[0])));
                        configBuilder.addRule(new Rule("simple-" + i, (List<RuleCheck>)ImmutableList.of((Object)check), currentPolarity != false ? Rule.RuleAction.ALLOW_SPAWN : Rule.RuleAction.DISALLOW_SPAWN));
                        ++i;
                        groupIds.clear();
                    }
                    currentPolarity = groupPolarity;
                }
                groupIds.add(idPattern);
            }
            if (groupIds != null && !groupIds.isEmpty()) {
                RuleCheck.EntityIdCheck check = new RuleCheck.EntityIdCheck(IdMatcher.of(groupIds.toArray(new String[0])));
                configBuilder.addRule(new Rule("simple-" + i, (List<RuleCheck>)ImmutableList.of((Object)check), currentPolarity != false ? Rule.RuleAction.ALLOW_SPAWN : Rule.RuleAction.DISALLOW_SPAWN));
            }
        }
    }
}

