/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.Strictness;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1267;
import net.minecraft.class_1311;
import net.minecraft.class_2350;
import net.minecraft.class_3730;
import net.pcal.mobfilter.Config;
import net.pcal.mobfilter.IdMatcher;
import net.pcal.mobfilter.Matcher;
import net.pcal.mobfilter.Rule;
import net.pcal.mobfilter.RuleCheck;
import org.apache.logging.log4j.Level;

class JsonConfigLoader {
    JsonConfigLoader() {
    }

    static void loadRules(InputStream in, Config.Builder configBuilder) throws IOException {
        JsonConfiguration fromConfig = JsonConfigLoader.loadFromJson(in);
        if (fromConfig != null && fromConfig.rules != null) {
            JsonConfigLoader.loadRules(fromConfig, configBuilder);
        }
    }

    static void loadRules(JsonConfiguration fromConfig, Config.Builder configBuilder) {
        int i = -1;
        for (JsonRule configRule : fromConfig.rules) {
            int[] range;
            EnumSet<class_3730> enumSet;
            Object ruleName;
            ++i;
            if (configRule == null) continue;
            ImmutableList.Builder checks = ImmutableList.builder();
            Object object = ruleName = configRule.name != null ? configRule.name : "rule" + i;
            if (configRule.what == null) {
                throw new IllegalArgumentException("'what' must be specified on " + (String)ruleName);
            }
            JsonWhen when = configRule.when;
            if (when == null) {
                throw new IllegalArgumentException("'when' must be specified on " + (String)ruleName);
            }
            if (when.spawnReason != null && when.spawnReason.length > 0) {
                enumSet = EnumSet.copyOf(Arrays.asList(when.spawnReason));
                checks.add((Object)new RuleCheck.SpawnReasonCheck(enumSet));
            } else if (when.spawnType != null && when.spawnType.length > 0) {
                enumSet = EnumSet.copyOf(Arrays.asList(when.spawnType));
                checks.add((Object)new RuleCheck.SpawnReasonCheck(enumSet));
            }
            if (when.category != null && when.category.length > 0) {
                enumSet = EnumSet.copyOf(Arrays.asList(when.category));
                checks.add((Object)new RuleCheck.CategoryCheck(enumSet));
            } else if (when.spawnGroup != null && when.spawnGroup.length > 0) {
                enumSet = EnumSet.copyOf(Arrays.asList(when.spawnGroup));
                checks.add((Object)new RuleCheck.CategoryCheck(enumSet));
            }
            if (when.entityId != null) {
                checks.add((Object)new RuleCheck.EntityIdCheck(IdMatcher.of(when.entityId)));
            }
            if (when.worldName != null) {
                checks.add((Object)new RuleCheck.WorldNameCheck(Matcher.of(when.worldName)));
            }
            if (when.dimensionId != null) {
                checks.add((Object)new RuleCheck.DimensionCheck(IdMatcher.of(when.dimensionId)));
            }
            if (when.biomeId != null) {
                checks.add((Object)new RuleCheck.BiomeCheck(IdMatcher.of(when.biomeId)));
            }
            if (when.blockId != null) {
                checks.add((Object)new RuleCheck.BlockIdCheck(IdMatcher.of(when.blockId)));
            }
            if (when.blockX != null) {
                range = JsonConfigLoader.parseRange(when.blockX);
                checks.add((Object)new RuleCheck.BlockPosCheck(class_2350.class_2351.field_11048, range[0], range[1]));
            }
            if (when.blockY != null) {
                range = JsonConfigLoader.parseRange(when.blockY);
                checks.add((Object)new RuleCheck.BlockPosCheck(class_2350.class_2351.field_11052, range[0], range[1]));
            }
            if (when.blockZ != null) {
                range = JsonConfigLoader.parseRange(when.blockZ);
                checks.add((Object)new RuleCheck.BlockPosCheck(class_2350.class_2351.field_11051, range[0], range[1]));
            }
            if (when.timeOfDay != null) {
                range = JsonConfigLoader.parseRange(when.timeOfDay);
                checks.add((Object)new RuleCheck.TimeOfDayCheck(range[0], range[1]));
            }
            if (when.lightLevel != null) {
                range = JsonConfigLoader.parseRange(when.lightLevel);
                checks.add((Object)new RuleCheck.LightLevelCheck(range[0], range[1]));
            }
            if (when.skylightLevel != null) {
                range = JsonConfigLoader.parseRange(when.skylightLevel);
                checks.add((Object)new RuleCheck.SkylightLevelCheck(range[0], range[1]));
            }
            if (when.moonPhase != null) {
                checks.add((Object)new RuleCheck.MoonPhaseCheck(Matcher.of(when.moonPhase)));
            }
            if (when.weather != null) {
                checks.add((Object)new RuleCheck.WeatherCheck(Matcher.of(when.weather)));
            }
            if (when.difficulty != null) {
                checks.add((Object)new RuleCheck.DifficultyCheck(Matcher.of(when.difficulty)));
            }
            if (when.random != null) {
                checks.add((Object)new RuleCheck.RandomCheck(when.random));
            }
            configBuilder.addRule(new Rule((String)ruleName, (List<RuleCheck>)checks.build(), configRule.what));
        }
        if (fromConfig.logLevel != null) {
            try {
                configBuilder.setLogLevel(Level.getLevel((String)fromConfig.logLevel));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid logLevel value: " + fromConfig.logLevel, e);
            }
        }
    }

    static JsonConfiguration loadFromJson(InputStream in) throws IOException {
        String rawJson = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        Gson gson = new GsonBuilder().setLenient().registerTypeAdapterFactory((TypeAdapterFactory)new ValidatingEnumAdapterFactory()).create();
        class TypoCatchingJsonReader
        extends JsonReader {
            public TypoCatchingJsonReader(StringReader in) {
                super((Reader)in);
                super.setStrictness(Strictness.LENIENT);
            }

            public void skipValue() {
                throw new RuntimeException("Unexpected configuration names at: " + this.toString());
            }

            public String toString() {
                String possiblePrefix;
                String out = super.toString();
                if (out.startsWith(possiblePrefix = ((Object)((Object)this)).getClass().getSimpleName() + " at ")) {
                    out = out.substring(possiblePrefix.length());
                }
                return out;
            }
        }
        return (JsonConfiguration)gson.fromJson((JsonReader)new TypoCatchingJsonReader(new StringReader(rawJson)), TypeToken.get(JsonConfiguration.class));
    }

    private static int[] parseRange(String[] configValues) {
        if (configValues.length != 2) {
            throw new IllegalArgumentException("Invalid number of values in int range: " + Arrays.toString(configValues));
        }
        int[] out = new int[2];
        out[0] = "MIN".equals(configValues[0]) ? Integer.MIN_VALUE : Integer.parseInt(configValues[0]);
        int n = out[1] = "MAX".equals(configValues[1]) ? Integer.MAX_VALUE : Integer.parseInt(configValues[1]);
        if (out[0] > out[1]) {
            throw new IllegalArgumentException("Invalid min/max range: " + Arrays.toString(configValues));
        }
        return out;
    }

    public static class JsonConfiguration {
        public JsonRule[] rules;
        public String logLevel;
    }

    public static class JsonRule {
        public String name;
        public Rule.RuleAction what;
        public JsonWhen when;
    }

    public static class JsonWhen {
        public String[] worldName;
        public String[] dimensionId;
        public String[] entityId;
        public String[] biomeId;
        public class_3730[] spawnReason;
        public class_1311[] category;
        public String[] blockX;
        public String[] blockY;
        public String[] blockZ;
        public String[] blockId;
        public String[] timeOfDay;
        public String[] lightLevel;
        public String[] skylightLevel;
        public Integer[] moonPhase;
        public RuleCheck.WeatherType[] weather;
        public class_1267[] difficulty;
        public Double random;
        @Deprecated
        public class_3730[] spawnType;
        @Deprecated
        public class_1311[] spawnGroup;
    }

    private static class ValidatingEnumAdapterFactory
    implements TypeAdapterFactory {
        private ValidatingEnumAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!type.getRawType().isEnum()) {
                return null;
            }
            final TypeAdapter defaultAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            final Class enumClass = type.getRawType();
            return new TypeAdapter<T>(this){

                public void write(JsonWriter out, T value) throws IOException {
                    defaultAdapter.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    String value = in.nextString();
                    if (Arrays.stream(enumClass.getEnumConstants()).noneMatch(e -> ((Enum)e).name().equals(value))) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Invalid " + enumClass.getSimpleName() + " value '" + value + "' at " + in.toString());
                        msg.append(".  Valid values are: ");
                        boolean isFirst = true;
                        for (Object val : enumClass.getEnumConstants()) {
                            if (isFirst) {
                                isFirst = false;
                            } else {
                                msg.append(", ");
                            }
                            msg.append(val);
                        }
                        throw new JsonParseException(msg.toString());
                    }
                    return defaultAdapter.fromJsonTree((JsonElement)new JsonPrimitive(value));
                }
            };
        }
    }
}

