/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.mobfilter;

import java.util.Objects;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5268;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;

interface SpawnAttempt {
    public class_2960 getEntityId();

    public class_1299<?> getEntityType();

    public String getWorldName();

    public class_2960 getDimensionId();

    public class_2960 getBlockId();

    public class_3730 getSpawnReason();

    public class_1311 getMobCategory();

    public class_2338 getBlockPos();

    public Integer getMoonPhase();

    public Integer getBrightness(class_1944 var1, class_2338 var2);

    public Integer getMaxLocalRawBrightness(class_2338 var1);

    public Boolean isThundering();

    public Boolean isRainingAt(class_2338 var1);

    public class_1267 getDifficulty();

    public class_1959 getBiome(class_2338 var1);

    public class_2960 getBiomeId();

    public Long getDayTime();

    public Logger getLogger();

    public static class WorldgenThreadSpawnAttempt
    implements SpawnAttempt {
        private final class_3730 spawnReason;
        private final class_1311 category;
        private final class_1299<?> entityType;
        private final class_2338 blockPos;
        private final Logger logger;

        WorldgenThreadSpawnAttempt(class_3730 spawnReason, class_1311 category, class_1299<?> entityType, class_2338 blockPos, Logger logger) {
            this.spawnReason = spawnReason;
            this.category = category;
            this.entityType = entityType;
            this.blockPos = blockPos;
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public class_2960 getEntityId() {
            return class_7923.field_41177.method_10221(this.entityType);
        }

        @Override
        public class_1299<?> getEntityType() {
            return this.entityType;
        }

        @Override
        public class_3730 getSpawnReason() {
            return this.spawnReason;
        }

        @Override
        public class_1311 getMobCategory() {
            return this.category;
        }

        @Override
        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        @Override
        public Logger getLogger() {
            return this.logger;
        }

        @Override
        public String getWorldName() {
            this.logger.debug(() -> "[MobFilter] worldName cannot be evaluated during world generation");
            return null;
        }

        @Override
        public class_2960 getDimensionId() {
            this.logger.debug(() -> "[MobFilter] dimensionId cannot be evaluated during world generation");
            return null;
        }

        @Override
        public class_2960 getBlockId() {
            this.logger.debug(() -> "[MobFilter] blockId cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Integer getMoonPhase() {
            this.logger.debug(() -> "[MobFilter] moonPhase cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Integer getBrightness(class_1944 lightLayer, class_2338 blockPos) {
            this.logger.debug(() -> "[MobFilter] brightness cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Integer getMaxLocalRawBrightness(class_2338 blockPos) {
            this.logger.debug(() -> "[MobFilter] maxLocalRawBrightness cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Boolean isThundering() {
            this.logger.debug(() -> "[MobFilter] thundering cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Boolean isRainingAt(class_2338 blockPos) {
            this.logger.debug(() -> "[MobFilter] isRainingAt cannot be evaluated during world generation");
            return null;
        }

        @Override
        public class_1267 getDifficulty() {
            this.logger.debug(() -> "[MobFilter] difficulty cannot be evaluated during world generation");
            return null;
        }

        @Override
        public class_2960 getBiomeId() {
            this.logger.debug("[MobFilter] biomeId cannot be evaluated during world generation");
            return null;
        }

        @Override
        public class_1959 getBiome(class_2338 blockPos) {
            this.logger.debug(() -> "[MobFilter] biome cannot be evaluated during world generation");
            return null;
        }

        @Override
        public Long getDayTime() {
            this.logger.debug(() -> "[MobFilter] dayTime cannot be evaluated during world generation");
            return null;
        }
    }

    public static class MainThreadSpawnAttempt
    implements SpawnAttempt {
        private final class_3218 serverWorld;
        private final class_3730 spawnReason;
        private final class_1311 category;
        private final class_1299<?> entityType;
        private final class_2338 blockPos;
        private final Logger logger;

        MainThreadSpawnAttempt(class_3218 serverWorld, class_3730 spawnReason, class_1311 category, class_1299<?> entityType, class_2338 blockPos, Logger logger) {
            this.serverWorld = Objects.requireNonNull(serverWorld);
            this.spawnReason = spawnReason;
            this.category = category;
            this.entityType = entityType;
            this.blockPos = blockPos;
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public class_2960 getEntityId() {
            return class_7923.field_41177.method_10221(this.entityType);
        }

        @Override
        public class_1299<?> getEntityType() {
            return this.entityType;
        }

        @Override
        public String getWorldName() {
            class_5268 swp;
            try {
                swp = (class_5268)this.serverWorld.method_8401();
            }
            catch (ClassCastException cce) {
                this.logger.warn("[MobFilter] serverWorld.getLevelProperties() is unexpected class: " + this.serverWorld.method_8401().getClass().getName());
                return null;
            }
            return swp.method_150();
        }

        @Override
        public class_2960 getDimensionId() {
            return this.serverWorld.method_27983().method_29177();
        }

        @Override
        public class_2960 getBlockId() {
            class_2680 bs = this.serverWorld.method_8320(this.blockPos.method_10074());
            class_2248 block = bs.method_26204();
            return class_7923.field_41175.method_10221((Object)block);
        }

        @Override
        public class_3730 getSpawnReason() {
            return this.spawnReason;
        }

        @Override
        public class_1311 getMobCategory() {
            return this.category;
        }

        @Override
        public Logger getLogger() {
            return this.logger;
        }

        @Override
        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        @Override
        public Integer getMoonPhase() {
            return this.serverWorld.method_30273();
        }

        @Override
        public Integer getBrightness(class_1944 lightLayer, class_2338 blockPos) {
            return this.serverWorld.method_8314(lightLayer, blockPos);
        }

        @Override
        public Integer getMaxLocalRawBrightness(class_2338 blockPos) {
            return this.serverWorld.method_22339(blockPos);
        }

        @Override
        public Boolean isThundering() {
            return this.serverWorld.method_8546();
        }

        @Override
        public Boolean isRainingAt(class_2338 blockPos) {
            return this.serverWorld.method_8520(blockPos);
        }

        @Override
        public class_1267 getDifficulty() {
            return this.serverWorld.method_8407();
        }

        @Override
        public class_1959 getBiome(class_2338 blockPos) {
            class_6880 holder = this.serverWorld.method_23753(this.blockPos);
            if (holder == null) {
                this.logger.debug(() -> "[MobFilter] null biome returned at " + String.valueOf(this.blockPos));
                return null;
            }
            return (class_1959)holder.comp_349();
        }

        @Override
        public class_2960 getBiomeId() {
            class_1959 biome = this.getBiome(this.blockPos);
            if (biome == null) {
                return null;
            }
            return this.serverWorld.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        }

        @Override
        public Long getDayTime() {
            return this.serverWorld.method_8532();
        }
    }
}

