
# Tracks particle arrow to create emitter when it hits ground (not entity) and doesn't create if too close to one that exists
execute as @e[type=spectral_arrow,tag=!particle_arrow] if data entity @s item.components.minecraft:custom_data{particle_arrow:1b} at @s unless entity @n[type=marker,tag=t_particle_emitter,distance=..1] run tag @s add particle_arrow
execute as @e[type=spectral_arrow,tag=particle_arrow] at @s if data entity @s {inGround:1b} if entity @n[type=marker,tag=t_particle_emitter,distance=..1] run tag @s remove particle_arrow
execute as @e[type=spectral_arrow,tag=particle_arrow] at @s if data entity @s {inGround:1b} run function talon_particles:create_particle_emitter

# Creates interaction entities for particle emitters near players holding interact item
execute as @a[predicate=talon_particles:holding_particle_arrow] at @s as @e[type=marker,tag=t_particle_emitter,distance=..7,predicate=!talon_particles:riding_interaction] at @s summon interaction run ride @n[type=marker,tag=t_particle_emitter,distance=..0.01] mount @s
execute as @e[type=marker,tag=t_particle_emitter] at @s on vehicle if entity @s[type=interaction,tag=!t_particle_emitter_interact] run data merge entity @s {Tags:["t_particle_emitter_interact"],response:1b}

# Cleans up interaction entity when player isn't close enough
execute as @e[type=interaction,tag=t_particle_emitter_interact] at @s unless entity @p[distance=..7,predicate=talon_particles:holding_particle_arrow] run kill @s

# TRIGGERS
# Checks if player has clicked button in dialog and runs appropriate command
function talon_particles:check_triggers

# Emits particles, (individual data stored on marker)
execute as @e[type=marker,tag=t_particle_emitter] at @s if entity @p[distance=..32] run function talon_particles:emit_particles with entity @s data.particle

# Shows dialog on right click to player (must be after triggers to work properly)
execute as @e[type=interaction,tag=t_particle_emitter_interact] at @s on target if entity @s[tag=!t_particle_in_dialog,predicate=talon_particles:holding_particle_arrow] run function talon_particles:show_particle_dialog with entity @n[type=marker,tag=t_particle_emitter,distance=..1] data.particle
# If dialog failed to show, tries to update, and resets particles if stats out of range (to prevent exploits)
execute as @e[type=interaction,tag=t_particle_emitter_interact] at @s on target if entity @s[tag=!t_particle_in_dialog] as @n[type=marker,tag=t_particle_emitter] run function talon_particles:try_update
# interaction data is removed on dialog exit and after dialog selection in exit_dialog_cleanup

