
# Adds tag to identify player is in dialog menu
tag @s add t_particle_in_dialog
# Enable triggers for dialog
function talon_particles:enable_triggers
# Shows particle settings dialog (has macros to display current values as defaults
$dialog show @s {"type": "dialog_list","title": "Particle Settings","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs": [{"type": "multi_action","title": {"text": "Pick Your Particle","color": "aqua"},"exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"actions": [{"label": "Angry Villager","action": {"type": "run_command","command": "trigger t_particle_name set 1"}},{"label": "Ash","action": {"type": "run_command","command": "trigger t_particle_name set 2"}},{"label": "Bubble","action": {"type": "run_command","command": "trigger t_particle_name set 6"}},{"label": "Bubble Column Up","action": {"type": "run_command","command": "trigger t_particle_name set 7"}},{"label": "Bubble Pop","action": {"type": "run_command","command": "trigger t_particle_name set 8"}},{"label": "Campfire Cozy Smoke","action": {"type": "run_command","command": "trigger t_particle_name set 9"}},{"label": "Campfire Signal Smoke","action": {"type": "run_command","command": "trigger t_particle_name set 10"}},{"label": "Cherry Leaves","action": {"type": "run_command","command": "trigger t_particle_name set 11"}},{"label": "Cloud","action": {"type": "run_command","command": "trigger t_particle_name set 12"}},{"label": "Composter","action": {"type": "run_command","command": "trigger t_particle_name set 13"}},{"label": "Copper Fire Flame","action": {"type": "run_command","command": "trigger t_particle_name set 114"}},{"label": "Crimson Spore","action": {"type": "run_command","command": "trigger t_particle_name set 14"}},{"label": "Crit","action": {"type": "run_command","command": "trigger t_particle_name set 15"}},{"label": "Current Down","action": {"type": "run_command","command": "trigger t_particle_name set 16"}},{"label": "Damage Indicator","action": {"type": "run_command","command": "trigger t_particle_name set 17"}},{"label": "Dolphin","action": {"type": "run_command","command": "trigger t_particle_name set 18"}},{"label": "Dragon's Breath","action": {"type": "run_command","command": "trigger t_particle_name set 19"}},{"label": "Dripping Dripstone Lava","action": {"type": "run_command","command": "trigger t_particle_name set 20"}},{"label": "Dripping Dripstone Water","action": {"type": "run_command","command": "trigger t_particle_name set 21"}},{"label": "Dripping Honey","action": {"type": "run_command","command": "trigger t_particle_name set 22"}},{"label": "Dripping Lava","action": {"type": "run_command","command": "trigger t_particle_name set 23"}},{"label": "Dripping Obsidian Tear","action": {"type": "run_command","command": "trigger t_particle_name set 24"}},{"label": "Dripping Water","action": {"type": "run_command","command": "trigger t_particle_name set 25"}},{"label": "Dust Plume","action": {"type": "run_command","command": "trigger t_particle_name set 29"}},{"label": "Egg Crack","action": {"type": "run_command","command": "trigger t_particle_name set 31"}},{"label": "Elder Guardian (Short Range)","action": {"type": "run_command","command": "trigger t_particle_name set 32"}},{"label": "Electric Spark","action": {"type": "run_command","command": "trigger t_particle_name set 33"}},{"label": "Enchant","action": {"type": "run_command","command": "trigger t_particle_name set 34"}},{"label": "Enchanted Hit","action": {"type": "run_command","command": "trigger t_particle_name set 35"}},{"label": "End Rod","action": {"type": "run_command","command": "trigger t_particle_name set 36"}},{"label": "Explosion","action": {"type": "run_command","command": "trigger t_particle_name set 38"}},{"label": "Explosion Emitter","action": {"type": "run_command","command": "trigger t_particle_name set 39"}},{"label": "Falling Dripstone Lava","action": {"type": "run_command","command": "trigger t_particle_name set 40"}},{"label": "Falling Dripstone Water","action": {"type": "run_command","command": "trigger t_particle_name set 41"}},{"label": "Falling Honey","action": {"type": "run_command","command": "trigger t_particle_name set 43"}},{"label": "Falling Lava","action": {"type": "run_command","command": "trigger t_particle_name set 44"}},{"label": "Falling Nectar","action": {"type": "run_command","command": "trigger t_particle_name set 45"}},{"label": "Falling Obsidian Tear","action": {"type": "run_command","command": "trigger t_particle_name set 46"}},{"label": "Falling Spore Blossom","action": {"type": "run_command","command": "trigger t_particle_name set 47"}},{"label": "Falling Water","action": {"type": "run_command","command": "trigger t_particle_name set 48"}},{"label": "Firefly","action": {"type": "run_command","command": "trigger t_particle_name set 49"}},{"label": "Firework","action": {"type": "run_command","command": "trigger t_particle_name set 50"}},{"label": "Fishing","action": {"type": "run_command","command": "trigger t_particle_name set 51"}},{"label": "Flame","action": {"type": "run_command","command": "trigger t_particle_name set 52"}},{"label": "Glow","action": {"type": "run_command","command": "trigger t_particle_name set 54"}},{"label": "Glow Squid Ink","action": {"type": "run_command","command": "trigger t_particle_name set 55"}},{"label": "Gust","action": {"type": "run_command","command": "trigger t_particle_name set 56"}},{"label": "Gust Emitter","action": {"type": "run_command","command": "trigger t_particle_name set 57"}},{"label": "Happy Villager","action": {"type": "run_command","command": "trigger t_particle_name set 58"}},{"label": "Heart","action": {"type": "run_command","command": "trigger t_particle_name set 59"}},{"label": "Infested","action": {"type": "run_command","command": "trigger t_particle_name set 60"}},{"label": "Item Cobweb","action": {"type": "run_command","command": "trigger t_particle_name set 63"}},{"label": "Item Slime","action": {"type": "run_command","command": "trigger t_particle_name set 64"}},{"label": "Item Snowball","action": {"type": "run_command","command": "trigger t_particle_name set 65"}},{"label": "Landing Honey","action": {"type": "run_command","command": "trigger t_particle_name set 66"}},{"label": "Landing Lava","action": {"type": "run_command","command": "trigger t_particle_name set 67"}},{"label": "Landing Obsidian Tear","action": {"type": "run_command","command": "trigger t_particle_name set 68"}},{"label": "Large Smoke","action": {"type": "run_command","command": "trigger t_particle_name set 69"}},{"label": "Lava","action": {"type": "run_command","command": "trigger t_particle_name set 70"}},{"label": "Mycelium","action": {"type": "run_command","command": "trigger t_particle_name set 71"}},{"label": "Nautilus","action": {"type": "run_command","command": "trigger t_particle_name set 72"}},{"label": "Note","action": {"type": "run_command","command": "trigger t_particle_name set 73"}},{"label": "Ominous Spawning","action": {"type": "run_command","command": "trigger t_particle_name set 74"}},{"label": "Pale Oak Leaves","action": {"type": "run_command","command": "trigger t_particle_name set 75"}},{"label": "Poof","action": {"type": "run_command","command": "trigger t_particle_name set 76"}},{"label": "Portal","action": {"type": "run_command","command": "trigger t_particle_name set 77"}},{"label": "Raid Omen","action": {"type": "run_command","command": "trigger t_particle_name set 78"}},{"label": "Rain","action": {"type": "run_command","command": "trigger t_particle_name set 79"}},{"label": "Reverse Portal","action": {"type": "run_command","command": "trigger t_particle_name set 80"}},{"label": "Scrape","action": {"type": "run_command","command": "trigger t_particle_name set 81"}},{"label": "Sculk Charge Pop","action": {"type": "run_command","command": "trigger t_particle_name set 83"}},{"label": "Sculk Soul","action": {"type": "run_command","command": "trigger t_particle_name set 84"}},{"label": "Shriek","action": {"type": "run_command","command": "trigger t_particle_name set 85"}},{"label": "Small Flame","action": {"type": "run_command","command": "trigger t_particle_name set 86"}},{"label": "Small Gust","action": {"type": "run_command","command": "trigger t_particle_name set 87"}},{"label": "Smoke","action": {"type": "run_command","command": "trigger t_particle_name set 88"}},{"label": "Sneeze","action": {"type": "run_command","command": "trigger t_particle_name set 89"}},{"label": "Snowflake","action": {"type": "run_command","command": "trigger t_particle_name set 90"}},{"label": "Sonic Boom","action": {"type": "run_command","command": "trigger t_particle_name set 91"}},{"label": "Soul","action": {"type": "run_command","command": "trigger t_particle_name set 92"}},{"label": "Soul Fire Flame","action": {"type": "run_command","command": "trigger t_particle_name set 93"}},{"label": "Spit","action": {"type": "run_command","command": "trigger t_particle_name set 94"}},{"label": "Splash","action": {"type": "run_command","command": "trigger t_particle_name set 95"}},{"label": "Spore Blossom Air","action": {"type": "run_command","command": "trigger t_particle_name set 96"}},{"label": "Squid Ink","action": {"type": "run_command","command": "trigger t_particle_name set 97"}},{"label": "Sweep Attack","action": {"type": "run_command","command": "trigger t_particle_name set 98"}},{"label": "Totem Of Undying","action": {"type": "run_command","command": "trigger t_particle_name set 100"}},{"label": "Trial Omen","action": {"type": "run_command","command": "trigger t_particle_name set 102"}},{"label": "Trial Spawner Detection","action": {"type": "run_command","command": "trigger t_particle_name set 103"}},{"label": "Trial Spawner Detection Ominous","action": {"type": "run_command","command": "trigger t_particle_name set 104"}},{"label": "Underwater","action": {"type": "run_command","command": "trigger t_particle_name set 105"}},{"label": "Vault Connection","action": {"type": "run_command","command": "trigger t_particle_name set 106"}},{"label": "Warped Spore","action": {"type": "run_command","command": "trigger t_particle_name set 108"}},{"label": "Wax Off","action": {"type": "run_command","command": "trigger t_particle_name set 109"}},{"label": "Wax On","action": {"type": "run_command","command": "trigger t_particle_name set 110"}},{"label": "White Ash","action": {"type": "run_command","command": "trigger t_particle_name set 111"}},{"label": "White Smoke","action": {"type": "run_command","command": "trigger t_particle_name set 112"}},{"label": "Witch","action": {"type": "run_command","command": "trigger t_particle_name set 113"}}]},{"type": "dialog_list","title": {"text": "Pick An Advanced Particle","color": "aqua"},"exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": "Block","body":[{"type": "plain_message","contents":"Sets particle to be block held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_block set 1"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Block Crumble","body":[{"type": "plain_message","contents":"Sets particle to be block held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_block set 2"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Block Marker","body":[{"type": "plain_message","contents":"Sets particle to be block held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_block set 3"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "dialog_list","title": "Dust","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "d_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_d_red1 set $(d_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "d_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_d_green1 set $(d_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "d_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_d_blue1 set $(d_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Scale","body":[{"type": "plain_message","contents":"Changes size and lifetime of particle in 10ths (minimum is 1.0)."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "d_scl","type": "number_range","start": 10,"end": 40,"initial": $(display_scale),"step": 1,"label": "Scale"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_d_scale set $(d_scl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Dust Color Transition","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red Start","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red this particle starts with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_red1 set $(dct_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green Start","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green this particle starts with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_green1 set $(dct_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue Start","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue this particle starts with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_blue1 set $(dct_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Red End","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red this particle ends with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_r2","type": "number_range","start": 0,"end": 255,"initial": $(display_red2),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_red2 set $(dct_r2)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green End","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green this particle ends with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_g2","type": "number_range","start": 0,"end": 255,"initial": $(display_green2),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_green2 set $(dct_g2)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue End","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue this particle ends with."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_b2","type": "number_range","start": 0,"end": 255,"initial": $(display_blue2),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_blue2 set $(dct_b2)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Scale","body":[{"type": "plain_message","contents":"Changes size and lifetime of particle in 10ths (minimum is 1.0)."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dct_scl","type": "number_range","start": 10,"end": 40,"initial": $(display_scale),"step": 1,"label": "Scale"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_dct_scale set $(dct_scl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "confirmation","title": "Dust Pillar","body":[{"type": "plain_message","contents":"Sets particle to be block held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_block set 4"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Falling Dust","body":[{"type": "plain_message","contents":"Sets particle to be block held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_block set 5"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "dialog_list","title": "Effect (Splash Potions)","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "e_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_e_red1 set $(e_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "e_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_e_green1 set $(e_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "e_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_e_blue1 set $(e_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Entity Effect (Beacon Effect)","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ee_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ee_red1 set $(ee_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ee_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ee_green1 set $(ee_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ee_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ee_blue1 set $(ee_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Alpha","body":[{"type": "plain_message","contents":"Changes particle transparency as a percent."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ee_al","type": "number_range","start": 0,"end": 100,"initial": $(display_alpha),"step": 1,"label": "Alpha"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ee_alpha set $(ee_al)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Flash","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "f_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_f_red1 set $(f_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "f_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_f_green1 set $(f_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "f_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_f_blue1 set $(f_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Alpha","body":[{"type": "plain_message","contents":"Changes particle transparency as a percent."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "f_al","type": "number_range","start": 0,"end": 100,"initial": $(display_alpha),"step": 1,"label": "Alpha"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_f_alpha set $(f_al)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Instant Effect","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ie_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ie_red1 set $(ie_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ie_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ie_green1 set $(ie_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ie_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_ie_blue1 set $(ie_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "confirmation","title": "Item","body":[{"type": "plain_message","contents":"Sets particle to be item held in offhand."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Save","action": {"type": "run_command","command": "trigger t_particle_item set 1"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Sculk Charge","body":[{"type": "plain_message","contents":"Changes angle sculk charge pops from."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "srl","type": "number_range","start": 0,"end": 360,"initial": $(display_s_roll),"step": 1,"label": "Roll Angle"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_s_roll set $(srl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "dialog_list","title": "Tinted Leaves","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "tl_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_tl_red1 set $(tl_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "tl_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_tl_green1 set $(tl_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "tl_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_tl_blue1 set $(tl_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Trail","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": {"text": "Set Red","color": "red"},"body":[{"type": "plain_message","contents":"Sets how much red to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_r1","type": "number_range","start": 0,"end": 255,"initial": $(display_red1),"step": 1,"label": {"text": "Red","color": "red"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_red1 set $(t_r1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Green","color": "green"},"body":[{"type": "plain_message","contents":"Sets how much green to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_g1","type": "number_range","start": 0,"end": 255,"initial": $(display_green1),"step": 1,"label": {"text": "Green","color": "green"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_green1 set $(t_g1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Blue","color": "blue"},"body":[{"type": "plain_message","contents":"Sets how much blue to include in the particle."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_b1","type": "number_range","start": 0,"end": 255,"initial": $(display_blue1),"step": 1,"label": {"text": "Blue","color": "blue"}}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_blue1 set $(t_b1)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Destination X","body":[{"type": "plain_message","contents":"Set the X coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_gx","type": "text","initial": "$(display_goalx)","label": "Destination X"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_goalx set $(t_gx)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Destination Y","body":[{"type": "plain_message","contents":"Set the Y coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_gy","type": "text","initial": "$(display_goaly)","label": "Destination Y"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_goaly set $(t_gy)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Destination Z","body":[{"type": "plain_message","contents":"Set the Z coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_gz","type": "text","initial": "$(display_goalz)","label": "Destination Z"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_goalz set $(t_gz)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Travel Time","body":[{"type": "plain_message","contents":"Changes how long it takes to reach the destination in game ticks."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "t_trvl","type": "number_range","start": 1,"end": 100,"initial": $(display_travel),"step": 1,"label": "Travel Time"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_t_travel set $(t_trvl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]},{"type": "dialog_list","title": "Vibration","exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}},"dialogs":[{"type": "confirmation","title": "Set Destination X","body":[{"type": "plain_message","contents":"Set the X coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "v_gx","type": "text","initial": "$(display_goalx)","label": "Destination X"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_v_goalx set $(v_gx)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Destination Y","body":[{"type": "plain_message","contents":"Set the Y coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "v_gy","type": "text","initial": "$(display_goaly)","label": "Destination Y"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_v_goaly set $(v_gy)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Destination Z","body":[{"type": "plain_message","contents":"Set the Z coordinate in 10ths of a block for the particles to travel to (can't be exactly 0.0)."},{"type": "plain_message","contents": "So -156.5 would become -1565."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "v_gz","type": "text","initial": "$(display_goalz)","label": "Destination Z"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_v_goalz set $(v_gz)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Set Travel Time","body":[{"type": "plain_message","contents":"Changes how long it takes to reach the destination in game ticks."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "v_trvl","type": "number_range","start": 1,"end": 100,"initial": $(display_travel),"step": 1,"label": "Travel Time"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_v_travel set $(v_trvl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]}]},{"type": "confirmation","title": {"text": "Offset Particle Cloud X","color": "yellow"},"body": [{"type": "plain_message","contents": "This adjusts the center of the particle cloud on the X-axis."},{"type": "plain_message","contents": "Turn on Draw Lines to see linkage."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ox","type": "number_range","start": -50,"end": 50,"initial": $(display_offsetx),"step": 1,"label": "X Offset 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_offsetx set $(ox)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Offset Particle Cloud Y","color": "yellow"},"body": [{"type": "plain_message","contents": "This adjusts the center of the particle cloud on the Y-axis."},{"type": "plain_message","contents": "Turn on Draw Lines to see linkage."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "oy","type": "number_range","start": -50,"end": 50,"initial": $(display_offsety),"step": 1,"label": "Y Offset 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_offsety set $(oy)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Offset Particle Cloud Z","color": "yellow"},"body": [{"type": "plain_message","contents": "This adjusts the center of the particle cloud on the Z-axis."},{"type": "plain_message","contents": "Turn on Draw Lines to see linkage."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "oz","type": "number_range","start": -50,"end": 50,"initial": $(display_offsetz),"step": 1,"label": "Z Offset 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_offsetz set $(oz)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Draw Lines","color": "yellow"},"body": [{"type": "plain_message","contents": "Draws lines between particle cloud center and interaction entity. Useful when using offset numbers."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "dl","type": "boolean","on_true": "1","on_false": "0","initial": $(draw_lines),"label": "Draw Lines"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_draw_lines set $(dl)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Particle Cloud X Radius","color": "green"},"body": [{"type": "plain_message","contents": "This sets where most of the particles will spawn. There is a small chance particles may appear outside this radius."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "rx","type": "number_range","start": 1,"end": 320,"initial": $(display_radiusx),"step": 1,"label": "X Radius 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_radiusx set $(rx)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Particle Cloud Y Radius","color": "green"},"body": [{"type": "plain_message","contents": "This sets where most of the particles will spawn. There is a small chance particles may appear outside this radius."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "ry","type": "number_range","start": 1,"end": 320,"initial": $(display_radiusy),"step": 1,"label": "Y Radius 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_radiusy set $(ry)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Set Particle Cloud Z Radius","color": "green"},"body": [{"type": "plain_message","contents": "This sets where most of the particles will spawn. There is a small chance particles may appear outside this radius."},{"type": "plain_message","contents": "Set in 10ths of a block."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "rz","type": "number_range","start": 1,"end": 320,"initial": $(display_radiusz),"step": 1,"label": "Z Radius 10ths"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_radiusz set $(rz)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Choose Your Particle Speed","color": "light_purple"},"body": [{"type": "plain_message","contents": "This setting does not affect every particle, and some particles act strangely when extreme values are set."},{"type": "plain_message","contents": "Normal speed is 1000."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "spd","type": "number_range","start": 1,"end": 10000,"initial": $(display_speed),"step": 1,"label": "Particle Speed"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_speed set $(spd)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Choose How Many Particles","color": "gold"},"body": [{"type": "plain_message","contents": "Setting this to 0 causes a single particle to spawn at the center. Any value higher than 0 will spawn the particle(s) randomly within the cloud's radius."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "amt","type": "number_range","start": 0,"end": 100,"initial": $(amount),"step": 1,"label": "Amount Of Particles"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_amount set $(amt)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Choose Clock Cycle Duration","body": [{"type": "plain_message","contents": "Choose how long it takes to complete a clock cycle in game ticks (20 game ticks in a second)."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "clk","type": "number_range","start": 1,"end": 100,"initial": $(clock),"step": 1,"label": "Triggers Every"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_clock set $(clk)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Choose Particle Random Chance","body": [{"type": "plain_message","contents": "Set the percent chance for the particle cloud to spawn."},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "chn","type": "number_range","start": 0,"end": 100,"initial": $(display_chance),"step": 1,"label": "Percent Chance"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_chance set $(chn)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text": "Redstone Control","color": "dark_red"},"body": [{"type": "plain_message","contents": "Allow redstone to control when particles spawn."},{"type": "plain_message","contents": "To use, just place redstone dust at the center of the particle cloud (F3 + B while holding Particle Arrow to find the center) and turn it on!"},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"inputs": [{"key": "rs","type": "boolean","on_true": "1","on_false": "0","initial": $(use_redstone),"label": "Redstone Control"}],"yes": {"label": "Save","action": {"type": "dynamic/run_command","template": "trigger t_particle_use_redstone set $(rs)"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "multi_action","title": "Copy/Paste","body": [{"type": "plain_message","contents": "Copying/Pasting will affect ALL settings including XYZ Offset."},{"type": "plain_message","contents": "Make sure you're certain before overwriting settings with Paste especially."},{"type": "plain_message","contents": ""}],"actions": [{"label": "Copy","action": {"type": "run_command","command": "trigger t_particle_copy_paste set 1"}},{"label": "Paste","action": {"type": "run_command","command": "trigger t_particle_copy_paste set 2"}}],"exit_action": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": "Reset To Defaults","body": [{"type": "plain_message","contents": "Are you sure you want to reset ALL particles settings back to their default?"},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": "Reset","action": {"type": "run_command","command": "trigger t_particle_default set 1"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}},{"type": "confirmation","title": {"text":"Delete Particle Emitter","color":"red"},"body": [{"type": "plain_message","contents": "Are you sure you want to delete this particle emitter?"},{"type": "plain_message","contents": ""},{"type": "plain_message","contents": ""}],"yes": {"label": {"text":"Delete","color":"red"},"action": {"type": "run_command","command": "trigger t_particle_delete set 1"}},"no": {"label": "Cancel","action": {"type": "run_command","command": "trigger t_particle_exit set 1"}}}]}
