/*
 * Decompiled with CFR 0.152.
 */
package com.rituals;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.rituals.commands.AdminCommands;
import com.rituals.commands.HelpCommand;
import com.rituals.config.RitualsConfig;
import java.util.ArrayList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_5251;
import net.minecraft.class_9015;
import net.minecraft.class_9262;
import net.minecraft.class_9279;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RitualsMod
implements ModInitializer {
    public static final String MOD_ID = "rituals";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rituals");

    public void onInitialize() {
        LOGGER.info("===========================================");
        LOGGER.info("  Rituals - Fire Sacrifice Edition  ");
        LOGGER.info("===========================================");
        LOGGER.info("Mod loaded successfully!");
        LOGGER.info("Datapack and resource pack auto-installed.");
        LOGGER.info("Registering commands...");
        this.registerCommands();
        LOGGER.info("Commands registered! Use /rituals help");
        LOGGER.info("===========================================");
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder ritualsCommand = class_2170.method_9247((String)MOD_ID);
            ritualsCommand.then(class_2170.method_9247((String)"help").executes(HelpCommand::showHelp));
            ritualsCommand.then(class_2170.method_9247((String)"guidebook").executes(this::giveGuidebook));
            ritualsCommand.then(class_2170.method_9247((String)"get").executes(this::cmdGet));
            LiteralArgumentBuilder giveCommand = class_2170.method_9247((String)"give");
            giveCommand.then(class_2170.method_9247((String)"all").executes(this::giveAllTotems));
            giveCommand.then(class_2170.method_9247((String)"guidebook").executes(this::giveGuidebook));
            giveCommand.then(class_2170.method_9247((String)"totems_short").executes(this::giveTotemsShort));
            giveCommand.then(class_2170.method_9247((String)"totem_copper").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "copper", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_copper_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "copper", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_gold").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "gold", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_gold_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "gold", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_basic").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "wood", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_basic_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "wood", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_advanced").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "diamond", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_advanced_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "diamond", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_master").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "netherite", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_master_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "netherite", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_netherite").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "netherite", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_netherite_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "netherite", true)));
            giveCommand.then(class_2170.method_9247((String)"totem_iron").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "iron", false)));
            giveCommand.then(class_2170.method_9247((String)"totem_iron_short").executes(ctx -> this.giveTotem((CommandContext<class_2168>)ctx, "iron", true)));
            ritualsCommand.then((ArgumentBuilder)giveCommand);
            LiteralArgumentBuilder configCommand = class_2170.method_9247((String)"config");
            configCommand.then(class_2170.method_9247((String)"reload").executes(ctx -> {
                RitualsConfig.reload();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[Rituals] ").method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)"\u2713 Config reloaded!").method_27692(class_124.field_1060)), false);
                return 1;
            }));
            ritualsCommand.then((ArgumentBuilder)configCommand);
            LiteralArgumentBuilder badgesCommand = class_2170.method_9247((String)"badges");
            badgesCommand.then(class_2170.method_9247((String)"check_status").executes(this::checkBadgeStatus));
            ritualsCommand.then((ArgumentBuilder)badgesCommand);
            LiteralArgumentBuilder adminCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> source.method_9259(2));
            adminCommand.then(class_2170.method_9247((String)"debug_status").executes(AdminCommands::showDebugStatus));
            adminCommand.then(class_2170.method_9247((String)"enable_debug_mode").executes(AdminCommands::enableDebugMode));
            adminCommand.then(class_2170.method_9247((String)"disable_debug_mode").executes(AdminCommands::disableDebugMode));
            adminCommand.then(class_2170.method_9247((String)"enable_kiwi_mode").executes(AdminCommands::enableKiwiMode));
            adminCommand.then(class_2170.method_9247((String)"disable_kiwi_mode").executes(AdminCommands::disableKiwiMode));
            adminCommand.then(class_2170.method_9247((String)"list_totems").executes(AdminCommands::listTotems));
            adminCommand.then(class_2170.method_9247((String)"reset_all").executes(AdminCommands::resetAll));
            adminCommand.then(class_2170.method_9247((String)"uninstall").executes(AdminCommands::uninstall));
            adminCommand.then(class_2170.method_9247((String)"unlock_all_recipes").executes(AdminCommands::unlockAllRecipes));
            adminCommand.then(class_2170.method_9247((String)"update_previews").executes(AdminCommands::updatePreviews));
            adminCommand.then(class_2170.method_9247((String)"test_recipes").executes(AdminCommands::testRecipes));
            adminCommand.then(class_2170.method_9247((String)"debug_recipes").executes(AdminCommands::debugRecipes));
            adminCommand.then(class_2170.method_9247((String)"debug_barriers").executes(AdminCommands::debugBarriers));
            ritualsCommand.then((ArgumentBuilder)adminCommand);
            dispatcher.register(ritualsCommand);
            LOGGER.info("Registered /rituals command (pure Java implementations)");
        });
    }

    private int giveGuidebook(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            class_3222 player = source.method_9207();
            class_1799 book = new class_1799((class_1935)class_1802.field_8360);
            String[] pages = new String[]{"Rituals\n\nWelcome Ritualist!\n\nThis guide teaches the ancient art of ritual magic.\n\nPress L for the full Advancement Guide!", "Getting Started\n\n1. Craft a totem\n2. Right-click to place\n3. Add item on top\n4. Drop 4 catalysts around (N/S/E/W)\n5. Light fire at base\n6. Ritual activates!\n\nSingle totem works!", "Fire Sacrifice\n\nRituals need fire to activate!\n\n1. Place totem + item\n2. Drop 4 catalysts around it\n3. Light fire at base\n4. Offerings consumed\n5. Magic begins!\n\nUse /rituals admin enable_kiwi_mode to skip fire.", "Catalyst Costs\n\nBy Tier:\n\nWood: 4 Coal\nCopper: 4 Copper\nIron: 4 Iron\nGold: 4 Gold\nDiamond: 4 Diamond\nNetherite: 4 Netherite\n\n\nHigher tier = higher cost!", "Totem Tiers\n\n1. Wood - Basic\n   Range: 2x2x6\n2. Copper - Improved\n   Range: 3x3x8\n3. Iron - Strong\n   Range: 4x4x10\n4. Gold - Very Strong\n   Range: 5x5x12", "Tiers Continued\n\n5. Diamond - Powerful\n   Range: 6x6x14\n6. Netherite - Ultimate\n   Range: 7x7x16\n\n\nHigher tier = larger range and stronger effects!", "Area Effect Rituals\n\nEmerald - Growth\nGrows crops nearby\n\nDiamond - Strength\nBuffs players\n\nNetherite Block\nProsperity: Items+XP\n\nAll rituals are continuous until toggled off!", "More Area Effects\n\nIron Ingot\nProtection: Damage mobs\n\nNether Star\nHealing: Regeneration\n\nArrow\nSentry: Auto-fires (2x range!)\n\nDiamond Hoe\nAuto-Farming (4+ totems)", "Pattern Rituals\n\nSome rituals need multiple totems with specific items!\n\nDiamond Hoe + 4 totems\nAuto-Harvest farms\n\nWheat + 4 totems\nAuto-Breeding animals\n\nUse redstone near totems to see patterns!", "Crafting: Wood Totem\n\n    [S]\n [S][P][S]\n    [P]\n\nS = Stick\nP = Oak Planks\n\nResult:\n1 Wood Totem\n\nShort: Skip top row", "Crafting: Higher Tiers\n\nAll follow same pattern:\n\n    [I]\n [I][B][I]\n    [B]\n\nCopper: Copper Ingot + Block\nIron: Iron Ingot + Block\nGold: Gold Ingot + Block\nDiamond: Diamond + Block\nNetherite: Netherite + Block\n\n\nCraft higher tier totems directly!", "Range Display\n\nPower totem with redstone to see range!\n\nRed particles = tier range\nColored particles = pattern positions\n\nWorks with lever, torch, redstone block, button", "Helpful Commands\n\n/rituals help\nShows help menu\n\n/rituals get\nGet all items\n\n/rituals give guidebook\nGet another book", "Advanced Tips\n\n- Pattern rituals need exact item per totem\n- Regular rituals work with same item on all totems\n- Fire sacrifice required by default\n- Can disable with Kiwi Mode\n- See docs/ folder for more!", "Configuration\n\nCustomize settings:\n\n/data get storage rituals:config\n\nKey settings:\nrequire_fire_sacrifice\nmin_totems_required\nritual_duration\nkiwi_mode", "Happy Ritualing!\n\nMay your totems shine bright!\n\nFor detailed guides see docs/ folder:\n- PATTERN_RITUALS_GUIDE.md\n- FIRE_SACRIFICE_GUIDE.md\n- CRAFTING_RECIPES.md\n\n- Ancient Ritualist"};
            ArrayList<class_9262> pageComponents = new ArrayList<class_9262>();
            for (String page : pages) {
                pageComponents.add(class_9262.method_57137((Object)class_2561.method_43470((String)page)));
            }
            class_9302 content = new class_9302(class_9262.method_57137((Object)"Rituals Guide"), "Ancient Ritualist", 0, pageComponents, true);
            book.method_57379(class_9334.field_49606, (Object)content);
            player.method_7270(book);
            source.method_9226(() -> class_2561.method_43470((String)"[Rituals] ").method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)"Gave Rituals Guidebook!").method_27692(class_124.field_1060)), false);
            LOGGER.info("Gave guidebook to {}", (Object)player.method_5477().getString());
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player!"));
            LOGGER.error("Error giving guidebook", (Throwable)e);
            return 0;
        }
    }

    private int cmdGet(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Use /rituals give all to get all items!").method_27692(class_124.field_1054), false);
        return 1;
    }

    private int giveTotem(CommandContext<class_2168> ctx, String tier, boolean isShort) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            int totemTier;
            String hexColor;
            String displayName;
            class_3222 player = source.method_9207();
            class_1799 totem = new class_1799((class_1935)class_1802.field_23254);
            boolean hasGlint = false;
            switch (tier) {
                case "wood": {
                    displayName = isShort ? "Short Wooden Totem" : "Wooden Totem";
                    hexColor = "#DAA520";
                    totemTier = 1;
                    break;
                }
                case "copper": {
                    displayName = isShort ? "Short Copper Totem" : "Copper Totem";
                    hexColor = "#B87333";
                    totemTier = 2;
                    break;
                }
                case "iron": {
                    displayName = isShort ? "Short Iron Totem" : "Iron Totem";
                    hexColor = "#808080";
                    totemTier = 3;
                    break;
                }
                case "gold": {
                    displayName = isShort ? "Short Gold Totem" : "Gold Totem";
                    hexColor = "#DAA520";
                    totemTier = 4;
                    break;
                }
                case "diamond": {
                    displayName = isShort ? "Short Diamond Totem" : "Diamond Totem";
                    hexColor = "#00FFFF";
                    totemTier = 5;
                    hasGlint = true;
                    break;
                }
                case "netherite": {
                    displayName = isShort ? "Short Netherite Totem" : "Netherite Totem";
                    hexColor = "#8B0000";
                    totemTier = 6;
                    hasGlint = true;
                    break;
                }
                default: {
                    displayName = "Unknown Totem";
                    hexColor = "#FFFFFF";
                    totemTier = 1;
                }
            }
            class_5251 color = class_5251.method_27719((String)hexColor).result().orElse(class_5251.method_27717((int)0xFFFFFF));
            totem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)displayName).method_27694(style -> style.method_27703(color).method_10978(Boolean.valueOf(false))));
            class_2487 customData = new class_2487();
            customData.method_10569("rituals_totem", 1);
            customData.method_10569("totem_tier", totemTier);
            if (isShort) {
                customData.method_10569("totem_short", 1);
            }
            totem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
            if (hasGlint) {
                totem.method_57379(class_9334.field_49641, (Object)true);
            }
            player.method_7270(totem);
            source.method_9226(() -> class_2561.method_43470((String)"[Rituals] ").method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)("Gave " + displayName + "!")).method_27692(class_124.field_1060)), false);
            LOGGER.info("Gave {} to {}", (Object)displayName, (Object)player.method_5477().getString());
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player!"));
            LOGGER.error("Error giving totem", (Throwable)e);
            return 0;
        }
    }

    private int giveAllTotems(CommandContext<class_2168> ctx) {
        this.giveTotem(ctx, "wood", false);
        this.giveTotem(ctx, "copper", false);
        this.giveTotem(ctx, "iron", false);
        this.giveTotem(ctx, "gold", false);
        this.giveTotem(ctx, "diamond", false);
        this.giveTotem(ctx, "netherite", false);
        this.giveTotemsShort(ctx);
        this.giveGuidebook(ctx);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[Rituals] ").method_27692(class_124.field_1065).method_27692(class_124.field_1067).method_10852((class_2561)class_2561.method_43470((String)"Gave all items + Guidebook!").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private int giveTotemsShort(CommandContext<class_2168> ctx) {
        this.giveTotem(ctx, "wood", true);
        this.giveTotem(ctx, "copper", true);
        this.giveTotem(ctx, "iron", true);
        this.giveTotem(ctx, "gold", true);
        this.giveTotem(ctx, "diamond", true);
        this.giveTotem(ctx, "netherite", true);
        return 1;
    }

    private int reloadConfig(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Configuration reloaded!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int showDebugStatus(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"=== Rituals Debug Status ===").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"Mod Version: 1.1.0").method_27692(class_124.field_1080), false);
        source.method_9226(() -> class_2561.method_43470((String)"Status: Running").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int enableDebugMode(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Debug mode enabled!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int disableDebugMode(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Debug mode disabled!").method_27692(class_124.field_1054), false);
        return 1;
    }

    private int enableKiwiMode(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Kiwi Mode enabled! (No fire sacrifice required)").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int disableKiwiMode(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Kiwi Mode disabled! (Fire sacrifice required)").method_27692(class_124.field_1054), false);
        return 1;
    }

    private int listTotems(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Active Totems ===").method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"(Totem tracking in development)").method_27692(class_124.field_1080), false);
        return 1;
    }

    private int resetAll(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u26a0 Reset all ritual data!").method_27692(class_124.field_1061), false);
        return 1;
    }

    private int uninstall(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u26a0 Uninstall prepared!").method_27692(class_124.field_1061), false);
        return 1;
    }

    private int unlockAllRecipes(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 All recipes unlocked!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int updatePreviews(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 Updated totem previews!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int testRecipes(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Recipe Test ===").method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u2713 All recipes functional").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int debugRecipes(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Recipe Debug Info ===").method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Total recipes: 12").method_27692(class_124.field_1080), false);
        return 1;
    }

    private int debugBarriers(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"=== Barrier Debug ===").method_27692(class_124.field_1065), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Barrier entities: 0").method_27692(class_124.field_1080), false);
        return 1;
    }

    private int checkBadgeStatus(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        try {
            class_3222 player = source.method_9207();
            int ritualsCompleted = 0;
            String badgeTier = "\u00a7aNovice";
            try {
                class_2995 scoreboard = source.method_9211().method_3845();
                class_266 objective = scoreboard.method_1170("rituals.ritual_count");
                if (objective != null) {
                    ritualsCompleted = scoreboard.method_55430((class_9015)player, objective).method_55397();
                }
                if (ritualsCompleted >= 100) {
                    badgeTier = "\u00a76Legendary";
                } else if (ritualsCompleted >= 50) {
                    badgeTier = "\u00a75Epic";
                } else if (ritualsCompleted >= 25) {
                    badgeTier = "\u00a7bRare";
                } else if (ritualsCompleted >= 10) {
                    badgeTier = "\u00a72Uncommon";
                } else if (ritualsCompleted >= 5) {
                    badgeTier = "\u00a7fCommon";
                }
            }
            catch (Exception scoreboard) {
                // empty catch block
            }
            int finalRitualsCompleted = ritualsCompleted;
            String finalBadgeTier = badgeTier;
            source.method_9226(() -> class_2561.method_43470((String)""), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").method_27692(class_124.field_1065), false);
            source.method_9226(() -> class_2561.method_43470((String)"  \u26a1 Ritual Badge Status").method_27692(class_124.field_1065).method_27692(class_124.field_1067), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").method_27692(class_124.field_1065), false);
            source.method_9226(() -> class_2561.method_43470((String)""), false);
            source.method_9226(() -> class_2561.method_43470((String)"Player: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)player.method_5477().getString()).method_27692(class_124.field_1068)), false);
            source.method_9226(() -> class_2561.method_43470((String)"Rituals Completed: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(finalRitualsCompleted)).method_27692(class_124.field_1054)), false);
            source.method_9226(() -> class_2561.method_43470((String)"Badge Tier: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)finalBadgeTier)), false);
            source.method_9226(() -> class_2561.method_43470((String)""), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501").method_27692(class_124.field_1065), false);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player!"));
            LOGGER.error("Error checking badge status", (Throwable)e);
            return 0;
        }
    }
}

