# ========================================
# Consume Offerings (SQUARE PATTERN - MACRO)
# ========================================
# Kills items at DIAGONAL corners and activates ritual
# Parameters: item (e.g., "minecraft:coal"), name (e.g., "Coal")

# Check pattern FIRST before consuming
function rituals:ritual/detect_type

# If ritual didn't activate, return without consuming
execute unless entity @s[tag=rituals.active_ritual] run return 0

# Pattern was valid! Kill offering items at all 4 diagonal corners (±2 positions)
$execute positioned ~2 ~ ~2 as @e[type=item,nbt={Item:{id:"$(item)"}},distance=..1.5] run kill @s
$execute positioned ~2 ~ ~-2 as @e[type=item,nbt={Item:{id:"$(item)"}},distance=..1.5] run kill @s
$execute positioned ~-2 ~ ~-2 as @e[type=item,nbt={Item:{id:"$(item)"}},distance=..1.5] run kill @s
$execute positioned ~-2 ~ ~2 as @e[type=item,nbt={Item:{id:"$(item)"}},distance=..1.5] run kill @s

# Particle effects at each corner
execute positioned ~2 ~ ~2 run particle soul_fire_flame ~ ~ ~ 0.1 0.5 0.1 0.02 20
execute positioned ~2 ~ ~-2 run particle soul_fire_flame ~ ~ ~ 0.1 0.5 0.1 0.02 20
execute positioned ~-2 ~ ~-2 run particle soul_fire_flame ~ ~ ~ 0.1 0.5 0.1 0.02 20
execute positioned ~-2 ~ ~2 run particle soul_fire_flame ~ ~ ~ 0.1 0.5 0.1 0.02 20

# Center effects
playsound minecraft:block.portal.trigger block @a ~ ~ ~ 0.5 1.8
playsound minecraft:entity.blaze.shoot block @a ~ ~ ~ 0.8 0.8
particle flame ~ ~0.5 ~ 0.3 0.3 0.3 0.05 50
particle lava ~ ~0.5 ~ 0.5 0.5 0.5 0.1 10
particle enchant ~ ~0.5 ~ 0.3 1 0.3 0.3 100
particle end_rod ~ ~0.5 ~ 0.2 1 0.2 0.05 30

# Extinguish fire
execute if block ~ ~ ~ minecraft:fire run setblock ~ ~ ~ minecraft:air
execute if block ~ ~ ~ minecraft:soul_fire run setblock ~ ~ ~ minecraft:air
execute if block ~ ~-1 ~ minecraft:fire run setblock ~ ~-1 ~ minecraft:air
execute if block ~ ~-1 ~ minecraft:soul_fire run setblock ~ ~-1 ~ minecraft:air

# Success message
$tellraw @a[distance=..16] [{"text":"[Rituals] ","color":"gold","bold":true},{"text":"Fire sacrifice accepted! ","color":"red"},{"text":"(consumed 4x $(name) at corners)","color":"gray","italic":true}]

