/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.app;

import com.mcmlr.blocks.AppManager;
import com.mcmlr.blocks.api.CursorEvent;
import com.mcmlr.blocks.api.ScrollModel;
import com.mcmlr.blocks.api.app.BaseApp;
import com.mcmlr.blocks.api.app.BaseEnvironment;
import com.mcmlr.blocks.api.app.Environment;
import com.mcmlr.blocks.api.block.Block;
import com.mcmlr.blocks.api.block.Context;
import com.mcmlr.blocks.api.data.InputRepository;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ$\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010 \u001a\u00020'J \u0010(\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000*2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020%H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020%H\u0016J\b\u00100\u001a\u00020%H\u0016J\b\u00101\u001a\u00020\u0013H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lcom/mcmlr/blocks/api/app/App;", "Lcom/mcmlr/blocks/api/app/BaseApp;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "inputRepository", "Lcom/mcmlr/blocks/api/data/InputRepository;", "getInputRepository", "()Lcom/mcmlr/blocks/api/data/InputRepository;", "setInputRepository", "(Lcom/mcmlr/blocks/api/data/InputRepository;)V", "appManager", "Lcom/mcmlr/blocks/AppManager;", "getAppManager", "()Lcom/mcmlr/blocks/AppManager;", "setAppManager", "(Lcom/mcmlr/blocks/AppManager;)V", "configure", "", "environment", "Lcom/mcmlr/blocks/api/app/BaseEnvironment;", "parentApp", "deeplink", "", "origin", "Lorg/bukkit/Location;", "cursorEvent", "displays", "", "Lorg/bukkit/entity/Entity;", "cursor", "event", "Lcom/mcmlr/blocks/api/CursorEvent;", "scrollEvent", "Lcom/mcmlr/blocks/api/ScrollModel;", "isChild", "", "textInputEvent", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "launchApp", "app", "Lcom/mcmlr/blocks/api/app/Environment;", "close", "setScrollState", "isScrolling", "setInputState", "getInput", "hasParent", "routeBack", "block"})
public abstract class App
extends BaseApp {
    public InputRepository inputRepository;
    protected AppManager appManager;

    public App(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        super(player2);
    }

    @NotNull
    public final InputRepository getInputRepository() {
        InputRepository inputRepository = this.inputRepository;
        if (inputRepository != null) {
            return inputRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException("inputRepository");
        return null;
    }

    public final void setInputRepository(@NotNull InputRepository inputRepository) {
        Intrinsics.checkNotNullParameter(inputRepository, "<set-?>");
        this.inputRepository = inputRepository;
    }

    @NotNull
    protected final AppManager getAppManager() {
        AppManager appManager = this.appManager;
        if (appManager != null) {
            return appManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("appManager");
        return null;
    }

    protected final void setAppManager(@NotNull AppManager appManager) {
        Intrinsics.checkNotNullParameter(appManager, "<set-?>");
        this.appManager = appManager;
    }

    public final void configure(@NotNull AppManager appManager, @NotNull BaseEnvironment<? extends BaseApp> environment, @NotNull BaseApp parentApp, @NotNull InputRepository inputRepository, @Nullable String deeplink, @NotNull Location origin) {
        Intrinsics.checkNotNullParameter(appManager, "appManager");
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(parentApp, "parentApp");
        Intrinsics.checkNotNullParameter(inputRepository, "inputRepository");
        Intrinsics.checkNotNullParameter(origin, "origin");
        this.setAppManager(appManager);
        this.setParentEnvironment(environment);
        this.setParentApp(parentApp);
        this.setInputRepository(inputRepository);
        this.setDeeplink(deeplink);
        this.setOrigin(origin);
    }

    public final void cursorEvent(@NotNull List<? extends Entity> displays, @NotNull Location cursor, @NotNull CursorEvent event) {
        Intrinsics.checkNotNullParameter(displays, "displays");
        Intrinsics.checkNotNullParameter(cursor, "cursor");
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.getHead().cursorEvent(displays, cursor, event);
    }

    public final void scrollEvent(@NotNull ScrollModel event, boolean isChild) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.getHead().scrollEvent(event, isChild);
    }

    public static /* synthetic */ void scrollEvent$default(App app, ScrollModel scrollModel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollEvent");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        app.scrollEvent(scrollModel, bl);
    }

    public final void textInputEvent(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.getHead().textInputEvent(event);
    }

    @Override
    public void launchApp(@NotNull Environment<? extends App> app, @Nullable String deeplink) {
        Intrinsics.checkNotNullParameter(app, "app");
        this.getAppManager().launch(app, deeplink);
    }

    @Override
    public void close() {
        this.getAppManager().notifyShutdown();
        super.close();
    }

    @Override
    public void setScrollState(boolean isScrolling) {
        InputRepository inputRepository = this.getInputRepository();
        UUID uUID = this.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        inputRepository.updateUserScrollState(uUID, isScrolling);
    }

    @Override
    public void setInputState(boolean getInput) {
        InputRepository inputRepository = this.getInputRepository();
        UUID uUID = this.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        inputRepository.updateUserInputState(uUID, getInput);
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public void routeBack() {
        Block parent = this.getHead().getParent();
        if (parent == null) {
            this.onClose();
            this.getHead().onClose();
            this.clear();
            this.getAppManager().closeApp();
        } else {
            Context.onCreate$default(parent, false, 1, null);
            this.getHead().onClose();
            this.setHead(parent);
        }
    }
}

