/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.app;

import com.mcmlr.apps.app.block.data.Bundle;
import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.app.BaseEnvironment;
import com.mcmlr.blocks.api.block.Block;
import com.mcmlr.blocks.api.block.Context;
import com.mcmlr.blocks.core.FlowDisposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010,\u001a\u00020\nH&J\u000e\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u000e\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020.H\u0016J\b\u00103\u001a\u00020.H\u0016J\b\u00104\u001a\u00020.H\u0016J\b\u00105\u001a\u00020.H\u0016J\u0012\u00106\u001a\u00020.2\b\u00107\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u00108\u001a\u00020.H\u0016J\u0010\u00109\u001a\u00020.2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010:\u001a\u00020;H\u0016J&\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020\n2\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020.\u0018\u00010?H\u0016J\b\u0010A\u001a\u00020.H\u0016J\b\u0010B\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006="}, d2={"Lcom/mcmlr/blocks/api/app/BaseApp;", "Lcom/mcmlr/blocks/core/FlowDisposer;", "Lcom/mcmlr/blocks/api/block/Context;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "head", "Lcom/mcmlr/blocks/api/block/Block;", "getHead", "()Lcom/mcmlr/blocks/api/block/Block;", "setHead", "(Lcom/mcmlr/blocks/api/block/Block;)V", "origin", "Lorg/bukkit/Location;", "getOrigin", "()Lorg/bukkit/Location;", "setOrigin", "(Lorg/bukkit/Location;)V", "parentEnvironment", "Lcom/mcmlr/blocks/api/app/BaseEnvironment;", "getParentEnvironment", "()Lcom/mcmlr/blocks/api/app/BaseEnvironment;", "setParentEnvironment", "(Lcom/mcmlr/blocks/api/app/BaseEnvironment;)V", "parentApp", "getParentApp", "()Lcom/mcmlr/blocks/api/app/BaseApp;", "setParentApp", "(Lcom/mcmlr/blocks/api/app/BaseApp;)V", "deeplink", "", "getDeeplink", "()Ljava/lang/String;", "setDeeplink", "(Ljava/lang/String;)V", "resources", "Lcom/mcmlr/blocks/api/Resources;", "getResources", "()Lcom/mcmlr/blocks/api/Resources;", "setResources", "(Lcom/mcmlr/blocks/api/Resources;)V", "root", "create", "", "registerEvents", "eventHandler", "Lorg/bukkit/event/Listener;", "close", "minimize", "maximize", "onPause", "onResume", "newOrigin", "onClose", "setHeadBlock", "hasParent", "", "routeTo", "block", "callback", "Lkotlin/Function1;", "Lcom/mcmlr/apps/app/block/data/Bundle;", "routeBack", "getBlock"})
public abstract class BaseApp
extends FlowDisposer
implements Context {
    @NotNull
    private final Player player;
    protected Block head;
    protected Location origin;
    protected BaseEnvironment<? extends BaseApp> parentEnvironment;
    @Nullable
    private BaseApp parentApp;
    @Nullable
    private String deeplink;
    public Resources resources;

    public BaseApp(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        this.player = player2;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    protected final Block getHead() {
        Block block = this.head;
        if (block != null) {
            return block;
        }
        Intrinsics.throwUninitializedPropertyAccessException("head");
        return null;
    }

    protected final void setHead(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "<set-?>");
        this.head = block;
    }

    @NotNull
    protected final Location getOrigin() {
        Location location = this.origin;
        if (location != null) {
            return location;
        }
        Intrinsics.throwUninitializedPropertyAccessException("origin");
        return null;
    }

    protected final void setOrigin(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "<set-?>");
        this.origin = location;
    }

    @NotNull
    protected final BaseEnvironment<BaseApp> getParentEnvironment() {
        BaseEnvironment<BaseApp> baseEnvironment = this.parentEnvironment;
        if (baseEnvironment != null) {
            return baseEnvironment;
        }
        Intrinsics.throwUninitializedPropertyAccessException("parentEnvironment");
        return null;
    }

    protected final void setParentEnvironment(@NotNull BaseEnvironment<? extends BaseApp> baseEnvironment) {
        Intrinsics.checkNotNullParameter(baseEnvironment, "<set-?>");
        this.parentEnvironment = baseEnvironment;
    }

    @Nullable
    protected final BaseApp getParentApp() {
        return this.parentApp;
    }

    protected final void setParentApp(@Nullable BaseApp baseApp) {
        this.parentApp = baseApp;
    }

    @Nullable
    protected final String getDeeplink() {
        return this.deeplink;
    }

    protected final void setDeeplink(@Nullable String string) {
        this.deeplink = string;
    }

    @NotNull
    public final Resources getResources() {
        Resources resources = this.resources;
        if (resources != null) {
            return resources;
        }
        Intrinsics.throwUninitializedPropertyAccessException("resources");
        return null;
    }

    public final void setResources(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "<set-?>");
        this.resources = resources;
    }

    @NotNull
    public abstract Block root();

    public final void create(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        this.setResources(resources);
        Context.onCreate$default(this, false, 1, null);
        this.setHead(this.root());
        this.getHead().setContext(this);
        Context.onCreate$default(this.getHead(), false, 1, null);
    }

    @Override
    @Nullable
    public String deeplink() {
        return this.deeplink;
    }

    public final void registerEvents(@NotNull Listener eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.getResources().server().getPluginManager().registerEvents(eventHandler, (Plugin)this.getResources().plugin());
    }

    @Override
    public void close() {
        this.onClose();
        this.getHead().onClose();
        this.clear();
    }

    @Override
    public void minimize() {
        this.getHead().onPause();
    }

    @Override
    public void maximize() {
        this.getHead().onResume(this.player.getEyeLocation().clone());
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume(@Nullable Location newOrigin) {
    }

    @Override
    public void onClose() {
        this.clear();
    }

    @Override
    public void setHeadBlock(@NotNull Block head) {
        Intrinsics.checkNotNullParameter(head, "head");
        this.setHead(head);
        this.getHead().setContext(this);
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public void routeTo(@NotNull Block block, @Nullable Function1<? super Bundle, Unit> callback) {
        Intrinsics.checkNotNullParameter(block, "block");
        block.setParent(this.getHead());
        this.getHead().onClose();
        this.setHead(block);
        this.getHead().setContext(this);
        block.setResultCallback(callback);
        Context.onCreate$default(block, false, 1, null);
    }

    @Override
    public void routeBack() {
        Block parent = this.getHead().getParent();
        if (parent == null) {
            this.close();
        } else {
            Context.onCreate$default(parent, false, 1, null);
            this.getHead().onClose();
            this.setHead(parent);
        }
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this.getHead();
    }
}

