/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.market;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.market.MarketPresenter;
import com.mcmlr.system.products.market.MarketRepository;
import com.mcmlr.system.products.market.MyOffersBlock;
import com.mcmlr.system.products.market.OrderRepository;
import com.mcmlr.system.products.market.PurchaseBlock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mcmlr/system/products/market/MarketInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/market/MarketPresenter;", "myOffersBlock", "Lcom/mcmlr/system/products/market/MyOffersBlock;", "purchaseBlock", "Lcom/mcmlr/system/products/market/PurchaseBlock;", "marketRepository", "Lcom/mcmlr/system/products/market/MarketRepository;", "orderRepository", "Lcom/mcmlr/system/products/market/OrderRepository;", "<init>", "(Lcom/mcmlr/system/products/market/MarketPresenter;Lcom/mcmlr/system/products/market/MyOffersBlock;Lcom/mcmlr/system/products/market/PurchaseBlock;Lcom/mcmlr/system/products/market/MarketRepository;Lcom/mcmlr/system/products/market/OrderRepository;)V", "onCreate", "", "system"})
public final class MarketInteractor
extends Interactor {
    @NotNull
    private final MarketPresenter presenter;
    @NotNull
    private final MyOffersBlock myOffersBlock;
    @NotNull
    private final PurchaseBlock purchaseBlock;
    @NotNull
    private final MarketRepository marketRepository;
    @NotNull
    private final OrderRepository orderRepository;

    public MarketInteractor(@NotNull MarketPresenter presenter, @NotNull MyOffersBlock myOffersBlock, @NotNull PurchaseBlock purchaseBlock, @NotNull MarketRepository marketRepository, @NotNull OrderRepository orderRepository) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(myOffersBlock, "myOffersBlock");
        Intrinsics.checkNotNullParameter(purchaseBlock, "purchaseBlock");
        Intrinsics.checkNotNullParameter(marketRepository, "marketRepository");
        Intrinsics.checkNotNullParameter(orderRepository, "orderRepository");
        super(presenter);
        this.presenter = presenter;
        this.myOffersBlock = myOffersBlock;
        this.purchaseBlock = purchaseBlock;
        this.marketRepository = marketRepository;
        this.orderRepository = orderRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.presenter.setFeed(MarketRepository.getOrders$default(this.marketRepository, null, 1, null), arg_0 -> MarketInteractor.onCreate$lambda$0(this, arg_0));
        this.presenter.setSearchListener(arg_0 -> MarketInteractor.onCreate$lambda$2(this, arg_0));
        this.presenter.setMyOffersListener(() -> MarketInteractor.onCreate$lambda$3(this));
    }

    private static final Unit onCreate$lambda$0(MarketInteractor this$0, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.orderRepository.setPurchaseOrder(it);
        Interactor.routeTo$default(this$0, this$0.purchaseBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2$lambda$1(MarketInteractor this$0, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.orderRepository.setPurchaseOrder(it);
        Interactor.routeTo$default(this$0, this$0.purchaseBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(MarketInteractor this$0, String searchTerm) {
        Intrinsics.checkNotNullParameter(searchTerm, "searchTerm");
        this$0.presenter.setFeed(this$0.marketRepository.getOrders(searchTerm), arg_0 -> MarketInteractor.onCreate$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(MarketInteractor this$0) {
        Interactor.routeTo$default(this$0, this$0.myOffersBlock, null, 2, null);
        return Unit.INSTANCE;
    }
}

