/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.settings;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.settings.TeleportConfigPresenter;
import com.mcmlr.system.products.teleport.TeleportConfigRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mcmlr/system/products/settings/TeleportConfigInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/settings/TeleportConfigPresenter;", "teleportConfigRepository", "Lcom/mcmlr/system/products/teleport/TeleportConfigRepository;", "<init>", "(Lcom/mcmlr/system/products/settings/TeleportConfigPresenter;Lcom/mcmlr/system/products/teleport/TeleportConfigRepository;)V", "onCreate", "", "system"})
public final class TeleportConfigInteractor
extends Interactor {
    @NotNull
    private final TeleportConfigPresenter presenter;
    @NotNull
    private final TeleportConfigRepository teleportConfigRepository;

    public TeleportConfigInteractor(@NotNull TeleportConfigPresenter presenter, @NotNull TeleportConfigRepository teleportConfigRepository) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(teleportConfigRepository, "teleportConfigRepository");
        super(presenter);
        this.presenter = presenter;
        this.teleportConfigRepository = teleportConfigRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        int teleportDelay = this.teleportConfigRepository.delay();
        int cooldown = this.teleportConfigRepository.cooldown();
        this.presenter.updateDelayText(teleportDelay + " Second" + (teleportDelay != 1 ? "s" : ""));
        this.presenter.updateCooldownText(cooldown + " Second" + (cooldown != 1 ? "s" : ""));
        this.presenter.setDelayListener(arg_0 -> TeleportConfigInteractor.onCreate$lambda$0(this, arg_0));
        this.presenter.setCooldownListener(arg_0 -> TeleportConfigInteractor.onCreate$lambda$1(this, arg_0));
    }

    private static final Unit onCreate$lambda$0(TeleportConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer delay2 = StringsKt.toIntOrNull(it);
        if (delay2 == null) {
            int defaultDelay = this$0.teleportConfigRepository.delay();
            this$0.presenter.setMessage(ChatColor.RED + "Teleport delay values must be whole numbers!");
            this$0.presenter.updateDelayText(defaultDelay + " Second" + (defaultDelay != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int delaySeconds = Math.max(0, delay2);
        this$0.teleportConfigRepository.updateTeleportDelay(delaySeconds);
        this$0.presenter.updateDelayText(delaySeconds + " Second" + (delaySeconds != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(TeleportConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer delay2 = StringsKt.toIntOrNull(it);
        if (delay2 == null) {
            int defaultCooldown = this$0.teleportConfigRepository.cooldown();
            this$0.presenter.setMessage(ChatColor.RED + "Teleport cooldown values must be whole numbers!");
            this$0.presenter.updateCooldownText(defaultCooldown + " Second" + (defaultCooldown != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int delaySeconds = Math.max(0, delay2);
        this$0.teleportConfigRepository.updateTeleportCooldown(delaySeconds);
        this$0.presenter.updateCooldownText(delaySeconds + " Second" + (delaySeconds != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }
}

